/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.pubservice.hardware.Disk;
import com.huawei.ism.tool.framework.pubservice.hardware.DiskLocation;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.rest.context.InfoCollectCache;
import com.huawei.ism.tool.infocollect.ui.InfoCollectMainDialog;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.tool.pyengine.utils.PyJavaUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.python.core.PyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QryDiskPythonCallable
implements Callable<TreeMap<DiskLocation, Disk>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QryDiskPythonCallable.class);
    private Map<String, Object> collectEnv;
    private InfoCollectMainDialog collectMainDlg;
    private DevNode deviceNode;

    public QryDiskPythonCallable(InfoCollectMainDialog infoCollectMainDialog, DevNode deviceNode, Map<String, Object> collectEnv) {
        this.collectMainDlg = infoCollectMainDialog;
        this.collectEnv = collectEnv;
        this.deviceNode = deviceNode;
    }

    @Override
    public TreeMap<DiskLocation, Disk> call() {
        String qryDiskScriptPth = InfoConfiguration.getInstance().getPackagePath(this.getDevNode()) + File.separator + "script";
        String qryDiskPthName = FilePathUtils.checkFile((String)(qryDiskScriptPth + File.separator + "queryDisk.py"));
        int qryNum = 0;
        Map diskMap = null;
        TreeMap<DiskLocation, Disk> tm = new TreeMap<DiskLocation, Disk>();
        try {
            String failedEngins;
            List<Object> resultList = this.executePythonGetResult(qryDiskPthName);
            qryNum = Integer.valueOf((String)resultList.get(0));
            InfoCollectCache.getInstance().addDiskNum(this.deviceNode, qryNum);
            if (0 == qryNum) {
                ToolLoggerFactory.getLogger(this.getClass()).error("Calling python to query disk failed!");
                return tm;
            }
            if (resultList.size() > 2 && !StringUtils.isEmpty((CharSequence)(failedEngins = String.valueOf(resultList.get(2))))) {
                InfoCollectCache.getInstance().addFailEngine(this.deviceNode, failedEngins);
            }
            diskMap = (Map)resultList.get(1);
            Set locStrSet = diskMap.entrySet();
            for (Map.Entry<String, PyObject> entry : locStrSet) {
                this.process(diskMap, tm, entry);
            }
        }
        catch (SignException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("verify Script error!", (Throwable)e);
            return tm;
        }
        catch (FileNotFoundException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("py file {} not found!", (Object)"queryDisk.py");
            return tm;
        }
        catch (ToolException e) {
            LOGGER.error("Execute Py File error!", (Throwable)e);
            return tm;
        }
        catch (Exception e) {
            LOGGER.error("Execute Py Script error!", (Throwable)e);
            return tm;
        }
        return tm;
    }

    private List<Object> executePythonGetResult(String qryDiskPthName) throws FileNotFoundException, ToolException {
        JythonExecuter executer = this.getJythonExecuter(qryDiskPthName);
        return executer.invokeFunction("execute", this.collectEnv);
    }

    private DevNode getDevNode() {
        return (DevNode)this.collectEnv.get("devNode");
    }

    private JythonExecuter getJythonExecuter(String qryDiskPthName) throws FileNotFoundException {
        JythonExecuter executer = new JythonExecuter(new File(qryDiskPthName).getParentFile());
        executer.compileScript(new File(qryDiskPthName));
        return executer;
    }

    private void process(Map<String, PyObject> diskMap, TreeMap<DiskLocation, Disk> tm, Map.Entry<String, PyObject> locDiskTupEntry) {
        String diskIdKey = locDiskTupEntry.getKey();
        DiskLocation dl = diskIdKey.startsWith("DAE") || diskIdKey.startsWith("ENG") || diskIdKey.startsWith("CTE") ? new DiskLocation(diskIdKey, true) : new DiskLocation(locDiskTupEntry.getKey());
        List diskInfoList = PyJavaUtils.convertTuple2List((PyObject)diskMap.get(locDiskTupEntry.getKey()));
        tm.put(dl, new Disk(dl, (String)diskInfoList.get(2), (String)diskInfoList.get(3), (String)diskInfoList.get(1), (String)diskInfoList.get(4), (String)diskInfoList.get(5)));
    }
}

