/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.pubservice.hardware.DiskWithNode;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.rest.context.InfoCollectCache;
import com.huawei.ism.tool.infocollect.ui.InfoCollectMainDialog;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.tool.pyengine.utils.PyJavaUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.python.core.PyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDiskForNodeCallable
implements Callable<List<DiskWithNode>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryDiskForNodeCallable.class);
    private Map<String, Object> collectEnv;
    private DevNode deviceNode;
    private CollectItem item;

    public QueryDiskForNodeCallable(InfoCollectMainDialog infoCollectMainDialog, DevNode deviceNode, Map<String, Object> collectEnv, CollectItem chooseItem) {
        this.collectEnv = collectEnv;
        this.deviceNode = deviceNode;
        this.item = chooseItem;
    }

    @Override
    public List<DiskWithNode> call() {
        String executeScript = StringUtils.isNULLStr((String)this.item.getExecuteScript()) ? "queryDisk.py" : this.item.getExecuteScript();
        String qryDiskScriptPth = InfoConfiguration.getInstance().getPackagePath((DevNode)this.collectEnv.get("devNode")) + File.separator + "script";
        String qryDiskPthName = FilePathUtils.checkFile((String)(qryDiskScriptPth + File.separator + executeScript));
        int qryNum = 0;
        ArrayList<DiskWithNode> diskList = new ArrayList<DiskWithNode>();
        Map diskMap = null;
        try {
            JythonExecuter executer = new JythonExecuter(new File(qryDiskPthName).getParentFile());
            executer.compileScript(new File(qryDiskPthName));
            List resultList = executer.invokeFunction("execute", this.collectEnv);
            qryNum = Integer.parseInt((String)resultList.get(1));
            InfoCollectCache.getInstance().addDiskNum(this.deviceNode, qryNum);
            if (0 == qryNum) {
                LOGGER.error("Calling python to query disk failed!");
                return diskList;
            }
            diskMap = (Map)resultList.get(0);
            Set locStrSet = diskMap.entrySet();
            ArrayList diskSns = new ArrayList();
            for (Map.Entry locDiskTupEntry : locStrSet) {
                List diskInfoList = PyJavaUtils.convertTuple2List((PyObject)((PyObject)diskMap.get(locDiskTupEntry.getKey())));
                diskSns.add(locDiskTupEntry.getKey());
                DiskWithNode disk = new DiskWithNode();
                disk.setNodeName((String)diskInfoList.get(0));
                disk.setNodeId((String)diskInfoList.get(1));
                disk.setSlotId((String)diskInfoList.get(2));
                disk.setVendor((String)diskInfoList.get(3));
                disk.setDiskSn((String)diskInfoList.get(4));
                disk.setDiskType((String)diskInfoList.get(5));
                disk.setModel((String)diskInfoList.get(6));
                diskList.add(disk);
            }
            LOGGER.info("DiskWithNode sn lists:{}", diskSns);
        }
        catch (SignException e) {
            LOGGER.error("get device DiskWithNode info: verify Script error!", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("get device DiskWithNode info:py file {} not found!", (Object)executeScript);
        }
        catch (ToolException e) {
            LOGGER.error("get device DiskWithNode info:Execute Py File error!", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("get device DiskWithNode info:Execute Py Script error!", (Throwable)e);
        }
        return this.sortDiskWithNodeList(diskList);
    }

    private List<DiskWithNode> sortDiskWithNodeList(List<DiskWithNode> sourceList) {
        if (sourceList == null || sourceList.isEmpty()) {
            return new ArrayList<DiskWithNode>();
        }
        sourceList.sort((o1, o2) -> {
            String nodeIdO1 = o1.getNodeId();
            String soltIdO1 = o1.getSlotId();
            String nodeIdO2 = o2.getNodeId();
            String soltIdO2 = o2.getSlotId();
            if (!nodeIdO1.equals(nodeIdO2)) {
                return nodeIdO1.compareTo(nodeIdO2);
            }
            return soltIdO1.compareTo(soltIdO2);
        });
        return sourceList;
    }
}

