/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.tool.infocollect.entity.CollectScene;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectCollectSceneDialog
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(SelectCollectSceneDialog.class);
    private CollectScene chooseScene = CollectScene.DEFAULT_COLLECT;
    private JRadioButton defaultCollectBtn = new JRadioButton();
    private JRadioButton simpleCollectBtn = new JRadioButton();
    private ButtonGroup buttonGroup;
    private JButton okBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"collect.select.scene.confirm"), (char)'O');
    private JButton cancelBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"collect.select.scene.cancel"), (char)'C');

    public SelectCollectSceneDialog(JDialog parent) {
        super(parent);
        this.initJRadioBtnGrp();
        this.initListener();
        this.initChooseUI();
    }

    private void initChooseUI() {
        this.add(UiMethod.buildFrameSpace((JComponent)this.buildJComponent(), (int)12));
        this.setPreferredSize(new Dimension(320, 200));
        this.setModal(true);
        this.setResizable(false);
        this.validate();
        this.pack();
        this.setTitle(ResourceUtil.getString((String)"collect.select.scene.title"));
        SwingUtil.putScreenCenter((Window)this);
        this.setVisible(true);
    }

    private void initListener() {
        this.simpleCollectBtn.addActionListener(event -> {
            this.chooseScene = CollectScene.SIMPLE_COLLECT;
        });
        this.defaultCollectBtn.addActionListener(event -> {
            this.chooseScene = CollectScene.DEFAULT_COLLECT;
        });
        this.okBtn.addActionListener(event -> {
            log.info("user chose collect scene is: {}", (Object)this.chooseScene);
            this.dispose();
        });
        this.cancelBtn.addActionListener(event -> {
            this.chooseScene = CollectScene.NONE_SCENE;
            this.dispose();
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                SelectCollectSceneDialog.this.chooseScene = CollectScene.NONE_SCENE;
            }
        });
    }

    private JComponent buildJComponent() {
        JComponent btnComp = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalStrut(30), this.defaultCollectBtn, Box.createHorizontalStrut(20), this.simpleCollectBtn, Box.createHorizontalGlue()});
        return UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{Box.createVerticalStrut(10), btnComp, Box.createVerticalGlue(), UCD.buildHorizotalBox(null, (int)12, (Component[])new Component[]{Box.createHorizontalGlue(), this.okBtn, Box.createHorizontalStrut(12), this.cancelBtn, Box.createHorizontalGlue()})});
    }

    private void initJRadioBtnGrp() {
        this.defaultCollectBtn = new JRadioButton();
        this.simpleCollectBtn = new JRadioButton();
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.simpleCollectBtn);
        this.buttonGroup.add(this.defaultCollectBtn);
        this.defaultCollectBtn.setText(ResourceUtil.getString((String)"collect.select.scene.default"));
        this.simpleCollectBtn.setText(ResourceUtil.getString((String)"collect.select.scene.simple"));
        this.defaultCollectBtn.setSelected(true);
    }

    public CollectScene getChooseScene() {
        return this.chooseScene;
    }
}

