/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.pubservice.hardware.Disk;
import com.huawei.ism.tool.framework.pubservice.hardware.DiskLocation;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.config.CollectConfigParser;
import com.huawei.ism.tool.infocollect.ui.setup.CollectNewSetupDialog;
import com.huawei.ism.tool.infocollect.ui.setup.IntegrateCollectSetupDialog;
import com.huawei.ism.tool.infocollect.ui.setup.SelectDiskMainLayout;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckBoxTree;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardRootPaneUI;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectDiskMainDialog
extends JDialog {
    public static final int MAGIC_NUMBER750 = 750;
    private static final long serialVersionUID = 1L;
    private static final int MIN_SECS_PER_NORMAL_DISK = 10;
    private static final int MAX_SECS_PER_NORMAL_DISK = 60;
    private static final String DEFAULT_DISKLOG_INTERVAL = "60";
    private static final String DISKLOG_INTERVAL_CONFIG_NAME = "DiskLogCollectionInterval";
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectDiskMainDialog.class);
    private IntegrateCollectSetupDialog parentSetUpDlg = null;
    private CollectNewSetupDialog collectNewSetupDialog;
    private SelectDiskMainLayout selectDiskMainLayout = null;
    private WizardRootPaneUI rootPaneUI = new WizardRootPaneUI();
    private boolean normlDiskLogItemPreviousChecked = false;
    private DevNode devNode;
    private CheckTreeNode normalDiskLogItemNode;
    private CheckBoxTree itemTree;
    private List<DiskLocation> cacheSelectedDiskLocs;

    public SelectDiskMainDialog(IntegrateCollectSetupDialog parent, TreeMap<DiskLocation, Disk> tm, boolean normalDiskLogItemChecked, boolean isAllDiskDetailInfoGot, boolean isDiskLocationShown) {
        super((Dialog)((Object)parent));
        this.normlDiskLogItemPreviousChecked = normalDiskLogItemChecked;
        this.parentSetUpDlg = parent;
        this.devNode = parent.getDeviceNode();
        this.normalDiskLogItemNode = parent.getNormalDiskLogItemNode();
        this.itemTree = parent.getCollectlayout().getItemTree();
        this.cacheSelectedDiskLocs = parent.getSelectedDiskLocs();
        this.initUI(isAllDiskDetailInfoGot, isDiskLocationShown);
        this.addListener();
        this.initDiskTableData(tm);
    }

    public SelectDiskMainDialog(CollectNewSetupDialog parent, TreeMap<DiskLocation, Disk> disks, boolean isAllDiskDetailInfoGot, boolean isDiskLocationShown) {
        super((Dialog)((Object)parent));
        this.collectNewSetupDialog = parent;
        this.devNode = parent.getDevNode();
        this.normalDiskLogItemNode = parent.getNormalDiskLogItemNode();
        this.itemTree = parent.getCollectNewSetupLayout().getItemTree();
        this.cacheSelectedDiskLocs = parent.getSelectedDiskLocs();
        this.initUI(isAllDiskDetailInfoGot, isDiskLocationShown);
        this.addListener();
        this.initDiskTableData(disks);
    }

    private void initDiskTableData(TreeMap<DiskLocation, Disk> tm) {
        if (null == tm || tm.isEmpty()) {
            LOGGER.error("Empty disk data, quering disk may failed.");
            return;
        }
        IsmTable diskTable = this.selectDiskMainLayout.getDiskTable();
        diskTable.removeAll();
        Set<DiskLocation> locSet = tm.keySet();
        if (locSet.isEmpty()) {
            LOGGER.error("Empty disk data, quering disk may failed.");
            this.selectDiskMainLayout.getConfirmButton().setEnabled(false);
            return;
        }
        this.selectDiskMainLayout.getConfirmButton().setEnabled(true);
        for (DiskLocation dl : locSet) {
            Disk disk = tm.get(dl);
            TableRow<Disk, DiskLocation> row = this.constructDiskTableRow(dl, disk);
            this.selectDiskMainLayout.getDiskTableModel().addRow(new TableRow[]{row});
            if (!this.isDiskSelected(dl)) continue;
            this.selectDiskMainLayout.getDiskTable().markTableRow(new TableRow[]{row});
        }
        this.selectDiskMainLayout.getDiskTable().updateUI();
    }

    private int getDiksLogCollectionInterval() {
        String intervalConfig = CollectConfigParser.getConfigureValue(DISKLOG_INTERVAL_CONFIG_NAME, DEFAULT_DISKLOG_INTERVAL);
        LOGGER.info("current configuration for disk log collection interval:{}", (Object)StringUtils.getCleanMessage((String)intervalConfig));
        int interval = Integer.parseInt(DEFAULT_DISKLOG_INTERVAL);
        try {
            interval = Integer.parseInt(intervalConfig);
            if (interval < 0) {
                String msg = "current setting for disk log collection interval is not a integer upper than zero, using default as 60 seconds.";
                LOGGER.info(msg);
                interval = Integer.parseInt(DEFAULT_DISKLOG_INTERVAL);
            }
        }
        catch (Exception exp) {
            LOGGER.error("cannot parse disk log collection interval as an integer, using default");
        }
        return interval;
    }

    private boolean isDiskSelected(DiskLocation dl) {
        if (this.cacheSelectedDiskLocs.isEmpty()) {
            return CollectDataContext.getInstance().getGlobalConDiskHashMap().get(this.devNode).get(dl).isChecked();
        }
        return this.cacheSelectedDiskLocs.contains(dl);
    }

    private TableRow<Disk, DiskLocation> constructDiskTableRow(DiskLocation dl, Disk disk) {
        DefaultTableRow row = new DefaultTableRow(this.selectDiskMainLayout.getDiskTableModel().getColumnCount(), (Object)disk, (Object)disk.getDiskLocation());
        int index = 0;
        row.setValueAt(index++, (Object)disk.getDiskLocation().toString());
        row.setValueAt(index++, (Object)disk.getVendor());
        row.setValueAt(index++, (Object)disk.getModelNum());
        row.setValueAt(index++, (Object)disk.getDiskSn());
        row.setValueAt(index++, (Object)disk.getDiskType());
        row.setValueAt(index++, (Object)disk.getDiskName());
        return row;
    }

    private void initUI(boolean isAllDiskDetailInfoGot, boolean isDiskLocationShown) {
        this.selectDiskMainLayout = this.parentSetUpDlg == null ? new SelectDiskMainLayout(this.collectNewSetupDialog, isAllDiskDetailInfoGot, isDiskLocationShown) : new SelectDiskMainLayout(this.parentSetUpDlg, isAllDiskDetailInfoGot, isDiskLocationShown);
        this.setLayout(new BorderLayout());
        this.add(this.selectDiskMainLayout);
        this.setTitle(ResourceUtil.getString((String)"disk_select_dialog_title"));
        this.setModal(true);
        this.setResizable(false);
        this.add(this.selectDiskMainLayout);
        this.validate();
        this.pack();
        this.setSize(new Dimension(750, 530));
        this.setDefaultCloseOperation(0);
        SwingUtil.putScreenCenter((Window)this);
    }

    public void setHelpActionCallBack(IHelpActionCallBack helpActionCallBack) {
        this.rootPaneUI.setHelpActionCallBack(helpActionCallBack);
    }

    private List<DiskLocation> getSelectedDiskLocationsFromDiskTable() {
        List selectRows = this.selectDiskMainLayout.getDiskTable().getMarkedRows();
        ArrayList<DiskLocation> locList = new ArrayList<DiskLocation>();
        for (TableRow row : selectRows) {
            DiskLocation loc = (DiskLocation)row.getIdentifier();
            locList.add(loc);
        }
        return locList;
    }

    private void updateCheckItemTreeUI() {
        this.normalDiskLogItemNode.setSelected(!this.cacheSelectedDiskLocs.isEmpty());
        this.itemTree.updateUI();
    }

    private void closeDiskSelDlg() {
        this.updateCheckItemTreeUI();
        this.setDefaultCloseOperation(2);
        this.dispose();
    }

    private void addListener() {
        this.selectDiskMainLayout.getConfirmButton().addActionListener(new ConfirmListener());
        this.selectDiskMainLayout.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectDiskMainDialog.this.closeOrCancelDiskSelectDlg();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                SelectDiskMainDialog.this.closeOrCancelDiskSelectDlg();
            }
        });
    }

    private void closeOrCancelDiskSelectDlg() {
        WarningDialog wdialog = DialogUtils.createWarningDialog((JDialog)this, (String)ResourceUtil.getString((String)"exit.select.disk.dialog.confirm.msg"));
        if (0 == wdialog.getValue()) {
            this.updateCheckItemTreeUIForCloseOrCanncled();
            this.cacheSelectedDiskLocs.clear();
            this.setDefaultCloseOperation(2);
            this.dispose();
        }
    }

    private void updateCheckItemTreeUIForCloseOrCanncled() {
        TreeMap<DiskLocation, Disk> diskTreeMap = CollectDataContext.getInstance().getGlobalConDiskHashMap().get(this.devNode);
        Iterator<DiskLocation> locSetItr = diskTreeMap.keySet().iterator();
        this.normalDiskLogItemNode.setSelected(false);
        while (locSetItr.hasNext()) {
            if (!diskTreeMap.get(locSetItr.next()).isChecked()) continue;
            this.normalDiskLogItemNode.setSelected(true);
        }
        this.itemTree.updateUI();
    }

    public DevNode getCurrentChosenDevNode() {
        int[] rows = this.selectDiskMainLayout.getDiskTable().getSelectedRows();
        if (rows.length == 0) {
            return null;
        }
        int index = this.selectDiskMainLayout.getDiskTable().convertRowIndexToModel(rows[0]);
        TableRow row = this.selectDiskMainLayout.getDiskTableModel().getRow(index);
        return (DevNode)row.getUserObject();
    }

    public SelectDiskMainLayout getInfoCollectMainLayout() {
        return this.selectDiskMainLayout;
    }

    public void setInfoCollectMainLayout(SelectDiskMainLayout selectdiskMainLayout) {
        this.selectDiskMainLayout = selectdiskMainLayout;
    }

    public boolean isNormlDiskLogItemPreviousChecked() {
        return this.normlDiskLogItemPreviousChecked;
    }

    public void setNormlDiskLogItemPreviousChecked(boolean normlDiskLogItemPreviousChecked) {
        this.normlDiskLogItemPreviousChecked = normlDiskLogItemPreviousChecked;
    }

    private class ConfirmListener
    implements ActionListener {
        private ConfirmListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List selLocList = SelectDiskMainDialog.this.getSelectedDiskLocationsFromDiskTable();
            if (SelectDiskMainDialog.this.parentSetUpDlg == null) {
                SelectDiskMainDialog.this.collectNewSetupDialog.setSelectedDiskLocs(selLocList);
            } else {
                SelectDiskMainDialog.this.parentSetUpDlg.setSelectedDiskLocs(selLocList);
            }
            SelectDiskMainDialog.this.cacheSelectedDiskLocs = selLocList;
            SelectDiskMainDialog.this.closeDiskSelDlg();
        }
    }
}

