/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.tool.framework.pubservice.entity.enums.SVPModuleInfo;
import com.huawei.ism.tool.infocollect.ui.setup.CollectNewSetupDialog;
import com.huawei.ism.tool.infocollect.ui.setup.IntegrateCollectSetupDialog;
import com.huawei.ism.tool.infocollect.ui.support.DetailListCellRenderer;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.DeviceTypeUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;

public class SelectDiskMainLayout
extends JPanel {
    private static final long serialVersionUID = 1L;
    private IntegrateCollectSetupDialog parentDialog = null;
    private IsmTable diskTable = null;
    private DefaultTableModel diskTableModel = null;
    private JButton confirmButton = UiMethod.createButton((String)ResourceUtil.getString((String)"disk_select_dialog_confirm.btn.name"), (char)'O');
    private JButton cancelButton = UiMethod.createButton((String)ResourceUtil.getString((String)"disk_select_dialog_cancel.btn.name"), (char)'C');
    private JList detailList = null;
    private DefaultListModel detailListMode = null;
    private JScrollPane detailListScrolPane = null;
    private DevNode devNode;
    private String[] tableHeaders = new String[]{ResourceUtil.getString((String)"disktable_diskLocation_column_name"), ResourceUtil.getString((String)"disktable_verderName_column_name"), ResourceUtil.getString((String)"disktable_diskModel_column_name"), ResourceUtil.getString((String)"disktable_diskSN_column_name"), ResourceUtil.getString((String)"disktable_diskType_column_name"), ResourceUtil.getString((String)"disktable_diskName_column_name")};

    public SelectDiskMainLayout(CollectNewSetupDialog collectNewSetupDialog, boolean isAllDiskDetailInfoGot, boolean isDiskLocationShown) {
        this.devNode = collectNewSetupDialog.getDevNode();
        this.initComponent(isDiskLocationShown);
        this.layoutComponents(isAllDiskDetailInfoGot);
    }

    public SelectDiskMainLayout(IntegrateCollectSetupDialog parentSetUpDlg, boolean isAllDiskDetailInfoGot, boolean isDiskLocationShown) {
        this.parentDialog = parentSetUpDlg;
        this.devNode = parentSetUpDlg.getDeviceNode();
        this.initComponent(isDiskLocationShown);
        this.layoutComponents(isAllDiskDetailInfoGot);
    }

    private void initComponent(boolean isDiskLocationShown) {
        this.createDiskTable(isDiskLocationShown);
        this.detailListMode = new DefaultListModel();
        this.detailList = new JList(this.detailListMode);
        this.detailList.setCellRenderer(new DetailListCellRenderer());
        this.detailList.setSelectionMode(0);
    }

    private void createDiskTable(boolean isDiskLocationShown) {
        if (!isDiskLocationShown) {
            this.tableHeaders[0] = ResourceUtil.getString((String)"disktable_diskId_column_name");
        }
        this.diskTableModel = new DefaultTableModel(this.tableHeaders, new int[0]);
        this.diskTable = new IsmTable((TableModel)this.diskTableModel);
    }

    private void layoutComponents(boolean isAllDiskDetailInfoGot) {
        JComponent view;
        JPanel bottomPanel = new JPanel();
        bottomPanel.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), 39));
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.add(Box.createHorizontalGlue());
        bottomPanel.add(this.confirmButton);
        bottomPanel.add(Box.createHorizontalStrut(10));
        bottomPanel.add(this.cancelButton);
        this.confirmButton.setEnabled(false);
        TableScrollPane deviceTableScroll = new TableScrollPane(this.diskTable, false, false, true);
        this.diskTable.setSelectionMode(2);
        if (!isAllDiskDetailInfoGot) {
            Locale locale = ApplicationContext.getInstance().getCurrentLanguage();
            JComponent infoComp = this.getWarningTips(locale);
            view = UCD.buildVerticalBox(null, (Component[])new Component[]{infoComp, Box.createVerticalGlue(), deviceTableScroll, bottomPanel});
        } else {
            view = UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalGlue(), deviceTableScroll, bottomPanel});
        }
        this.setLayout(new BorderLayout());
        this.add((Component)UiMethod.buildFrameSpace((JComponent)view, (int)12), "Center");
    }

    private JComponent getWarningTips(Locale locale) {
        JComponent infoComp = locale.getLanguage().equals(new Locale("en").getLanguage()) ? (this.isHighEndDevice() ? UiMethod.buildFrameSpace((JComponent)UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildLeftLabel((String)ResourceUtil.getString((String)"disk.sel.dlg.qry.partial.disk.high.end01")), UiMethod.buildLeftLabel((String)ResourceUtil.getString((String)"disk.sel.dlg.qry.partial.disk.high.end02"))}), (int)0) : UiMethod.buildFrameSpace((JComponent)UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildLeftLabel((String)ResourceUtil.getString((String)"disk.sel.dlg.qry.partial.disk1")), UiMethod.buildLeftLabel((String)ResourceUtil.getString((String)"disk.sel.dlg.qry.partial.disk2")), UiMethod.buildLeftLabel((String)ResourceUtil.getString((String)"disk.sel.dlg.qry.partial.disk3"))}), (int)0)) : (this.isHighEndDevice() ? UiMethod.buildFrameSpace((JComponent)UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildLeftLabel((String)ResourceUtil.getString((String)"disk.sel.dlg.qry.partial.disk.high.end"))}), (int)0) : UiMethod.buildFrameSpace((JComponent)UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildLeftLabel((String)ResourceUtil.getString((String)"disk.sel.dlg.qry.partial.disk"))}), (int)0));
        return infoComp;
    }

    private boolean isHighEndDevice() {
        String devTypeStr = this.devNode.getDeviceType().toString();
        boolean is18000DevType = false;
        is18000DevType = SVPModuleInfo.OLD_TOOLBOX.getName().equalsIgnoreCase(this.devNode.getHighDevSVPModuleInfo()) ? DeviceTypeUtil.isDeviceHasSVPModule((String)this.devNode.getProductVersion(), (String)this.devNode.getDeviceType().toString()) : DeviceTypeUtil.isDeviceHasSVPModule((String)this.devNode.getProductVersion(), (String)this.devNode.getDeviceType().toString(), (boolean)SVPModuleInfo.NEW_TOOLBOX_HASSVP.getName().equalsIgnoreCase(this.devNode.getHighDevSVPModuleInfo()));
        return is18000DevType && !LocalHostUtil.isRunInSvp();
    }

    public JList getDetailList() {
        return this.detailList;
    }

    public JScrollPane getDetailListScrolPane() {
        return this.detailListScrolPane;
    }

    public DefaultListModel getDetailListMode() {
        return this.detailListMode;
    }

    public void setDetailListMode(DefaultListModel detailListMode) {
        this.detailListMode = detailListMode;
    }

    public JButton getConfirmButton() {
        return this.confirmButton;
    }

    public void setConfirmButton(JButton confirmButton) {
        this.confirmButton = confirmButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public void setCancelButton(JButton cancelButton) {
        this.cancelButton = cancelButton;
    }

    public IsmTable getDiskTable() {
        return this.diskTable;
    }

    public void setDiskTable(IsmTable diskTable) {
        this.diskTable = diskTable;
    }

    public DefaultTableModel getDiskTableModel() {
        return this.diskTableModel;
    }

    public void setDiskTableModel(DefaultTableModel diskTableModel) {
        this.diskTableModel = diskTableModel;
    }
}

