/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.tool.framework.pubservice.hardware.DiskWithNode;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.ui.card.storage.OceanStor9000ItemSelectionCard;
import com.huawei.ism.tool.infocollect.ui.setup.IntegrateCollectSetupDialog;
import com.huawei.ism.tool.infocollect.ui.support.DetailListCellRenderer;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.EndChangeListener;
import com.huawei.ism.ui.swing.table.IsmAbstractTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectDiskWithNodeDialog
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(SelectDiskWithNodeDialog.class);
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectDiskWithNodeDialog.class);
    private static final int MAGIC_NUMBER750 = 750;
    private static final String BATCH_FLAG = "batchFlag";
    private static final String ADD_FLAG = "addFlag";
    private static final String FROM_FILTER = "fromFilter";
    SelectDiskWithNodeDialogLayout layout = null;
    private boolean clearAllChecked = false;
    private IntegrateCollectSetupDialog parentSetUpDlg = null;
    private DevNode devNode;
    private OceanStor9000ItemSelectionCard oceanStor9000ItemSelectionCard;
    private List<TableRow> selectRows = new ArrayList<TableRow>();

    public SelectDiskWithNodeDialog(IntegrateCollectSetupDialog parent, List<DiskWithNode> disks, boolean clearAllChecked, String highWarning) {
        super((Dialog)((Object)parent));
        this.parentSetUpDlg = parent;
        this.devNode = parent.getDeviceNode();
        this.init(disks, clearAllChecked, highWarning);
    }

    public SelectDiskWithNodeDialog(ToolWizardDialog parent, OceanStor9000ItemSelectionCard card, List<DiskWithNode> disks, boolean shouldClearAllChecked, String highWarning) {
        super((Dialog)parent);
        this.oceanStor9000ItemSelectionCard = card;
        this.devNode = card.getDevNode();
        this.init(disks, shouldClearAllChecked, highWarning);
    }

    private void init(List<DiskWithNode> disks, boolean shouldClearAllChecked, String highWarning) {
        this.clearAllChecked = shouldClearAllChecked;
        this.initUI(highWarning);
        this.addListener();
        this.initData(disks);
    }

    private void initUI(String highWarning) {
        this.layout = this.parentSetUpDlg == null ? new SelectDiskWithNodeDialogLayout(highWarning) : new SelectDiskWithNodeDialogLayout(this.parentSetUpDlg, highWarning);
        this.setLayout(new BorderLayout());
        this.add(this.layout);
        this.setTitle(ResourceUtil.getString((String)"disk_select_dialog_title"));
        this.setModal(true);
        this.setResizable(false);
        this.add(this.layout);
        this.validate();
        this.pack();
        this.setSize(new Dimension(750, 530));
        this.setDefaultCloseOperation(0);
        SwingUtil.putScreenCenter((Window)this);
    }

    private void initData(List<DiskWithNode> disks) {
        List<DiskWithNode> selectedDisks;
        if (disks == null || disks.isEmpty()) {
            LOGGER.error("Empty disk data, quering disk may failed.");
            this.layout.getConfirmButton().setEnabled(false);
            return;
        }
        IsmTable diskTable = this.layout.getDiskTable();
        diskTable.removeAll();
        this.layout.getConfirmButton().setEnabled(true);
        List<DiskWithNode> list = selectedDisks = this.parentSetUpDlg == null ? this.oceanStor9000ItemSelectionCard.getSelectedDiskWithNode() : this.parentSetUpDlg.getSelectedDiskWithNode();
        if (selectedDisks == null || selectedDisks.isEmpty()) {
            selectedDisks = CollectDataContext.getInstance().getSelectedDiskWithNodeForPython(this.devNode);
        }
        for (DiskWithNode disk : disks) {
            TableRow<String, DiskWithNode> row = this.constructDiskTableRow(disk);
            this.layout.getDiskTableModel().addRow(new TableRow[]{row});
            if (this.clearAllChecked || !CollectDataContext.getInstance().isDiskLastChecked(disk, selectedDisks)) continue;
            this.layout.getDiskTable().markTableRow(new TableRow[]{row});
            this.selectRows.add(row);
        }
        this.layout.getDiskTable().updateUI();
    }

    private void addListener() {
        this.layout.getConfirmButton().addActionListener(new ConfirmListener());
        this.layout.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectDiskWithNodeDialog.this.closeOrCancelDiskSelectDlg();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                SelectDiskWithNodeDialog.this.closeOrCancelDiskSelectDlg();
            }
        });
        this.addClickAndFilterChangeListener();
    }

    private void addClickAndFilterChangeListener() {
        this.layout.getDiskTable().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                StackTraceElement[] mStacks = Thread.currentThread().getStackTrace();
                Map batchCheck = SelectDiskWithNodeDialog.this.confirmActionType(mStacks);
                if (((Boolean)batchCheck.get(SelectDiskWithNodeDialog.FROM_FILTER)).booleanValue()) {
                    return;
                }
                boolean batchClick = (Boolean)batchCheck.get(SelectDiskWithNodeDialog.BATCH_FLAG);
                DefaultListSelectionModel defaultModel = null;
                if (!(event.getSource() instanceof DefaultListSelectionModel)) {
                    return;
                }
                defaultModel = (DefaultListSelectionModel)event.getSource();
                if (null == defaultModel) {
                    return;
                }
                TableModel model = SelectDiskWithNodeDialog.this.layout.getDiskTable().getModel();
                if (model instanceof IsmAbstractTableModel) {
                    IsmAbstractTableModel tableModel = (IsmAbstractTableModel)model;
                    if (batchClick) {
                        SelectDiskWithNodeDialog.this.rebuildBatchCheck(tableModel, (Boolean)batchCheck.get(SelectDiskWithNodeDialog.ADD_FLAG));
                    } else {
                        SelectDiskWithNodeDialog.this.rebuildSingleCheck(defaultModel, tableModel);
                    }
                }
            }
        });
        this.layout.getDeviceTableScroll().getFilterFiled().addEndChangeListener(new EndChangeListener(){

            public void endStateChanged(ChangeEvent e) {
                SelectDiskWithNodeDialog.this.layout.getDiskTable().markTableRow(SelectDiskWithNodeDialog.this.selectRows.toArray(new TableRow[SelectDiskWithNodeDialog.this.selectRows.size()]));
            }
        });
    }

    private void rebuildBatchCheck(IsmAbstractTableModel tableModel, boolean addFlag) {
        if (addFlag) {
            List rows = this.layout.getDiskTable().getMarkedRows();
            this.batchDealSelectedRows(rows, true);
        } else {
            for (int i = 0; i < this.layout.getDiskTable().getRowCount(); ++i) {
                int modelIndex = this.layout.getDiskTable().convertRowIndexToModel(i);
                TableRow currentRows = tableModel.getRow(modelIndex);
                this.removeRowFromSelectRows(currentRows);
            }
        }
    }

    private void rebuildSingleCheck(DefaultListSelectionModel defaultModel, IsmAbstractTableModel tableModel) {
        int clickedRowIndex = defaultModel.getLeadSelectionIndex();
        if (clickedRowIndex == -1) {
            return;
        }
        boolean selectRowAction = defaultModel.isSelectedIndex(clickedRowIndex);
        int modelIndex = 0;
        try {
            modelIndex = this.layout.getDiskTable().convertRowIndexToModel(clickedRowIndex);
        }
        catch (IndexOutOfBoundsException exception) {
            return;
        }
        if (modelIndex == -1) {
            return;
        }
        TableRow currentRow = tableModel.getRow(modelIndex);
        if (null == currentRow) {
            return;
        }
        if (selectRowAction) {
            this.addToSelectedRows(currentRow);
        } else {
            this.removeRowFromSelectRows(currentRow);
        }
    }

    private void batchDealSelectedRows(List<TableRow> rows, boolean addFlag) {
        if (null == rows || rows.isEmpty()) {
            return;
        }
        for (TableRow row : rows) {
            if (addFlag) {
                this.addToSelectedRows(row);
                continue;
            }
            this.removeRowFromSelectRows(row);
        }
    }

    private void addToSelectedRows(TableRow row) {
        if (null == this.selectRows) {
            this.selectRows = new ArrayList<TableRow>();
        }
        if (!this.selectRows.contains(row)) {
            this.selectRows.add(row);
        }
    }

    private void removeRowFromSelectRows(TableRow row) {
        if (null == this.selectRows || this.selectRows.isEmpty()) {
            return;
        }
        this.selectRows.remove(row);
    }

    private Map<String, Boolean> confirmActionType(StackTraceElement[] mStacks) {
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        resultMap.put(BATCH_FLAG, false);
        resultMap.put(ADD_FLAG, false);
        resultMap.put(FROM_FILTER, false);
        for (StackTraceElement s : mStacks) {
            if (!s.getClassName().contains("KeywordFilterField")) continue;
            resultMap.put(BATCH_FLAG, false);
            resultMap.put(ADD_FLAG, false);
            resultMap.put(FROM_FILTER, true);
            return resultMap;
        }
        for (StackTraceElement s : mStacks) {
            if (s.getMethodName().equals("selectAll")) {
                resultMap.put(BATCH_FLAG, true);
                resultMap.put(ADD_FLAG, true);
                break;
            }
            if (!s.getMethodName().equals("clearSelection")) continue;
            resultMap.put(BATCH_FLAG, true);
            resultMap.put(ADD_FLAG, false);
            break;
        }
        return resultMap;
    }

    private List<DiskWithNode> getSelectedDiskLocationsFromDiskTable() {
        ArrayList<DiskWithNode> locList = new ArrayList<DiskWithNode>();
        for (TableRow row : this.selectRows) {
            DiskWithNode loc = (DiskWithNode)row.getIdentifier();
            locList.add(loc);
        }
        return locList;
    }

    private void closeOrCancelDiskSelectDlg() {
        WarningDialog wdialog = DialogUtils.createWarningDialog((JDialog)this, (String)ResourceUtil.getString((String)"exit.select.disk.dialog.confirm.msg"));
        if (0 == wdialog.getValue()) {
            if (this.parentSetUpDlg == null) {
                this.updateNewSceneItemTree();
            } else {
                this.updateItemTree();
            }
            this.dispose();
        }
    }

    private void updateNewSceneItemTree() {
        if (!this.oceanStor9000ItemSelectionCard.getSelectedDiskWithNode().isEmpty() || CollectDataContext.getInstance().isDiskWithNodeChecked(this.devNode)) {
            log.info("Disk information has been selected.");
            return;
        }
        this.oceanStor9000ItemSelectionCard.getNormalDiskLogItemNode().setSelected(false);
        this.oceanStor9000ItemSelectionCard.getCollectlayout().getItemTree().updateUI();
    }

    private void updateItemTree() {
        if (!this.parentSetUpDlg.getSelectedDiskWithNode().isEmpty() || CollectDataContext.getInstance().isDiskWithNodeChecked(this.devNode)) {
            log.info("Disk information has been selected.");
            return;
        }
        this.parentSetUpDlg.getNormalDiskLogItemNode().setSelected(false);
        this.parentSetUpDlg.getCollectlayout().getItemTree().updateUI();
    }

    private TableRow<String, DiskWithNode> constructDiskTableRow(DiskWithNode disk) {
        DefaultTableRow row = new DefaultTableRow(this.layout.getDiskTableModel().getColumnCount(), (Object)disk.getDiskSn(), (Object)disk);
        int i = 0;
        row.setValueAt(i++, (Object)disk.getNodeName());
        row.setValueAt(i++, (Object)disk.getNodeId());
        row.setValueAt(i++, (Object)disk.getSlotId());
        row.setValueAt(i++, (Object)disk.getVendor());
        row.setValueAt(i++, (Object)disk.getDiskSn());
        row.setValueAt(i++, (Object)disk.getDiskType());
        row.setValueAt(i++, (Object)disk.getModel());
        return row;
    }

    public class SelectDiskWithNodeDialogLayout
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private IntegrateCollectSetupDialog parentDialog = null;
        private IsmTable diskTable = null;
        private DefaultTableModel diskTableModel = null;
        private TableScrollPane deviceTableScroll = null;
        private String[] tableHeaders = new String[]{ResourceUtil.getString((String)"disktable_diskLocation_column_name.nodeName"), ResourceUtil.getString((String)"disktable.disk_table_column_name.diskwithnode.nodeID"), ResourceUtil.getString((String)"disktable_diskLocation_column_name.diskSlotNumber"), ResourceUtil.getString((String)"disktable_diskLocation_column_name.verderName"), ResourceUtil.getString((String)"disktable_diskLocation_column_name.diskSN"), ResourceUtil.getString((String)"disktable_diskLocation_column_name.diskType"), ResourceUtil.getString((String)"disktable_diskLocation_column_name.diskModel")};
        private JButton confirmButton = UiMethod.createButton((String)ResourceUtil.getString((String)"disk_select_dialog_confirm.btn.name"), (char)'O');
        private JButton cancelButton = UiMethod.createButton((String)ResourceUtil.getString((String)"disk_select_dialog_cancel.btn.name"), (char)'C');
        private JList detailList = null;
        private DefaultListModel detailListMode = null;
        private JLabel warningLabel = new JLabel("");
        private String waringInfo = "";

        public SelectDiskWithNodeDialogLayout(IntegrateCollectSetupDialog parentSetUpDlg, String warning) {
            this.waringInfo = warning;
            this.parentDialog = parentSetUpDlg;
            this.initComponent();
            this.initLayoutUI();
        }

        public SelectDiskWithNodeDialogLayout(String warning) {
            this(null, warning);
        }

        private void initComponent() {
            this.warningLabel.setVisible(false);
            if (!StringUtils.isNULLStr((String)this.waringInfo)) {
                this.warningLabel.setText(this.waringInfo);
                this.warningLabel.setForeground(Color.RED);
                this.warningLabel.setVisible(true);
            }
            this.confirmButton.setVisible(true);
            this.cancelButton.setVisible(true);
            this.createDiskSelectTable();
            this.detailListMode = new DefaultListModel();
            this.detailList = new JList(this.detailListMode);
            this.detailList.setCellRenderer(new DetailListCellRenderer());
            this.detailList.setSelectionMode(0);
        }

        private void initLayoutUI() {
            JPanel bottomPanel = new JPanel();
            bottomPanel.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), 39));
            bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
            bottomPanel.add(Box.createHorizontalGlue());
            bottomPanel.add(this.confirmButton);
            bottomPanel.add(Box.createHorizontalStrut(10));
            bottomPanel.add(this.cancelButton);
            this.confirmButton.setEnabled(false);
            this.deviceTableScroll = new TableScrollPane(this.diskTable, false, false, true);
            this.deviceTableScroll.getFilterFiled().setClearSelection(false);
            JComponent infoComp = null;
            JComponent view = null;
            if (!StringUtils.isNULLStr((String)this.waringInfo)) {
                infoComp = this.getWarningTips();
                view = UCD.buildVerticalBox(null, (Component[])new Component[]{infoComp, Box.createVerticalGlue(), this.deviceTableScroll, bottomPanel});
            } else {
                view = UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalGlue(), this.deviceTableScroll, bottomPanel});
            }
            this.setLayout(new BorderLayout());
            this.add((Component)UiMethod.buildFrameSpace((JComponent)view, (int)12), "Center");
        }

        private void createDiskSelectTable() {
            this.diskTableModel = new DefaultTableModel(this.tableHeaders, new int[0]);
            this.diskTable = new IsmTable((TableModel)this.diskTableModel);
            this.diskTable.setSelectionMode(2);
        }

        private JComponent getWarningTips() {
            JComponent infoComp = UiMethod.buildFrameSpace((JComponent)UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildLeftLabel((String)this.waringInfo)}), (int)0);
            return infoComp;
        }

        public IsmTable getDiskTable() {
            return this.diskTable;
        }

        public DefaultTableModel getDiskTableModel() {
            return this.diskTableModel;
        }

        public JButton getConfirmButton() {
            return this.confirmButton;
        }

        public JButton getCancelButton() {
            return this.cancelButton;
        }

        public TableScrollPane getDeviceTableScroll() {
            return this.deviceTableScroll;
        }
    }

    private class ConfirmListener
    implements ActionListener {
        private ConfirmListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List selectedList = SelectDiskWithNodeDialog.this.getSelectedDiskLocationsFromDiskTable();
            if (SelectDiskWithNodeDialog.this.parentSetUpDlg == null) {
                this.saveSelectListInNewScene(selectedList);
            } else {
                this.saveSelectList(selectedList);
            }
            SelectDiskWithNodeDialog.this.setDefaultCloseOperation(2);
            SelectDiskWithNodeDialog.this.dispose();
        }

        private void saveSelectListInNewScene(List<DiskWithNode> selectedList) {
            SelectDiskWithNodeDialog.this.oceanStor9000ItemSelectionCard.getNormalDiskLogItemNode().setSelected(!selectedList.isEmpty());
            SelectDiskWithNodeDialog.this.oceanStor9000ItemSelectionCard.setSelectedDiskWithNode(selectedList);
            SelectDiskWithNodeDialog.this.oceanStor9000ItemSelectionCard.setUserSelectDiskWithNode(true);
            SelectDiskWithNodeDialog.this.oceanStor9000ItemSelectionCard.getCollectlayout().getItemTree().updateUI();
        }

        private void saveSelectList(List<DiskWithNode> selectedList) {
            if (selectedList.isEmpty()) {
                SelectDiskWithNodeDialog.this.parentSetUpDlg.getNormalDiskLogItemNode().setSelected(false);
            } else {
                SelectDiskWithNodeDialog.this.parentSetUpDlg.getNormalDiskLogItemNode().setSelected(true);
            }
            SelectDiskWithNodeDialog.this.parentSetUpDlg.getCollectlayout().getItemTree().updateUI();
            SelectDiskWithNodeDialog.this.parentSetUpDlg.setSelectedDiskWithNode(selectedList);
            SelectDiskWithNodeDialog.this.parentSetUpDlg.setUserSelectDiskWithNode(true);
        }
    }
}

