/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.ui.setup.SetTaskThreadNumbersLayout;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.StringUtils;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Objects;
import javax.swing.JDialog;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetTaskThreadNumbersDialog
extends JDialog
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(SetTaskThreadNumbersDialog.class);
    private static final int MAX_THREAD_NUMBER = 8;
    private static final int MIN_THREAD_NUMBER = 1;
    private Window window;
    private SetTaskThreadNumbersLayout layout = null;

    public SetTaskThreadNumbersDialog(Window window) {
        super(window, ResourceUtil.getString((String)"infocollect.button.set.concurrent.dev.number"));
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.window = window;
        this.initUI();
        this.addListener();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (CollectDataContext.getInstance().isCollecting()) {
            DialogUtils.showErrorDialog((Window)this.window, (String)ResourceUtil.getString((String)"infocollect.remind.no.set.when.collecting"));
            return;
        }
        log.info("open SetTaskThreadNumbersDialog.");
        this.setVisible(true);
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.layout = new SetTaskThreadNumbersLayout();
        this.add((Component)this.layout, "North");
        this.pack();
        this.setResizable(true);
        SwingUtil.putScreenCenter((Window)this);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
    }

    private void addListener() {
        this.layout.getConfirmButton().addActionListener(e -> this.saveThreadNumbers());
        this.layout.getCancelButton().addActionListener(e -> this.closeDialog());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SetTaskThreadNumbersDialog.this.closeDialog();
            }
        });
    }

    private void saveThreadNumbers() {
        int numbers = this.getNumbers(this.layout.getThreadNumbers());
        if (numbers < 1 || numbers > 8) {
            log.error("Failed to verify the entered thread number.");
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infocollect.set.concurrent.dev.number.error"));
            return;
        }
        CollectDataContext.getInstance().setThreadPoolNumbers(numbers);
        log.info("Set thread numbers success. The number is {}", (Object)numbers);
        this.dispose();
    }

    private int getNumbers(JTextField threadNumbers) {
        if (Objects.isNull(threadNumbers) || StringUtils.isNULLStr((String)threadNumbers.getText())) {
            log.error("The entered threadNumbers is null.");
            return -1;
        }
        String numbers = threadNumbers.getText();
        log.info("The entered threadNumbers is {}", (Object)numbers);
        try {
            return Integer.parseInt(numbers);
        }
        catch (NumberFormatException e) {
            log.error("parse threadNumbers({}) error.", (Object)numbers, (Object)e);
            return -1;
        }
    }

    private void closeDialog() {
        log.info("close SetTaskThreadNumbersDialog.");
        this.layout.getThreadNumbers().setText(String.valueOf(CollectDataContext.getInstance().getThreadPoolNumbers()));
        this.setDefaultCloseOperation(2);
        this.dispose();
    }
}

