/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.tool.framework.pubservice.hardware.Disk;
import com.huawei.ism.tool.framework.pubservice.hardware.DiskLocation;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.IntegrateCollectInfo;
import com.huawei.ism.tool.infocollect.entity.ModeType;
import com.huawei.ism.tool.infocollect.rest.entity.CollectParam;
import com.huawei.ism.tool.infocollect.rest.entity.FlashCollectParam;
import com.huawei.ism.tool.infocollect.service.InfoCollectService;
import com.huawei.ism.tool.infocollect.ui.setup.CollectInfoBuilder;
import com.huawei.ism.tool.infocollect.ui.setup.CollectNewSetupDialog;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.Utils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingSaveListener
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(SettingSaveListener.class);
    private static final String LOG = "log";
    private static final String SMART = "smart";
    private static final String NORMAL_DISK_LOG_COLLECT_ITEM_ID = "normal_disklog";
    private static final int TYPE_INDEX = 1;
    private final CollectNewSetupDialog collectNewSetupDialog;
    private final DevNode devNode;

    @Override
    public void actionPerformed(ActionEvent event) {
        log.info("Start to save the selected information.");
        List<CollectItem> collectItems = this.parseSelectItem();
        List nodeRows = this.collectNewSetupDialog.getCollectNewSetupLayout().getNodesListTable().getMarkedRows();
        if (!this.isRightChoose(collectItems, nodeRows)) {
            return;
        }
        Optional<CollectItem> normalDiskLogItem = collectItems.stream().filter(item -> Objects.equals(NORMAL_DISK_LOG_COLLECT_ITEM_ID, item.getId())).findFirst();
        if (normalDiskLogItem.isPresent() && Utils.isNullList(this.collectNewSetupDialog.getSelectedDiskLocs())) {
            log.info("The number of hard disks is 0. Start collecting hard disks.");
            this.selectDisks(normalDiskLogItem.get());
            return;
        }
        this.saveDisksInfo(normalDiskLogItem.isPresent());
        this.saveItemAndNodes(collectItems, nodeRows);
        log.info("Saving the collection items of the device({}) succeeded.", (Object)this.devNode.getIp());
        this.applyItemsToSelectZoneNodes(collectItems);
        log.info("dispose dialog:{}", (Object)this.collectNewSetupDialog);
        this.collectNewSetupDialog.dispose();
    }

    private void applyItemsToSelectZoneNodes(List<CollectItem> collectItems) {
        if (Objects.isNull(this.collectNewSetupDialog.getDevChooseDialog())) {
            log.info("No apply items function.");
            return;
        }
        if (Objects.isNull(InfoCollectService.getInstance().getCollectInfoInstance(this.devNode))) {
            log.error("Apply items to select zone failed. Collect info is null, device is {}", (Object)this.devNode.getIp());
            return;
        }
        List<DevNode> devNodes = this.collectNewSetupDialog.getDevChooseDialog().getSelectDevNode();
        ArrayList failedDevices = new ArrayList();
        devNodes.forEach(device -> this.saveItemsToSelectZone((DevNode)device, collectItems, failedDevices));
        if (!Utils.isNullList(failedDevices)) {
            log.error("apply failed devices :{}", failedDevices);
            DialogUtils.showErrorDialog((JDialog)((Object)this.collectNewSetupDialog), (String)ResourceUtil.getStringWithParams((String)"infocollect.collectresult.applyto.device.error", (Object[])new Object[]{failedDevices}));
        }
    }

    private void saveItemsToSelectZone(DevNode zone, List<CollectItem> collectItems, List<String> failedDevices) {
        List<CollectItem> selectedItems;
        try {
            selectedItems = this.disposalCollectItems(zone, collectItems);
        }
        catch (ToolException e) {
            failedDevices.add(zone.getIp());
            log.error("save items to {} error.", (Object)zone.getIp());
            return;
        }
        CollectParam collectParam = ((FlashCollectParam.FlashCollectParamBuilder)((FlashCollectParam.FlashCollectParamBuilder)((FlashCollectParam.FlashCollectParamBuilder)((FlashCollectParam.FlashCollectParamBuilder)((FlashCollectParam.FlashCollectParamBuilder)((FlashCollectParam.FlashCollectParamBuilder)FlashCollectParam.builder().selectedScene(this.saveCollectScene())).devNode(zone)).selectedItems(selectedItems)).selectedControllerIds(new ArrayList<String>())).selectedExpansionModuleIds(new ArrayList<String>())).isCollectByNode(false)).build();
        CollectInfoBuilder builder = new CollectInfoBuilder(collectParam);
        IntegrateCollectInfo collectInfo = builder.buildScenarioBasedCollect();
        CollectDataContext.getInstance().putCollectInfo(zone, collectInfo);
        log.info("Apply items({}) to {}.", selectedItems.stream().map(CollectItem::getId).collect(Collectors.toList()), (Object)zone.getIp());
    }

    private List<CollectItem> disposalCollectItems(DevNode zone, List<CollectItem> collectItems) throws ToolException {
        List<CollectItem> selectedItems = collectItems.stream().filter(item -> !NORMAL_DISK_LOG_COLLECT_ITEM_ID.equals(item.getId())).collect(Collectors.toList());
        ICollectInfo originalCollectInfo = InfoCollectService.getInstance().getCollectInfoInstance(zone);
        if (Objects.isNull(originalCollectInfo)) {
            log.error("apply items to {} failed.", (Object)zone.getIp());
            throw new ToolException("apply items failed, no collect info");
        }
        Optional<CollectItem> originalNormalDiskLogItem = this.getNormalDiskLogCollectItem(originalCollectInfo);
        originalNormalDiskLogItem.ifPresent(selectedItems::add);
        return selectedItems;
    }

    private Optional<CollectItem> getNormalDiskLogCollectItem(ICollectInfo collectInfo) {
        return collectInfo.getCollectConfInfo().getSelectItems().stream().filter(item -> NORMAL_DISK_LOG_COLLECT_ITEM_ID.equals(item.getId())).findFirst();
    }

    private void saveItemAndNodes(List<CollectItem> collectItems, List<TableRow> nodesRow) {
        CollectParam collectParam = ((FlashCollectParam.FlashCollectParamBuilder)((FlashCollectParam.FlashCollectParamBuilder)((FlashCollectParam.FlashCollectParamBuilder)((FlashCollectParam.FlashCollectParamBuilder)((FlashCollectParam.FlashCollectParamBuilder)((FlashCollectParam.FlashCollectParamBuilder)FlashCollectParam.builder().selectedScene(this.saveCollectScene())).devNode(this.devNode)).selectedItems(collectItems)).selectedControllerIds(this.getNeedIds(nodesRow, "collect.node.type.controllers"))).selectedExpansionModuleIds(this.getNeedIds(nodesRow, "collect.node.type.smart.enclosure"))).isCollectByNode(this.collectNewSetupDialog.getCollectNewSetupLayout().getCbxConfirm().isSelected())).build();
        CollectInfoBuilder builder = new CollectInfoBuilder(collectParam);
        IntegrateCollectInfo collectInfo = builder.buildScenarioBasedCollect();
        CollectDataContext.getInstance().putCollectInfo(this.devNode, collectInfo);
    }

    private List<String> getNeedIds(List<TableRow> nodesRow, String typeKey) {
        return this.getCollectNodesIds(this.getSpecialNodes(nodesRow, ResourceUtil.getString((String)typeKey)));
    }

    private List<String> getCollectNodesIds(List<TableRow> rows) {
        return rows.stream().map(this::getNodeId).collect(Collectors.toList());
    }

    private String getNodeId(TableRow row) {
        if (row.getValueAt(0) instanceof String) {
            return (String)row.getValueAt(0);
        }
        return "";
    }

    private void saveDisksInfo(boolean isNormalDiskLogItemSelected) {
        if (!isNormalDiskLogItemSelected) {
            log.info("No normal disk log item is selected.");
            TreeMap<DiskLocation, Disk> diskTreeMap = CollectDataContext.getInstance().getGlobalConDiskHashMap().get(this.devNode);
            CollectDataContext.getInstance().clearDiskCheckStatus(diskTreeMap);
            return;
        }
        List<DiskLocation> selectedLocs = this.collectNewSetupDialog.getSelectedDiskLocs();
        log.info("Selected disk is: {}", selectedLocs);
        CollectDataContext.getInstance().updateDevSelectedDiskCheckStatus(this.devNode, selectedLocs);
    }

    private void selectDisks(CollectItem collectItem) {
        CheckTreeNode normalDiskLogNode = this.collectNewSetupDialog.getCollectNewSetupLayout().getItemTree().getTreeNodeByUserObj((Object)collectItem);
        if (!InfoCollectUtil.usrConfirmRiskProcedure(ResourceUtil.getStringWithParams((String)"disk.log.collect.time.tip", (Object[])new Object[0]))) {
            normalDiskLogNode.setSelected(false);
            return;
        }
        this.collectNewSetupDialog.setNormalDiskLogItemNode(normalDiskLogNode);
        this.collectNewSetupDialog.showDiskSelectDialog();
    }

    private boolean isRightChoose(List<CollectItem> collectItems, List<TableRow> nodes) {
        if (this.collectNewSetupDialog.getCollectNewSetupLayout().getItemTree().getRowCount() == 0) {
            log.info("Failed to initialize the UI.");
            return false;
        }
        if (CollectionUtil.isEmpty(collectItems) || CollectionUtil.isEmpty(nodes)) {
            log.error("No collection item or node is selected for the {}.", (Object)this.devNode.getIp());
            DialogUtils.showErrorDialog((JDialog)((Object)this.collectNewSetupDialog), (String)ResourceUtil.getString((String)"infocollect.remind.no.item.or.node"));
            return false;
        }
        if (this.hasLogOrSmart(collectItems) && this.onlySmartEnclosures(nodes)) {
            log.error("{} need to select at least one controller node when collecting recent logs or SMART information.", (Object)this.devNode.getIp());
            DialogUtils.showErrorDialog((JDialog)((Object)this.collectNewSetupDialog), (String)ResourceUtil.getString((String)"infocollect.remind.no.controllers"));
            return false;
        }
        if (this.onlyNormalDiskLog(collectItems) && this.hasApplyDevices()) {
            log.error("Only the running disk log collection item is selected for the {}. The application function cannot be used.", (Object)this.devNode.getIp());
            DialogUtils.showErrorDialog((JDialog)((Object)this.collectNewSetupDialog), (String)ResourceUtil.getString((String)"infocollect.remind.apply.only.running.disk.log"));
            return false;
        }
        return true;
    }

    private boolean hasApplyDevices() {
        return Objects.nonNull(this.collectNewSetupDialog.getDevChooseDialog()) && !Utils.isNullList(this.collectNewSetupDialog.getDevChooseDialog().getSelectDevNode());
    }

    private boolean onlyNormalDiskLog(List<CollectItem> collectItems) {
        return collectItems.stream().allMatch(item -> NORMAL_DISK_LOG_COLLECT_ITEM_ID.equals(item.getId()));
    }

    private boolean onlySmartEnclosures(List<TableRow> nodes) {
        String smartEnclosureName = ResourceUtil.getString((String)"collect.node.type.smart.enclosure");
        return nodes.stream().allMatch(node -> node.getValueAt(1).equals(smartEnclosureName));
    }

    private boolean hasLogOrSmart(List<CollectItem> collectItems) {
        return collectItems.stream().anyMatch(item -> item.getId().equals(LOG) || item.getId().equals(SMART));
    }

    private ModeType saveCollectScene() {
        int index = this.collectNewSetupDialog.getCollectNewSetupLayout().getModeComboBox().getSelectedIndex();
        this.collectNewSetupDialog.setQuicklyCollect(false);
        this.collectNewSetupDialog.setDepthCollect(false);
        this.collectNewSetupDialog.setCustomCollect(false);
        if (index == this.collectNewSetupDialog.getQuicklyCollectIndex()) {
            this.collectNewSetupDialog.setQuicklyCollect(true);
            return ModeType.QUICKLY_COLLECT;
        }
        if (index == this.collectNewSetupDialog.getDepthCollectIndex()) {
            this.collectNewSetupDialog.setDepthCollect(true);
            return ModeType.DEPTH_COLLECT;
        }
        this.collectNewSetupDialog.setCustomCollect(true);
        return ModeType.CUSTOM_COLLECT;
    }

    @NotNull
    private List<TableRow> getSpecialNodes(List<TableRow> nodes, String type) {
        return nodes.stream().filter(node -> node.getValueAt(1).equals(type)).collect(Collectors.toList());
    }

    private List<CollectItem> parseSelectItem() {
        if (this.collectNewSetupDialog.getCollectNewSetupLayout().getItemRootNode().getChildCount() == 0) {
            log.warn("not support device!!!!!");
            return Collections.emptyList();
        }
        ArrayList<CollectItem> selectItems = new ArrayList<CollectItem>();
        Enumeration enumeration = this.collectNewSetupDialog.getCollectNewSetupLayout().getItemRootNode().preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            Object currentObj = enumeration.nextElement();
            if (!(currentObj instanceof CheckTreeNode)) continue;
            CheckTreeNode current = (CheckTreeNode)currentObj;
            Object object = current.getUserObject();
            if (!current.isSelected() || !(object instanceof CollectItem)) continue;
            CollectItem collectItem = (CollectItem)object;
            selectItems.add(collectItem);
        }
        return selectItems;
    }

    public SettingSaveListener(CollectNewSetupDialog collectNewSetupDialog, DevNode devNode) {
        this.collectNewSetupDialog = collectNewSetupDialog;
        this.devNode = devNode;
    }
}

