/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectDuration;
import com.huawei.ism.tool.infocollect.entity.ComputeNodeParam;
import com.huawei.ism.tool.infocollect.ui.setup.IntegrateCollectSetupDialog;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.DateChooseField;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSettingPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(TimeSettingPanel.class);
    private static final int UCD_20 = 20;
    private final IntegrateCollectSetupDialog dialog;
    private JLabel startTimeLable;
    private JLabel endTimeLable;
    private DateChooseField startTimeField;
    private DateChooseField endTimeField;
    private JLabel timeLable;
    private JComponent timeSettingPan;
    private String deviceDate;
    private DevNode devNode;

    public TimeSettingPanel(DevNode devNode, IntegrateCollectSetupDialog dialog, String deviceDate) {
        this.dialog = dialog;
        this.deviceDate = deviceDate;
        this.devNode = devNode;
        this.initComponent();
        this.initUI();
    }

    private void initComponent() {
        this.setMinimumSize(new Dimension(360, 175));
        this.setLayout(new BorderLayout());
        this.timeLable = new JLabel("<html>" + ResourceUtil.getString((String)"infocollect.devicesetup.TimeSetting.desc") + "</html>");
        this.startTimeLable = new JLabel(ResourceUtil.getString((String)"infocollect.devicesetup.TimeSetting.start.date"));
        this.endTimeLable = new JLabel(ResourceUtil.getString((String)"infocollect.devicesetup.TimeSetting.end.date"));
        this.startTimeField = new DateChooseField(2);
        this.endTimeField = new DateChooseField(2);
        this.startTimeField.setEnabled(true);
        this.endTimeField.setEnabled(true);
        Map<String, ComputeNodeParam> computeNodesInfo = CollectDataContext.getInstance().getDevComputeNodesInfo().get(this.devNode);
        if (computeNodesInfo.isEmpty()) {
            log.error("ComputeNodesInfo is empty.");
            return;
        }
        ComputeNodeParam param = CollectDataContext.getInstance().getDevComputeNodesInfo().get(this.devNode).values().stream().findFirst().get();
        this.startTimeField.setText(InfoCollectUtil.formatTimeMillisToStringData(param.getStartTime()));
        this.endTimeField.setText(InfoCollectUtil.formatTimeMillisToStringData(param.getEndTime()));
    }

    private void initUI() {
        Box row = Box.createVerticalBox();
        row.add(this.createPanel());
        row.add(Box.createVerticalStrut(20));
        this.setLayout(new BorderLayout());
        this.add((Component)UiMethod.buildFrameSpace((JComponent)row, (int)12), "North");
    }

    private Box createPanel() {
        Box productrow = Box.createHorizontalBox();
        this.createDateRow();
        productrow.add(this.timeSettingPan);
        return productrow;
    }

    private void createDateRow() {
        TitledBorder border = BorderFactory.createTitledBorder(ResourceUtil.getString((String)"infocollect.time.devicesetup"));
        this.timeSettingPan = UCD.buildVerticalBox((Border)border, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)Box.createVerticalStrut(0)), UCD.buildHorizontalBoxLeft((Component)Box.createVerticalStrut(0)), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), this.startTimeLable, Box.createHorizontalStrut(0), this.startTimeField}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), this.endTimeLable, Box.createHorizontalStrut(0), this.endTimeField}), UCD.buildHorizontalBoxLeft((Component)Box.createVerticalStrut(0)), UCD.buildHBoxLeft((Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), this.timeLable})}), UCD.buildHorizontalBoxLeft((Component)Box.createVerticalStrut(0)), UCD.buildHorizontalBoxLeft((Component)Box.createVerticalStrut(0))});
    }

    public boolean isInputValid() {
        CollectDuration duration = this.getDuration();
        if (!duration.isValid()) {
            DialogUtils.showInfoDialog((JDialog)((Object)this.dialog), (String)ResourceUtil.getString((String)"infocollect.devicesetup.TimeSetting.error"));
            return false;
        }
        if (!duration.isValid(InfoCollectUtil.formatTimeMillisToStringData(this.devNode.getDevCurrentTime()), true)) {
            DialogUtils.showInfoDialog((JDialog)((Object)this.dialog), (String)ResourceUtil.getString((String)"infocollect.devicesetup.TimeSetting.error1"));
            return false;
        }
        if (!duration.isLessSevenDays()) {
            DialogUtils.showInfoDialog((JDialog)((Object)this.dialog), (String)ResourceUtil.getString((String)"infocollect.devicesetup.TimeSetting.error2"));
            return false;
        }
        return true;
    }

    public CollectDuration getDuration() {
        CollectDuration custom = new CollectDuration();
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Calendar startTime = Calendar.getInstance();
            Calendar endTime = Calendar.getInstance();
            startTime.setTime(format.parse(this.startTimeField.getText()));
            endTime.setTime(format.parse(this.endTimeField.getText()));
            custom.setStartDate(startTime.getTime());
            custom.setEndDate(endTime.getTime());
        }
        catch (ParseException e) {
            log.error("the startTime / endTime input error!!", (Throwable)e);
            custom.setStartDate(new Date());
            custom.setEndDate(new Date());
        }
        return custom;
    }

    public String getDeviceDate() {
        return this.deviceDate;
    }
}

