/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup.dpc;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.dpc.entity.DpcCollectNode;
import com.huawei.ism.tool.infocollect.ui.setup.dpc.DataTurboSetupDialog;
import com.huawei.ism.tool.infocollect.ui.setup.dpc.DataTurboSetupLayout;
import com.huawei.ism.tool.infocollect.ui.setup.dpc.DataTurboUtil;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTurboSettingSaveListener
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(DataTurboSettingSaveListener.class);
    private final DataTurboSetupDialog dataTurboSetupDialog;
    private final DataTurboSetupLayout dataTurboSetupLayout;
    private DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public DataTurboSettingSaveListener(DataTurboSetupDialog dialog) {
        this.dataTurboSetupDialog = dialog;
        this.dataTurboSetupLayout = dialog.getDataTurboSetupLayout();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info("Start to save the dpc nodes selected information.");
        if (!this.isRightChoose()) {
            return;
        }
        DpcCollectNode dpcCollectNode = this.dataTurboSetupLayout.getDpcCollectNode();
        String startTime = this.dataTurboSetupLayout.getStartTime().getText();
        String endTime = this.dataTurboSetupLayout.getEndTime().getText();
        dpcCollectNode.setBeginTime(StringUtils.parseDate2Long((String)startTime, (String)"yyyy-MM-dd HH:mm:ss"));
        dpcCollectNode.setEndTime(StringUtils.parseDate2Long((String)endTime, (String)"yyyy-MM-dd HH:mm:ss"));
        dpcCollectNode.setSetFinish(true);
        CollectDataContext.getInstance().getCollectNodeMap().put(this.dataTurboSetupDialog.getDevNode().getIp(), dpcCollectNode);
        log.info("Save the dpc nodes selected information success. startTime is {}, endTime is {}, dpcNodes id is {}.", new Object[]{startTime, endTime, DataTurboUtil.dpcSelectNodeIds(dpcCollectNode)});
        this.dataTurboSetupDialog.dispose();
    }

    private boolean isRightChoose() {
        return this.checkTimeSetting() && this.checkNodesSetting();
    }

    private boolean checkNodesSetting() {
        if (this.dataTurboSetupLayout.getDpcCollectNode().getDpcClusterNodes().stream().noneMatch(ClusterNode::isSelected)) {
            log.error("No DPC node is selected.");
            DialogUtils.showErrorDialog((JDialog)((Object)this.dataTurboSetupDialog), (String)ResourceUtil.getString((String)"dpc.nodes.setup.node.empty.error"));
            return false;
        }
        long count = this.dataTurboSetupLayout.getDpcCollectNode().getDpcClusterNodes().stream().filter(ClusterNode::isSelected).count();
        if (count > 200L) {
            log.error("More than 200 DPC nodes are selected. nodes number is {}.", (Object)count);
            DialogUtils.showErrorDialog((JDialog)((Object)this.dataTurboSetupDialog), (String)ResourceUtil.getString((String)"dpc.nodes.setup.node.too.many.error"));
            return false;
        }
        if (count > 50L) {
            log.warn("More than 50 DPC nodes are selected. nodes number is {}.", (Object)count);
            WarningDialog warningDialog = DialogUtils.showYesNoDialog((Window)((Object)this.dataTurboSetupDialog), (String)ResourceUtil.getStringWithParams((String)"dpc.nodes.setup.node.too.many.warn", (Object[])new Object[]{String.valueOf(count * 200L / 1024L), String.valueOf((count / 10L + 1L) * 10L)}));
            return warningDialog.isConfirmClick();
        }
        return true;
    }

    private boolean checkTimeSetting() {
        String startTime = this.dataTurboSetupLayout.getStartTime().getText();
        String endTime = this.dataTurboSetupLayout.getEndTime().getText();
        if (StringUtils.hasNULLStr((String[])new String[]{startTime, endTime})) {
            log.error("The start time and end time cannot be empty. startTime:{}, endTime:{}", (Object)startTime, (Object)endTime);
            DialogUtils.showErrorDialog((JDialog)((Object)this.dataTurboSetupDialog), (String)ResourceUtil.getString((String)"dpc.nodes.setup.time.empty.error"));
            return false;
        }
        Optional<LocalDateTime> startData = this.parseTime(startTime);
        if (!startData.isPresent()) {
            DialogUtils.showErrorDialog((JDialog)((Object)this.dataTurboSetupDialog), (String)ResourceUtil.getString((String)"dpc.nodes.setup.time.format.start.time.error"));
            return false;
        }
        Optional<LocalDateTime> endData = this.parseTime(endTime);
        if (!endData.isPresent()) {
            DialogUtils.showErrorDialog((JDialog)((Object)this.dataTurboSetupDialog), (String)ResourceUtil.getString((String)"dpc.nodes.setup.time.format.end.time.error"));
            return false;
        }
        if (startData.get().isAfter(endData.get())) {
            log.error("The end time is earlier than the start time. startTime:{}, endTime:{}", (Object)startTime, (Object)endTime);
            DialogUtils.showErrorDialog((JDialog)((Object)this.dataTurboSetupDialog), (String)ResourceUtil.getString((String)"dpc.nodes.setup.end.earlier.than.start.error"));
            return false;
        }
        LocalDateTime currentTime = LocalDateTime.now();
        if (startData.get().isAfter(currentTime)) {
            log.warn("The start time is later than the current time. currentTime:{}, startTime:{}", (Object)currentTime.format(this.formatter), (Object)startTime);
            WarningDialog warningDialog = DialogUtils.showYesNoDialog((Window)((Object)this.dataTurboSetupDialog), (String)ResourceUtil.getString((String)"dpc.nodes.setup.start.earlier.than.now.warn"));
            return warningDialog.isConfirmClick();
        }
        return true;
    }

    private Optional<LocalDateTime> parseTime(String timeText) {
        try {
            return Optional.of(LocalDateTime.parse(timeText, this.formatter));
        }
        catch (DateTimeParseException e) {
            log.error("parse time error. Time text is {}", (Object)timeText, (Object)e);
            return Optional.empty();
        }
    }
}

