/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup.dpc;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.dpc.entity.DpcClusterNode;
import com.huawei.ism.tool.infocollect.dpc.entity.DpcCollectNode;
import com.huawei.ism.tool.infocollect.ui.setup.dpc.DataTurboSetupDialog;
import com.huawei.ism.tool.infocollect.ui.setup.dpc.DataTurboUtil;
import com.huawei.ism.tool.infocollect.ui.setup.dpc.ListSelectListener;
import com.huawei.ism.tool.infocollect.ui.setup.dpc.QueryDpcNodesTask;
import com.huawei.ism.tool.infocollect.ui.setup.dpc.RemoveCollectedListener;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.DateChooseField;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTurboSetupLayout
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(DataTurboSetupLayout.class);
    private static final Dimension LABEL_SIZE = new Dimension(100, 21);
    private static final Dimension STATUS_SIZE_ZH = new Dimension(60, 21);
    private static final Dimension STATUS_SIZE_EN = new Dimension(120, 21);
    private static final String START_TIME_KEY = "startTime";
    private static final String END_TIME_KEY = "endTime";
    private final DevNode devNode;
    private final DataTurboSetupDialog dataTurboSetupDialog;
    private DpcCollectNode dpcCollectNode;
    private DpcCollectNode preDpcCollectNode;
    private DateChooseField startTime;
    private DateChooseField endTime;
    private TableScrollPane nodesScroll;
    private IsmTable clusterNodesTable;
    private DefaultTableModel clusterNodesTableModel;
    private JComboBox filterNodeCombo;
    private String errorMsg;

    public DataTurboSetupLayout(DevNode devNode, DataTurboSetupDialog dataTurboSetupDialog) {
        this.devNode = devNode;
        this.dataTurboSetupDialog = dataTurboSetupDialog;
        this.setPreDpcCollectNode();
        this.initDpcCollectNode();
        this.initUI();
        this.bindListener();
    }

    private void setPreDpcCollectNode() {
        this.preDpcCollectNode = CollectDataContext.getInstance().getCollectNodeMap().get(this.devNode.getIp());
    }

    private void initDpcCollectNode() {
        Optional<DpcCollectNode> dpcNode = this.queryDpcCollectNode();
        if (!dpcNode.isPresent()) {
            log.error("query dpc nodes error, dpc node is null");
            return;
        }
        this.dpcCollectNode = dpcNode.get();
        if (Objects.nonNull(this.preDpcCollectNode) && this.preDpcCollectNode.isSetFinish()) {
            log.info("save pre dpc nodes info.");
            this.preDpcCollectNode.getDpcClusterNodes().stream().filter(ClusterNode::isSelected).forEach(this::saveSelected);
            this.dpcCollectNode.setEndTime(this.preDpcCollectNode.getEndTime());
            this.dpcCollectNode.setBeginTime(this.preDpcCollectNode.getBeginTime());
            return;
        }
        log.info("preDpcCollectNode is null, init dpcCollectNode info.");
        this.dpcCollectNode.getDpcClusterNodes().subList(0, Math.min(200, this.dpcCollectNode.getDpcClusterNodes().size())).forEach(node -> node.setSelected(true));
        long currentTime = System.currentTimeMillis();
        this.dpcCollectNode.setBeginTime(currentTime - DataTurboUtil.SEVEN_DAY);
        this.dpcCollectNode.setEndTime(currentTime);
    }

    private Optional<DpcCollectNode> queryDpcCollectNode() {
        ProgressDialog progressDialog = new ProgressDialog((Window)this.dataTurboSetupDialog.getParent());
        Future queryDpcNodesFuture = AsyncExcutor.submit((Callable)new QueryDpcNodesTask(progressDialog, this, this.devNode));
        if (progressDialog.isDisplayable()) {
            progressDialog.setVisible(true);
        }
        try {
            return (Optional)queryDpcNodesFuture.get(125L, TimeUnit.MINUTES);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Query dpc nodes future get Exception:", (Throwable)e);
            return Optional.empty();
        }
    }

    private void saveSelected(DpcClusterNode preNode) {
        this.dpcCollectNode.getDpcClusterNodes().stream().filter(node -> node.getDpcNodeId().equals(preNode.getDpcNodeId())).forEach(node -> node.setSelected(true));
    }

    private void bindListener() {
        if (Objects.isNull(this.dpcCollectNode) || Utils.isNullList(this.dpcCollectNode.getDpcClusterNodes())) {
            log.warn("No dpcCollectNode. Failed to initialize the listener.");
            return;
        }
        this.clusterNodesTable.addListSelectionListener((ListSelectionListener)new ListSelectListener(this));
        this.nodesScroll.getFilterFiled().addEndChangeListener(e -> this.markRowIfClusterIsSelected());
        this.filterNodeCombo.addActionListener(new RemoveCollectedListener(this));
    }

    private void markRowIfClusterIsSelected() {
        List selectNodes = this.dpcCollectNode.getDpcClusterNodes().stream().filter(ClusterNode::isSelected).collect(Collectors.toList());
        List<TableRow> rows = this.clusterNodesTable.getAllRows().stream().filter(row -> selectNodes.contains(row.getIdentifier())).collect(Collectors.toList());
        this.clusterNodesTable.markTableRow(rows.toArray(new TableRow[0]));
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)UiMethod.buildFrameSpace((JComponent)this.createScrollPanel(), (int)12), "Center");
    }

    private JComponent createScrollPanel() {
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        listPanel.add((Component)this.createNodesPanel(), "North");
        JScrollPane scrollPane = new JScrollPane(listPanel);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        return scrollPane;
    }

    private JComponent createNodesPanel() {
        if (Objects.isNull(this.dpcCollectNode) || Utils.isNullList(this.dpcCollectNode.getDpcClusterNodes())) {
            log.error("settingInfo is null.");
            JLabel errmsg = new JLabel("<html>" + ResourceUtil.getString((String)"infocollect.devicesetup.options.error") + "</html>", 0);
            return UiMethod.buildFrameSpace((JComponent)errmsg, (int)12);
        }
        Box box = Box.createVerticalBox();
        this.createDateField(box);
        this.createTableField(box);
        return UiMethod.buildFrameSpace((JComponent)box, (int)12);
    }

    private void createTableField(Box box) {
        JLabel title = UiMethod.createColonLabel((String)ResourceUtil.getString((String)"dpc.nodes.filter.conditions"));
        UiMethod.setComponentSize((Dimension)LABEL_SIZE, (Component[])new Component[]{title});
        JComponent filterBox = this.buildFilterBox();
        this.buildNodesScrollPane();
        this.addDpcNodesToTable();
        box.add(UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{title, filterBox}), UCD.buildHBoxLeft((Component[])new Component[]{this.nodesScroll})}));
        box.add(Box.createVerticalStrut(10));
    }

    private JComponent buildFilterBox() {
        this.filterNodeCombo = this.buildFilterNodeComboBox();
        JLabel filterNodeTitle = UiMethod.createColonLabel((String)ResourceUtil.getString((String)"collect.setup.a800.om.dpc.filter"));
        UiMethod.setComponentSize((Dimension)STATUS_SIZE_EN, (Component[])new Component[]{filterNodeTitle});
        return UCD.buildHorizotalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{filterNodeTitle, this.filterNodeCombo})});
    }

    private JComboBox buildFilterNodeComboBox() {
        JComboBox<String> filterCombo = new JComboBox<String>(this.getFilter());
        UiMethod.setComponentSize((Dimension)STATUS_SIZE_ZH, (Component[])new Component[]{filterCombo});
        return filterCombo;
    }

    private String[] getFilter() {
        return new String[]{ResourceUtil.getString((String)"dpc.nodes.no"), ResourceUtil.getString((String)"dpc.nodes.yes")};
    }

    private void addDpcNodesToTable() {
        this.dpcCollectNode.getDpcClusterNodes().forEach(node -> {
            TableRow<DpcClusterNode, DpcClusterNode> row = this.constructDpcNodeRow((DpcClusterNode)((Object)node));
            this.clusterNodesTableModel.addRow(new TableRow[]{row});
        });
        this.markRowIfClusterIsSelected();
    }

    private TableRow<DpcClusterNode, DpcClusterNode> constructDpcNodeRow(DpcClusterNode node) {
        DefaultTableRow row = new DefaultTableRow(this.clusterNodesTableModel.getColumnCount(), (Object)node, (Object)node);
        int index = 0;
        row.setValueAt(index++, (Object)node.getDpcNodeId());
        row.setValueAt(index++, (Object)node.getManagementIp());
        row.setValueAt(index++, (Object)node.getOmNodeIp());
        row.setValueAt(index++, (Object)node.getManageStatus().getDesc());
        row.setValueAt(index++, (Object)node.getServiceStatus().getDesc());
        return row;
    }

    private void buildNodesScrollPane() {
        this.clusterNodesTableModel = new DefaultTableModel(this.getTableHeader(), new int[]{0, 1, 2, 3, 4});
        this.clusterNodesTable = new IsmTable((TableModel)this.clusterNodesTableModel);
        this.setTableHeaderSize();
        this.nodesScroll = new TableScrollPane(this.clusterNodesTable, true, false, true);
        this.nodesScroll.setPreferredSize(new Dimension(570, 300));
        this.nodesScroll.getFilterFiled().setClearSelection(false);
    }

    private void setTableHeaderSize() {
        if (Objects.isNull(this.clusterNodesTable)) {
            log.info("clusterNodesTbl is null.");
            return;
        }
        TableColumnModel colModel = this.clusterNodesTable.getColumnModel();
        if (ApplicationContext.getInstance().isEnglishEnv()) {
            this.setTableHeaderSizeEn(colModel);
            return;
        }
        this.setTableHeaderSizeZh(colModel);
    }

    private void setTableHeaderSizeEn(TableColumnModel colModel) {
        colModel.getColumn(0).setPreferredWidth(150);
        colModel.getColumn(1).setPreferredWidth(60);
        colModel.getColumn(2).setPreferredWidth(110);
        colModel.getColumn(3).setPreferredWidth(60);
        colModel.getColumn(4).setPreferredWidth(40);
    }

    private void setTableHeaderSizeZh(TableColumnModel colModel) {
        colModel.getColumn(0).setPreferredWidth(150);
        colModel.getColumn(1).setPreferredWidth(40);
        colModel.getColumn(2).setPreferredWidth(80);
        colModel.getColumn(3).setPreferredWidth(40);
        colModel.getColumn(4).setPreferredWidth(40);
    }

    private String[] getTableHeader() {
        return new String[]{ResourceUtil.getString((String)"dpc.nodes.table.oceanstor.dataturbo.dpc.id"), ResourceUtil.getString((String)"dpc.nodes.table.oceanstor.dataturbo.dpc.ip"), ResourceUtil.getString((String)"dpc.nodes.table.oceanstor.dataturbo.ip"), ResourceUtil.getString((String)"dpc.nodes.table.oceanstor.dataturbo.dpc.mgmt.status"), ResourceUtil.getString((String)"dpc.nodes.table.oceanstor.dataturbo.dpc.status")};
    }

    private void createDateField(Box box) {
        this.startTime = new DateChooseField();
        this.setTimeContent(this.startTime, START_TIME_KEY, box);
        this.endTime = new DateChooseField();
        this.setTimeContent(this.endTime, END_TIME_KEY, box);
        this.initFieldData();
    }

    private void initFieldData() {
        this.startTime.setText(StringUtils.formatDate((Object)this.dpcCollectNode.getBeginTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        this.endTime.setText(StringUtils.formatDate((Object)this.dpcCollectNode.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
    }

    private void setTimeContent(DateChooseField timeField, String name, Box box) {
        JLabel title = UiMethod.createColonLabel((String)ResourceUtil.getString((String)("dpc.nodes." + name)));
        UiMethod.setComponentSize((Dimension)LABEL_SIZE, (Component[])new Component[]{title});
        UiMethod.setComponentSize((Dimension)new Dimension(200, 21), (Component[])new Component[]{timeField});
        timeField.setDateChooseModel(2);
        timeField.setName(name);
        timeField.setEditable(true);
        box.add(UCD.buildHBoxLeft((Component[])new Component[]{title, timeField, Box.createGlue()}));
        box.add(Box.createVerticalStrut(10));
    }

    public DevNode getDevNode() {
        return this.devNode;
    }

    public DataTurboSetupDialog getDataTurboSetupDialog() {
        return this.dataTurboSetupDialog;
    }

    public DpcCollectNode getDpcCollectNode() {
        return this.dpcCollectNode;
    }

    public DpcCollectNode getPreDpcCollectNode() {
        return this.preDpcCollectNode;
    }

    public DateChooseField getStartTime() {
        return this.startTime;
    }

    public DateChooseField getEndTime() {
        return this.endTime;
    }

    public TableScrollPane getNodesScroll() {
        return this.nodesScroll;
    }

    public IsmTable getClusterNodesTable() {
        return this.clusterNodesTable;
    }

    public DefaultTableModel getClusterNodesTableModel() {
        return this.clusterNodesTableModel;
    }

    public JComboBox getFilterNodeCombo() {
        return this.filterNodeCombo;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
}

