/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup.dpc;

import com.huawei.ism.tool.infocollect.dpc.entity.DpcClusterNode;
import com.huawei.ism.tool.infocollect.dpc.entity.DpcCollectNode;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTurboUtil {
    private static final Logger log = LoggerFactory.getLogger(DataTurboUtil.class);
    public static final long SEVEN_DAY = TimeUnit.DAYS.toMillis(7L);
    public static final int MAX_DPC_NUMBER = 200;
    public static final int RECOMMEND_DPC_NUMBER = 50;
    public static final String DPC_NODE_ID_TITLE = ResourceUtil.getString((String)"dpc.nodes.table.oceanstor.dataturbo.dpc.id");
    public static final String DPC_NODE_IP_TITLE = ResourceUtil.getString((String)"dpc.nodes.table.oceanstor.dataturbo.dpc.ip");
    public static final String OM_NODE_IP_TITLE = ResourceUtil.getString((String)"dpc.nodes.table.oceanstor.dataturbo.ip");
    public static final String DPC_NODE_SERVICE_STATUS_TITLE = ResourceUtil.getString((String)"dpc.nodes.table.oceanstor.dataturbo.dpc.mgmt.status");
    public static final String DPC_NODE_MANAGEMENT_STATUS_TITLE = ResourceUtil.getString((String)"dpc.nodes.table.oceanstor.dataturbo.dpc.status");
    public static final int POLLING_SLEEP_TIME_SECONDS = 30;
    public static final long CONFIG_TASK_OVERTIME_MILLS = TimeUnit.MINUTES.toMillis(20L);
    private static final ReentrantReadWriteLock LOCK = new ReentrantReadWriteLock();

    public static List<String> dpcSelectNodeIds(DpcCollectNode dpcCollectNode) {
        return dpcCollectNode.getDpcClusterNodes().stream().filter(ClusterNode::isSelected).map(DpcClusterNode::getDpcNodeId).collect(Collectors.toList());
    }

    public static List<DpcClusterNode> dpcSelectNodes(DpcCollectNode dpcCollectNode) {
        return dpcCollectNode.getDpcClusterNodes().stream().filter(ClusterNode::isSelected).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDpcNodeInfo(String filePath, DpcClusterNode node) {
        String nodeInfo = String.join((CharSequence)",   ", DataTurboUtil.concatenateStr(DPC_NODE_ID_TITLE, node.getDpcNodeId()), DataTurboUtil.concatenateStr(DPC_NODE_IP_TITLE, node.getManagementIp()), DataTurboUtil.concatenateStr(OM_NODE_IP_TITLE, node.getOmNodeIp()), DataTurboUtil.concatenateStr(DPC_NODE_SERVICE_STATUS_TITLE, node.getServiceStatus().getDesc()), DataTurboUtil.concatenateStr(DPC_NODE_MANAGEMENT_STATUS_TITLE, node.getManageStatus().getDesc())) + "\r\n";
        LOCK.writeLock().lock();
        try {
            FileUtils.write(new File(filePath), (CharSequence)nodeInfo, StandardCharsets.UTF_8, true);
        }
        catch (IOException e) {
            log.error("Write file error... file path is {}", (Object)filePath, (Object)e);
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    private static String concatenateStr(String title, String value) {
        return String.join((CharSequence)" : ", title, value);
    }

    public static List<String> getCollectedDpcIds(DpcCollectNode dpcCollectNode) {
        return dpcCollectNode.getDpcClusterNodes().stream().filter(DpcClusterNode::isCollected).map(DpcClusterNode::getDpcNodeId).collect(Collectors.toList());
    }
}

