/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup.dpc;

import com.huawei.ism.tool.infocollect.ui.setup.dpc.DataTurboSetupLayout;
import com.huawei.ism.ui.swing.table.TableRow;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListSelectListener
implements ListSelectionListener {
    private static final Logger log = LoggerFactory.getLogger(ListSelectListener.class);
    private static final String ISM_SORTER_CLS_NAME = "IsmTableRowSorter";
    private final DataTurboSetupLayout dataTurboSetupLayout;

    public ListSelectListener(DataTurboSetupLayout layout) {
        this.dataTurboSetupLayout = layout;
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        ActionType actionType = this.getActionType();
        if (ActionType.FILTER_CHANGE.equals((Object)actionType) || ActionType.SORTER_CHANGE.equals((Object)actionType)) {
            return;
        }
        this.clearViewClusterNodeSelection();
        this.syncSelectRowToClusterNode();
    }

    private void syncSelectRowToClusterNode() {
        List identifierList = this.dataTurboSetupLayout.getClusterNodesTable().getMarkedRows().stream().map(TableRow::getIdentifier).collect(Collectors.toList());
        this.dataTurboSetupLayout.getDpcCollectNode().getDpcClusterNodes().stream().filter(identifierList::contains).forEach(node -> node.setSelected(true));
    }

    private void clearViewClusterNodeSelection() {
        List viewRows = IntStream.range(0, this.dataTurboSetupLayout.getClusterNodesTable().getRowCount()).mapToObj(this::getRowData).collect(Collectors.toList());
        List identifierList = viewRows.stream().map(TableRow::getIdentifier).collect(Collectors.toList());
        this.dataTurboSetupLayout.getDpcCollectNode().getDpcClusterNodes().stream().filter(identifierList::contains).forEach(clusterNode -> clusterNode.setSelected(false));
    }

    private TableRow getRowData(int index) {
        return this.dataTurboSetupLayout.getClusterNodesTableModel().getRow(this.dataTurboSetupLayout.getClusterNodesTable().convertRowIndexToModel(index));
    }

    ActionType getActionType() {
        StackTraceElement[] stackTraces = Thread.currentThread().getStackTrace();
        return Arrays.stream(stackTraces).anyMatch(stackTrace -> stackTrace.getClassName().contains(ISM_SORTER_CLS_NAME)) ? ActionType.SORTER_CHANGE : ActionType.SINGLE_SELECT;
    }

    static enum ActionType {
        FILTER_CHANGE,
        SORTER_CHANGE,
        SINGLE_SELECT;

    }
}

