/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup.dpc;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.CollectStatus;
import com.huawei.ism.tool.infocollect.service.PackageA800ClusterTask;
import com.huawei.ism.tool.infocollect.ui.InfoCollectMainDialog;
import com.huawei.ism.tool.infocollect.util.InfoCollectDirPropertiesUtil;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageA800Cluster
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(PackageA800Cluster.class);
    private static final List<CollectStatus> SPECIAL_STATUS = Collections.unmodifiableList(Arrays.asList(CollectStatus.COLLECT_UNSUPPORT, CollectStatus.COLLECT_STOPPING, CollectStatus.COLLECT_STOPPED));
    private final InfoCollectMainDialog parent;
    private final String infoCollectDir;

    public PackageA800Cluster(InfoCollectMainDialog infoCollectMainDialog) {
        this.parent = infoCollectMainDialog;
        this.infoCollectDir = String.join((CharSequence)File.separator, InfoCollectDirPropertiesUtil.getProperty(), "OceanStorA800_" + System.currentTimeMillis());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<DevNode> devices = this.parent.getSelectedDevNode();
        if (!this.checkDeviceStatus(devices)) {
            return;
        }
        if (!this.creatPackageDir(devices)) {
            return;
        }
        ProgressDialog progressDialog = new ProgressDialog((Window)this.parent, ResourceUtil.getString((String)"infocollect.a800.package.progress.des"));
        PackageA800ClusterTask task = new PackageA800ClusterTask(progressDialog, devices, this.infoCollectDir);
        Future future = AsyncExcutor.submit((Callable)task);
        progressDialog.setVisible(true);
        try {
            boolean isPackage = (Boolean)future.get();
            if (!isPackage) {
                log.error("A800 Cluster Log Compression Failure.");
                DialogUtils.showErrorDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"infocollect.a800.package.fail"));
                return;
            }
            if (!StringUtils.isNULLStr((String)task.getErrorMsg().toString())) {
                log.error("Failed to collect config logs.");
                DialogUtils.showInfoDialog((JDialog)this.parent, (String)(ResourceUtil.getString((String)"infocollect.a800.package.success") + task.getErrorMsg().toString()));
                return;
            }
            log.info("A800 cluster logs are packed successfully.");
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"infocollect.a800.package.success"));
        }
        catch (InterruptedException | ExecutionException ex) {
            log.error("Failed to Pack A800 Cluster Logs", (Throwable)ex);
            DialogUtils.showErrorDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"infocollect.a800.package.fail"));
        }
    }

    private boolean creatPackageDir(List<DevNode> devices) {
        File file = new File(this.infoCollectDir);
        if (!this.creatDir(file)) {
            return false;
        }
        log.info("The packaging path of the A800 cluster is {}", (Object)this.infoCollectDir);
        if (devices.stream().anyMatch(InfoCollectUtil::isA800Om)) {
            File omFile = new File(String.join((CharSequence)File.separator, this.infoCollectDir, "dataturbo"));
            if (!this.creatDir(omFile)) {
                return false;
            }
            log.info("The A800 dataturbo folder is successfully created.");
        }
        if (devices.stream().anyMatch(InfoCollectUtil::isA800Zone)) {
            File zoneFile = new File(String.join((CharSequence)File.separator, this.infoCollectDir, "zone"));
            if (!this.creatDir(zoneFile)) {
                return false;
            }
            log.info("The A800 zone folder is successfully created.");
        }
        return true;
    }

    private boolean creatDir(File file) {
        if (!file.exists() && !file.mkdirs()) {
            log.error("create {} folder error!", (Object)this.infoCollectDir);
            DialogUtils.showErrorDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"infocollect.a800.package.fail"));
            return false;
        }
        return true;
    }

    private boolean checkDeviceStatus(List<DevNode> devices) {
        if (devices.isEmpty()) {
            log.error("Cannot pack because no device is selected.");
            DialogUtils.showErrorDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"infocollect.remind.select.no.device"));
            return false;
        }
        if (this.parent.isCollecting(devices)) {
            log.error("There are devices that are being collected. Packing is not allowed.");
            DialogUtils.showErrorDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"infocollect.remind.item.is.collecting"));
            return false;
        }
        if (this.isNotCollect(devices)) {
            log.error("The selected devices contain devices that are not collected.");
            DialogUtils.showErrorDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"infocollect.remind.select.not.collect"));
        }
        if (this.isSpecialStatus(devices)) {
            log.error("Some devices in special states exist in the selected devices.");
            DialogUtils.showErrorDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"infocollect.remind.select.special.status"));
        }
        return true;
    }

    private boolean isSpecialStatus(List<DevNode> devices) {
        return devices.stream().map(dev -> CollectDataContext.getInstance().getCollectInfo((DevNode)dev)).anyMatch(info -> SPECIAL_STATUS.contains((Object)info.getCollectStatus()));
    }

    private boolean isNotCollect(List<DevNode> devices) {
        List collectInfos = devices.stream().map(dev -> CollectDataContext.getInstance().getCollectInfo((DevNode)dev)).collect(Collectors.toList());
        if (collectInfos.stream().anyMatch(Objects::isNull)) {
            log.error("The collectInfo field of some devices is empty.");
            return true;
        }
        return collectInfos.stream().anyMatch(info -> info.getCollectStatus() == CollectStatus.NOT_COLLECT);
    }
}

