/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup.dpc;

import com.huawei.ism.tool.infocollect.dpc.entity.DpcCollectNode;
import com.huawei.ism.tool.infocollect.dpc.service.DpcCollectUtil;
import com.huawei.ism.tool.infocollect.ui.setup.dpc.DataTurboSetupLayout;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.util.SwingUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDpcNodesTask
implements Callable<Optional<DpcCollectNode>> {
    private static final Logger log = LoggerFactory.getLogger(QueryDpcNodesTask.class);
    private final ProgressDialog progressDialog;
    private final DataTurboSetupLayout dataTurboSetupLayout;
    private final DevNode devNode;

    @Override
    public Optional<DpcCollectNode> call() {
        try {
            Optional<DpcCollectNode> optional = DpcCollectUtil.getDpcCollectNode(this.devNode);
            return optional;
        }
        catch (ToolException e) {
            log.error("query dpc nodes error. ", (Throwable)e);
            this.dataTurboSetupLayout.setErrorMsg(e.getErrorLocaleDescription());
            Optional<DpcCollectNode> optional = Optional.empty();
            return optional;
        }
        finally {
            if (Objects.nonNull(this.progressDialog)) {
                SwingUtil.disPoseDialg((ProgressDialog)this.progressDialog);
            }
        }
    }

    public QueryDpcNodesTask(ProgressDialog progressDialog, DataTurboSetupLayout dataTurboSetupLayout, DevNode devNode) {
        this.progressDialog = progressDialog;
        this.dataTurboSetupLayout = dataTurboSetupLayout;
        this.devNode = devNode;
    }
}

