/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.setup.dpc;

import com.huawei.ism.tool.infocollect.dpc.entity.DpcClusterNode;
import com.huawei.ism.tool.infocollect.dpc.entity.DpcCollectNode;
import com.huawei.ism.tool.infocollect.ui.setup.dpc.DataTurboSetupLayout;
import com.huawei.ism.tool.infocollect.ui.setup.dpc.DataTurboUtil;
import com.huawei.ism.tool.infocollect.ui.setup.dpc.RemoveCollectedFilter;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.KeywordRowFilter;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.RowFilter;
import javax.swing.table.TableRowSorter;

public class RemoveCollectedListener
implements ActionListener {
    private final DataTurboSetupLayout dataTurboSetupLayout;
    private final DpcCollectNode dpcCollectNode;

    public RemoveCollectedListener(DataTurboSetupLayout dataTurboSetupLayout) {
        this.dataTurboSetupLayout = dataTurboSetupLayout;
        this.dpcCollectNode = dataTurboSetupLayout.getDpcCollectNode();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isFilterUncollectedDpc()) {
            this.clearClusterNodeSelection();
        }
        this.updateFilter();
        this.markRowIfClusterIsSelected();
    }

    private void markRowIfClusterIsSelected() {
        List<DpcClusterNode> selectedNodes = DataTurboUtil.dpcSelectNodes(this.dpcCollectNode);
        this.dataTurboSetupLayout.getClusterNodesTable().markTableRow(this.getTableRows(selectedNodes));
    }

    private void updateFilter() {
        RemoveCollectedFilter rowFilter = new RemoveCollectedFilter(this.getCollectedDpcIds());
        this.dataTurboSetupLayout.getNodesScroll().getFilterFiled().setAfterFilter(true);
        this.dataTurboSetupLayout.getNodesScroll().getFilterFiled().setExtFilter(new RowFilter[]{rowFilter});
        IsmTable source = this.dataTurboSetupLayout.getClusterNodesTable();
        TableRowSorter sorter = (TableRowSorter)source.getRowSorter();
        String text = this.dataTurboSetupLayout.getNodesScroll().getFilterFiled().getKeyword();
        if (StringUtils.isNULLStr((String)text)) {
            sorter.setRowFilter(rowFilter);
            return;
        }
        KeywordRowFilter keywordRowFilter = new KeywordRowFilter(text, new int[0]);
        sorter.setRowFilter(RowFilter.andFilter(Arrays.asList(keywordRowFilter, rowFilter)));
    }

    private void clearClusterNodeSelection() {
        List<DpcClusterNode> collectedNodes = this.dpcCollectNode.getDpcClusterNodes().stream().filter(DpcClusterNode::isCollected).collect(Collectors.toList());
        collectedNodes.forEach(node -> node.setSelected(false));
        this.dataTurboSetupLayout.getClusterNodesTable().unmarkTableRow(this.getTableRows(collectedNodes));
    }

    private List<String> getCollectedDpcIds() {
        if (!this.isFilterUncollectedDpc()) {
            return Collections.emptyList();
        }
        return DataTurboUtil.getCollectedDpcIds(this.dpcCollectNode);
    }

    private TableRow[] getTableRows(List<DpcClusterNode> nodes) {
        return (TableRow[])this.dataTurboSetupLayout.getClusterNodesTable().getAllRows().stream().filter(row -> nodes.contains(row.getIdentifier())).toArray(TableRow[]::new);
    }

    private boolean isFilterUncollectedDpc() {
        return Objects.requireNonNull(this.dataTurboSetupLayout.getFilterNodeCombo().getSelectedItem()).toString().equals(ResourceUtil.getString((String)"dpc.nodes.yes"));
    }
}

