/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.support;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.ThreadPool;
import com.huawei.ism.tool.framework.platform.PlatformAppContext;
import com.huawei.ism.tool.framework.platform.common.data.ToolLoginUser;
import com.huawei.ism.tool.framework.platform.common.data.ToolUserRole;
import com.huawei.ism.tool.framework.platform.common.toolbox.AbstractToolBox;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.CollectUIContext;
import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.CollectStatus;
import com.huawei.ism.tool.infocollect.entity.ICollectInfo;
import com.huawei.ism.tool.infocollect.entity.InfocollectUserOpData;
import com.huawei.ism.tool.infocollect.entity.ProductConf;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.entity.command.ScriptItem;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.infocollect.service.CollectDeviceService;
import com.huawei.ism.tool.infocollect.service.ExitHookHelper;
import com.huawei.ism.tool.infocollect.service.logic.CollectSupport;
import com.huawei.ism.tool.infocollect.ui.InfoCollectMainDialog;
import com.huawei.ism.tool.infocollect.ui.support.OpenWindowRunnable;
import com.huawei.ism.tool.infocollect.ui.support.TemCollectData;
import com.huawei.ism.tool.infocollect.util.InfoCollectDirPropertiesUtil;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;
import utils.Products;

public class CollectMainWindowListener
extends WindowAdapter
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(CollectMainWindowListener.class);
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(CollectMainWindowListener.class);
    private static final String OPENPARAM_PREFIX = "DISK_SMARTINFO_PATH";
    private static final String OPENPARAM_TOOLID = "diskanalyze";
    private static final String ANOTHERTOOLFILE = "anothertool";
    private static final String DEVICEDATAFILE = "devicedatafile";
    private static final String FILEPATH = ApplicationContext.getInstance().getThirdPartyRuntimePath() + File.separator + "data";
    private static final String SCENE_SN = "SN";
    private static final String SCENE_IP = "IP";
    private static final String SCENE_DEV_STATUS = "status";
    private static final String SCENE_END_TIME = "endTime";
    private static final String SCENE_LOG_NAME = "fileName";
    private static final String SCENE_TOOL_ID = "toolId";
    private static final String SCENE_DEV_STATUS_FAILED = "failed";
    private static final String SCENE_DEV_STATUS_SUCCESS = "success";
    private static final String TOOL_ID = "collect";
    private static final String EMPTY_VALUE = "";
    private Map<DevNode, String> devsInfoMap = new ConcurrentHashMap<DevNode, String>();
    private InfoCollectMainDialog parentDlg;
    private boolean isOpenDiskTool = false;
    private List<String> smartCollectRetPaths = new ArrayList<String>();
    private List<String> smartPaths = new ArrayList<String>();
    private List<InfocollectUserOpData> userDataList = CollectDataContext.getInstance().getUserOpList();

    public CollectMainWindowListener(InfoCollectMainDialog parentDlg) {
        this.parentDlg = parentDlg;
        LOGGER.info("Information Collection start.");
    }

    @Override
    public void windowClosing(WindowEvent event) {
        this.action();
    }

    @Override
    public void windowOpened(WindowEvent event) {
        ThreadPool.getInstance().execute((Runnable)new OpenWindowRunnable(this.parentDlg));
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.action();
        }
    }

    private void action() {
        if (!CollectDataContext.getInstance().isCollecting()) {
            this.clear();
            return;
        }
        InfoCollectMainDialog parent = CollectUIContext.getInstance().getMainDialog();
        if (ApplicationContext.getInstance().isJunit()) {
            return;
        }
        WarningDialog dialog = DialogUtils.showYesNoDialog((Window)parent, (String)ResourceUtil.getString((String)"infocollect.remind.close"));
        if (0 == dialog.getValue()) {
            this.getShoutdownInfo(CollectDataContext.getInstance().getCollectingDevNodes());
            try {
                CollectSupport.getInstance().getExecutorService().shutdownNow();
            }
            catch (Exception e) {
                LOGGER.error("try to stop collect thread failed .", (Throwable)e);
            }
            this.clear();
        }
    }

    private void getShoutdownInfo(List<DevNode> collectingDevNodes) {
        for (DevNode devNode : collectingDevNodes) {
            ProductConf productConf = InfoConfiguration.getInstance().getProductConf(devNode);
            if (null == productConf || StringUtils.isNULLStr((String)productConf.getShutdownHook())) continue;
            StringBuffer scriptPath = new StringBuffer();
            scriptPath.append(InfoConfiguration.getInstance().getPackageScriptPath(devNode));
            scriptPath.append(File.separator + productConf.getShutdownHook());
            this.devsInfoMap.put(devNode, scriptPath.toString());
        }
    }

    private void callBackUserData() {
        for (String path : this.smartPaths) {
            this.getFileCollectPkgSize(path);
        }
        boolean useApply = CollectDataContext.getInstance().isUseApply();
        boolean logSplit = CollectDataContext.getInstance().isLogSplit();
        boolean openHelpFile = CollectDataContext.getInstance().isOpenHelpFile();
        if (!this.userDataList.isEmpty()) {
            for (InfocollectUserOpData infocollectUserOpData : this.userDataList) {
                Long taskEndTime = infocollectUserOpData.getTaskEndTime();
                if (taskEndTime == 0L) {
                    infocollectUserOpData.setTaskEndTime(DateUtil.toBeiJingTimeMillis((Date)new Date()));
                }
                infocollectUserOpData.setUseApply(useApply);
                infocollectUserOpData.setLogSplit(logSplit);
                infocollectUserOpData.setOpenHelpFile(openHelpFile);
            }
        }
        UserOpDataSaveUtil.batchSaveUserOpdata(this.userDataList);
    }

    private void callbackScene() {
        if (!CollectDataContext.getInstance().isScene()) {
            return;
        }
        String curTiem = this.getCurFarmatTime();
        ArrayList<Map<String, String>> sceneDevs = new ArrayList<Map<String, String>>();
        Collection<ICollectInfo> collectInfos = CollectDataContext.getInstance().getCollectInfoes();
        HashMap<String, CollectStatus> computeStorageStatus = new HashMap<String, CollectStatus>();
        List<ICollectInfo> newCollectInfos = this.mergeComputeStorageCollectResults(collectInfos, computeStorageStatus);
        for (ICollectInfo info : newCollectInfos) {
            Map<String, String> curCollectMap = this.createCollectMap(info, curTiem, computeStorageStatus);
            if (null == curCollectMap || curCollectMap.isEmpty()) continue;
            sceneDevs.add(curCollectMap);
        }
        if (sceneDevs.isEmpty()) {
            sceneDevs.add(this.createEmptyInfo());
        }
        CollectDataContext.getInstance().finishedSceneTask(sceneDevs);
    }

    private List<ICollectInfo> mergeComputeStorageCollectResults(Collection<ICollectInfo> collectInfos, Map<String, CollectStatus> computeStorageStatus) {
        List<String> fcvIps = this.getFcvIps(collectInfos);
        if (fcvIps.isEmpty()) {
            log.info("No computing storage device is logged in as the openapi user.");
            return new ArrayList<ICollectInfo>(collectInfos);
        }
        this.changCollectInfosStatus(fcvIps, collectInfos, computeStorageStatus);
        ArrayList<ICollectInfo> newCollectInfos = new ArrayList<ICollectInfo>();
        for (ICollectInfo info : collectInfos) {
            DevNode dev = info.getDevNode();
            if (this.isComputeStorageNodes(fcvIps, dev)) continue;
            newCollectInfos.add(info);
        }
        return newCollectInfos;
    }

    private void changCollectInfosStatus(List<String> fcvIps, Collection<ICollectInfo> collectInfos, Map<String, CollectStatus> computeStorageStatus) {
        List<String> needCheckIps = this.getNeedCheckIps(fcvIps, collectInfos);
        if (needCheckIps.isEmpty()) {
            log.info("The status of computing storage devices does not need to be changed.");
            return;
        }
        needCheckIps.forEach(ip -> computeStorageStatus.put((String)ip, this.getComputeStorageStatus(this.getCollectStatus(collectInfos, (String)ip))));
    }

    private CollectStatus getComputeStorageStatus(List<CollectStatus> collectStatus) {
        if (collectStatus.stream().anyMatch(status -> CollectStatus.COLLECT_FINISHED.equals(status) || CollectStatus.COLLECT_FINISHED_NOTALL.equals(status))) {
            return CollectStatus.COLLECT_FINISHED;
        }
        if (collectStatus.stream().allMatch(CollectStatus.NOT_COLLECT::equals)) {
            return CollectStatus.NOT_COLLECT;
        }
        return CollectStatus.COLLECT_FAILED;
    }

    @NotNull
    private List<CollectStatus> getCollectStatus(Collection<ICollectInfo> collectInfos, String ip) {
        return collectInfos.stream().filter(info -> this.isSpecifiedCollectInfo(ip, (ICollectInfo)info)).map(ICollectInfo::getCollectStatus).collect(Collectors.toList());
    }

    private boolean isSpecifiedCollectInfo(String ip, ICollectInfo info) {
        return Products.isOceanStoComputingDev((String)info.getDevNode().getDeviceType().toString()) && ip.equals(info.getDevNode().getComputeStorageDevNode().getFcvIp());
    }

    @NotNull
    private List<String> getNeedCheckIps(List<String> fcvIps, Collection<ICollectInfo> collectInfos) {
        return collectInfos.stream().filter(info -> this.needCheck(fcvIps, (ICollectInfo)info)).map(info -> info.getDevNode().getIp()).collect(Collectors.toList());
    }

    private boolean needCheck(List<String> fcvIps, ICollectInfo info) {
        return (CollectStatus.NOT_COLLECT.equals((Object)info.getCollectStatus()) || CollectStatus.COLLECT_FAILED.equals((Object)info.getCollectStatus())) && fcvIps.contains(info.getDevNode().getIp());
    }

    @NotNull
    private List<String> getFcvIps(Collection<ICollectInfo> collectInfos) {
        return collectInfos.stream().map(ICollectInfo::getDevNode).filter(InfoCollectUtil::isComputeStorageDevLoginThroughFcv).map(DevNode::getIp).collect(Collectors.toList());
    }

    private boolean isComputeStorageNodes(List<String> fcvIps, DevNode dev) {
        return Products.isOceanStoComputingDev((String)dev.getDeviceType().toString()) && !dev.getIp().equals(dev.getComputeStorageDevNode().getFcvIp()) && fcvIps.contains(dev.getComputeStorageDevNode().getFcvIp());
    }

    private Map<String, String> createCollectMap(ICollectInfo info, String time, Map<String, CollectStatus> computeStorageStatus) {
        HashMap<String, String> scenceDevInfo = new HashMap<String, String>();
        DevNode devNode = info.getDevNode();
        CollectStatus status = computeStorageStatus.getOrDefault(devNode.getIp(), info.getCollectStatus());
        String ipStr = this.getIpStr(devNode);
        String snNum = devNode.getDeviceSerialNumber();
        String logFileName = info.getCollectRetFilePath();
        if (CollectStatus.NOT_COLLECT == status) {
            return null;
        }
        if (CollectStatus.COLLECT_FINISHED == status || CollectStatus.COLLECT_FINISHED_NOTALL == status) {
            scenceDevInfo.put(SCENE_DEV_STATUS, SCENE_DEV_STATUS_SUCCESS);
            scenceDevInfo.put(SCENE_LOG_NAME, logFileName);
        } else {
            scenceDevInfo.put(SCENE_DEV_STATUS, SCENE_DEV_STATUS_FAILED);
        }
        scenceDevInfo.put(SCENE_END_TIME, time);
        scenceDevInfo.put(SCENE_SN, snNum);
        scenceDevInfo.put(SCENE_IP, ipStr);
        scenceDevInfo.put(SCENE_TOOL_ID, TOOL_ID);
        return scenceDevInfo;
    }

    String getIpStr(DevNode devNode) {
        return InfoCollectUtil.isSupportA800Scene() ? this.getA800IpStr(devNode) : devNode.getIp();
    }

    @NotNull
    private String getA800IpStr(DevNode devNode) {
        return InfoCollectUtil.isA800Zone(devNode) ? devNode.getIp() + "_zone" : devNode.getIp() + "_om";
    }

    private Map<String, String> createEmptyInfo() {
        HashMap<String, String> scenceDevInfo = new HashMap<String, String>();
        scenceDevInfo.put(SCENE_DEV_STATUS, EMPTY_VALUE);
        scenceDevInfo.put(SCENE_LOG_NAME, EMPTY_VALUE);
        scenceDevInfo.put(SCENE_END_TIME, EMPTY_VALUE);
        scenceDevInfo.put(SCENE_SN, EMPTY_VALUE);
        scenceDevInfo.put(SCENE_IP, EMPTY_VALUE);
        scenceDevInfo.put(SCENE_TOOL_ID, TOOL_ID);
        return scenceDevInfo;
    }

    private String getCurFarmatTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(new Date());
    }

    private void doOpenDiskAnaTool() {
        this.buildJumpParam();
        this.confirmJumpInfo();
    }

    private void confirmJumpInfo() {
        String msg;
        WarningDialog dlg;
        if (!CollectDataContext.getInstance().isStorageCollectSec()) {
            this.isOpenDiskTool = false;
            return;
        }
        ToolLoginUser loginUser = com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getToolLoginUser();
        ToolUserRole role = loginUser.getUserRunRole();
        if (null == role || ToolUserRole.GUEST.equals((Object)role)) {
            LOGGER.info("Current tool user is null or guest.");
            if (!loginUser.isInTrial()) {
                LOGGER.info("get user role failed or user role don't support for DiskHealthAnalyze.");
                this.isOpenDiskTool = false;
                return;
            }
        }
        AbstractToolBox container = com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getToolContainer();
        if (this.isOpenDiskTool && container.containsIndependentTool(OPENPARAM_TOOLID) && 0 != (dlg = DialogUtils.showYesNoDialog((Window)this.parentDlg, (String)(msg = ResourceUtil.getString((String)"infocollect.collectover.quitmsg.opentool")))).getValue()) {
            this.isOpenDiskTool = false;
        }
    }

    private void buildJumpParam() {
        Collection<ICollectInfo> collectInfos = CollectDataContext.getInstance().getCollectInfoes();
        this.smartCollectRetPaths.clear();
        int pathCount = 0;
        StringBuilder dirBd = new StringBuilder();
        dirBd.append(OPENPARAM_PREFIX);
        dirBd.append("=");
        dirBd.append(InfoCollectDirPropertiesUtil.getProperty());
        this.smartCollectRetPaths.add(dirBd.toString());
        for (ICollectInfo info : collectInfos) {
            CollectStatus status = info.getCollectStatus();
            if (CollectStatus.COLLECT_FINISHED != status && CollectStatus.COLLECT_FINISHED_NOTALL != status) continue;
            LOGGER.info(String.format(Locale.ROOT, "Get File Path : %s", info.getCollectRetFilePath()));
            this.smartPaths.add(info.getCollectRetFilePath());
            List<CollectItem> items = info.getCollectConfInfo().getSelectItems();
            for (CollectItem item : items) {
                String name = item.getNameKey();
                if (!(name = String.valueOf(name).toLowerCase(Locale.ENGLISH)).contains("smart") || !this.itemCollectSuc(item, info)) continue;
                this.isOpenDiskTool = true;
                ++pathCount;
                StringBuilder sbr = new StringBuilder();
                sbr.append(OPENPARAM_PREFIX);
                sbr.append("_");
                sbr.append(pathCount);
                sbr.append("=");
                sbr.append(info.getCollectRetFilePath());
                this.smartCollectRetPaths.add(sbr.toString());
            }
        }
    }

    private void getFileCollectPkgSize(String sbr) {
        for (InfocollectUserOpData userData : this.userDataList) {
            String deviType = userData.getDeviceType();
            StringBuilder build = new StringBuilder();
            if (deviType.contains(" ")) {
                String[] str;
                for (String string : str = deviType.split(" ")) {
                    build.append(string);
                }
            }
            if (!sbr.contains(userData.getDevNode().getIp())) {
                ToolLoggerFactory.getLogger(this.getClass()).info("The file absolute path :" + sbr + " is not include this IP : " + userData.getDevNode().getIp());
                continue;
            }
            userData.setCollectPkgSize(this.getFileSize(new File(sbr)));
        }
    }

    private Long getFileSize(File file) {
        Long size = 0L;
        if (file.exists()) {
            Long fileLength = file.length();
            size = fileLength / 1024L;
        }
        ToolLoggerFactory.getLogger(this.getClass()).info("Size : " + size);
        return size;
    }

    private boolean itemCollectSuc(CollectItem item, ICollectInfo info) {
        List<ExecuteResult> rets = info.getExecuteResults();
        for (ExecuteResult ret : rets) {
            ScriptItem scItem = ret.getItem();
            if (null == scItem || !scItem.getStep().equals(item.getId())) continue;
            return ret.isSuccess();
        }
        return false;
    }

    private void clear() {
        try {
            this.callbackScene();
            CollectDataContext.getInstance().setStartCollect(false);
            if (!this.devsInfoMap.isEmpty()) {
                AsyncExcutor.execute((Window)CollectUIContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"infocollect.remind.closetips.clear"), (int)300, (Callable[])new Callable[]{new ExitHookHelper(this.devsInfoMap)});
            } else {
                AsyncExcutor.execute((Window)CollectUIContext.getInstance().getMainDialog(), (Callable[])new Callable[]{new TemCollectData()});
            }
            CollectDataContext.getInstance().getHasImportPatchDevs().forEach(devNode -> Context.INS.uninstallAutoImportPatch(devNode, DstoragePatchInfo.Type.COLLECT, null));
            this.saveLabelFile();
            this.clearResByOBS();
            this.callBackUserData();
            this.clearAnotherToolFile(String.join((CharSequence)File.separator, ApplicationContext.getInstance().getWorkPath(), "temp", ANOTHERTOOLFILE));
            CollectDataContext.getInstance().clear();
            InfoConfiguration.getInstance().clear();
            CollectUIContext.getInstance().clear();
        }
        catch (Throwable e) {
            LOGGER.error("Close windows error.", e);
        }
        finally {
            AbstractToolBox toolBox = PlatformAppContext.getInstance().getToolBox();
            if (null != toolBox) {
                toolBox.fireToolStopped(toolBox.getId());
            } else {
                Runtime.getRuntime().halt(0);
            }
        }
    }

    void clearAnotherToolFile(String path) {
        log.info("start clear anotherToolFile...");
        File anotherToolFile = new File(path);
        if (!anotherToolFile.exists()) {
            log.info("anotherToolFile is not exist...");
            return;
        }
        log.info("delete another tool file status : {}", (Object)anotherToolFile.delete());
    }

    private void clearResByOBS() {
        List<String> snList = CollectDeviceService.getDeviceHasDownResFile();
        if (!snList.isEmpty()) {
            for (String sn : snList) {
                String toPath = BizPackageService.PACKAGE_PRODUCTS_DIR + File.separator + "Dstorage_" + sn;
                File file = new File(toPath);
                FilesUtil.clearFolder((File)file);
                if (file.delete()) continue;
                LOGGER.info("file delete error:{}", (Object)toPath);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private void saveLabelFile() {
        AbstractToolBox container = com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getToolContainer();
        if (this.isOpenDiskTool && container.containsIndependentTool(OPENPARAM_TOOLID)) {
            String[] param = this.smartCollectRetPaths.toArray(new String[0]);
            String lablePathFile = FILEPATH + File.separator + ANOTHERTOOLFILE;
            String devDataPathFile = FILEPATH + File.separator + DEVICEDATAFILE;
            this.saveAnotherToolLabel(lablePathFile, "collect-diskanalyze");
            this.saveAnotherToolLabel(devDataPathFile, param);
        }
    }

    private void saveAnotherToolLabel(String path, String ... params) {
        File file = new File(path);
        if (!file.exists()) {
            boolean flag;
            try {
                flag = file.createNewFile();
            }
            catch (IOException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("create file error.");
                return;
            }
            if (!flag) {
                return;
            }
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            for (String string : params) {
                writer.write(string.trim() + ":Separated:");
            }
        }
        catch (FileNotFoundException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("FileOutputStream error.file {} not found exception.", (Object)file.getName());
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("write file error." + e.getMessage());
        }
    }
}

