/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.support;

import com.huawei.ism.tool.infocollect.CollectUIContext;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.ui.support.ProgressBox;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class DetailListCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 100000010L;
    private static final int NUMBER_100 = 100;
    private static final int NUMBER_180 = 180;
    private static final int NUMBER_280 = 280;
    private static final int NUMBER_39 = 39;
    private static final int NUMBER_520 = 520;
    private static final int NUMBER_18 = 18;
    private static final int NUMBER_370 = 370;
    private static final int NUMBER_300 = 300;
    private static final Color COLOR_BEFORE_CLICK = new Color(4359891);

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color bg = null;
        boolean isComponentSelected = isSelected;
        JList.DropLocation dropLocation = list.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
            bg = UIManager.getColor("List.dropCellBackground");
            isComponentSelected = true;
        }
        JPanel viewPan = new JPanel();
        if (value instanceof ExecuteResult) {
            ExecuteResult result = (ExecuteResult)value;
            this.setView(result, viewPan);
        }
        viewPan.setComponentOrientation(list.getComponentOrientation());
        viewPan.setEnabled(list.isEnabled());
        viewPan.setFont(list.getFont());
        if (isComponentSelected) {
            viewPan.setBackground(bg == null ? list.getSelectionBackground() : bg);
            UiMethod.setBatchComponentProperty((String)"setForeground", (Object[])new Object[]{Color.WHITE}, (JComponent[])new JComponent[]{viewPan});
        } else {
            viewPan.setBackground(list.getBackground());
            viewPan.setForeground(list.getForeground());
        }
        return viewPan;
    }

    private void setView(ExecuteResult result, JPanel viewPan) {
        JLabel devNodeLabel = new JLabel();
        int dLength = this.initDevLabel(result, devNodeLabel);
        JLabel descLabel = new JLabel(result.getDescription());
        this.initDescLable(result, descLabel, dLength);
        JComponent dateComp = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalStrut(5), new JLabel(result.getStartDateString())});
        JComponent view = null;
        JLabel resultLabel = new JLabel("");
        resultLabel.setForeground(COLOR_BEFORE_CLICK);
        if (!result.isProcessing() && !result.isStopping()) {
            resultLabel.setIcon(this.getResultIcon(result));
            resultLabel.setText(this.getResultString(result));
            view = UCD.buildHorizotalBox(null, (Component[])new Component[]{dateComp, devNodeLabel, descLabel, Box.createGlue(), resultLabel, Box.createHorizontalStrut(8)});
        } else if (result.isStopping()) {
            resultLabel.setIcon(result.getIcon());
            resultLabel.setText(ResourceUtil.getString((String)"infocollect.stopping"));
            view = UCD.buildHorizotalBox(null, (Component[])new Component[]{dateComp, devNodeLabel, descLabel, Box.createGlue(), resultLabel, Box.createHorizontalStrut(8)});
        } else {
            JLabel remainTimeLabel = new JLabel("");
            JLabel progressExtrasInfoLabel = new JLabel(result.getProgressExtrasInfo());
            String remainTime = result.getRemainTime();
            int singleProgress = result.getSingleProgress();
            if (singleProgress > 0) {
                remainTimeLabel.setText(singleProgress + "%");
            }
            if (!StringUtils.isNULLStr((String)remainTime)) {
                remainTimeLabel.setText(String.format(Locale.ROOT, "%s  %s%s", remainTimeLabel.getText(), ResourceUtil.getString((String)"infocollect.detail.timeleft"), remainTime));
            }
            resultLabel.setIcon(result.getIcon());
            resultLabel.setText(ResourceUtil.getString((String)"infocollect.processing"));
            ProgressBox progressBox = new ProgressBox(null, result.getSingleProgress(), dateComp, devNodeLabel, descLabel, Box.createGlue(), progressExtrasInfoLabel, remainTimeLabel, resultLabel, Box.createHorizontalStrut(8));
            view = progressBox;
        }
        viewPan.setLayout(new BorderLayout());
        viewPan.add((Component)view, "Center");
        viewPan.setToolTipText(result.getDescription());
    }

    private void initDescLable(ExecuteResult result, JLabel descLabel, int dLength) {
        if (null != result.getColor()) {
            descLabel.setForeground(result.getColor());
        }
        int length = 370;
        if (result.getDevNode() != null && result.getDevNode().isDsStorage()) {
            length = 300;
        }
        UiMethod.setComponentSize((Dimension)new Dimension(length - dLength, 18), (Component[])new Component[]{descLabel});
    }

    private int initDevLabel(ExecuteResult result, JLabel devNodeLabel) {
        devNodeLabel.setPreferredSize(new Dimension(100, devNodeLabel.getPreferredSize().height));
        int dLength = 0;
        if (result.getDevNode() != null) {
            String ip = result.getDevNode().getIp();
            dLength = this.incrementLength(ip.length());
            if (StringUtils.isIpv6Address((String)ip) && dLength > 0) {
                devNodeLabel.setPreferredSize(new Dimension(dLength + 100, devNodeLabel.getPreferredSize().height));
            }
            devNodeLabel.setText(result.getDevNode().getIp());
        }
        return dLength;
    }

    private int incrementLength(int len) {
        return Math.min(280 * len / 39 - 100, 180);
    }

    public String getResultString(ExecuteResult result) {
        if (!result.isSuccess()) {
            return ResourceUtil.getString((String)"infocollect.failed");
        }
        if (result.getUnableSupport()) {
            return ResourceUtil.getString((String)"infocollect.dev.status.unsupport");
        }
        if (result.isCollectAllInfo()) {
            return ResourceUtil.getString((String)"infocollect.success");
        }
        return ResourceUtil.getString((String)"infocollect.notall");
    }

    private ImageIcon getResultIcon(ExecuteResult result) {
        if (!result.isSuccess()) {
            return CollectUIContext.FAILED_IMAGE;
        }
        if (result.getUnableSupport()) {
            return CollectUIContext.UNSUPPORT_IMAGE;
        }
        if (result.isCollectAllInfo()) {
            return CollectUIContext.SUCCESS_IMAGE;
        }
        return CollectUIContext.PARTIAL_SUCCESS_IMAGE;
    }
}

