/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.support;

import com.huawei.ism.tool.infocollect.service.CollectDeviceService;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.util.SwingUtil;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceDownLoadTask
implements Callable<Boolean> {
    private static final Logger log = LoggerFactory.getLogger(DeviceDownLoadTask.class);
    private final ProgressDialog progressDialog;
    private final DevNode device;

    public DeviceDownLoadTask(DevNode device) {
        this(null, device);
    }

    @Override
    public Boolean call() {
        try {
            if (!this.shouldDownLoadRes()) {
                Boolean bl = true;
                return bl;
            }
            if (!CollectDeviceService.getInstance().queryDstorageClusterNodes(this.device)) {
                log.error("Failed to query nodes of a device. ");
                this.device.setErrorDecs(ResourceUtil.getString((String)"query.cluster.nodes.info.failed"));
                Boolean bl = false;
                return bl;
            }
            if (!CollectDeviceService.getInstance().getResourceFileAndImportAsPackage(this.device)) {
                this.device.setErrorDecs(ResourceUtil.getString((String)"download.info.res.files.failed"));
                log.error("Download dstorage info collect resource file failed.");
                Boolean bl = false;
                return bl;
            }
            log.info("download info collect resource file success.");
        }
        catch (Exception e) {
            log.error("wait dstorage download resource file failed.", (Throwable)e);
            this.device.setErrorDecs(ResourceUtil.getString((String)"download.info.collect.res.file.exception"));
            Boolean bl = false;
            return bl;
        }
        finally {
            if (this.progressDialog != null) {
                SwingUtil.disPoseDialg((ProgressDialog)this.progressDialog);
            }
        }
        return true;
    }

    private boolean shouldDownLoadRes() {
        return !CollectDeviceService.getDeviceHasDownResFile().contains(this.device.getDeviceSerialNumber()) || !CollectDeviceService.getInstance().hasStoragePoolInfo(this.device);
    }

    public DeviceDownLoadTask(ProgressDialog progressDialog, DevNode device) {
        this.progressDialog = progressDialog;
        this.device = device;
    }
}

