/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.support;

import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.util.SwingUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceQueryCliCommandTask
implements Callable<Map<String, String>> {
    private static final Logger log = LoggerFactory.getLogger(DeviceQueryCliCommandTask.class);
    private static final Pattern TIME_OUT_REX = Pattern.compile("[Tt]ime[Oo]ut\\s*:\\s*(\\d+)\\s*min");
    private final ProgressDialog progressDialog;
    private final List<DevNode> devNodeList;
    private final Map<String, String> deviceKeepAliveTimeMap = new HashMap<String, String>();

    @Override
    public Map<String, String> call() {
        try {
            this.devNodeList.forEach(this::getKeepAliveTime);
        }
        finally {
            if (this.progressDialog != null) {
                SwingUtil.disPoseDialg((ProgressDialog)this.progressDialog);
            }
        }
        return this.deviceKeepAliveTimeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getKeepAliveTime(DevNode devNode) {
        SshConnection sshConnection;
        block6: {
            ICliConnection iCliConnection;
            block5: {
                sshConnection = null;
                iCliConnection = SshConnectionManager.getSshConnection((DevNode)devNode);
                if (iCliConnection instanceof SshConnection) break block5;
                if (ObjectUtils.isEmpty(sshConnection)) return;
                SshConnectionManager.releaseConnection((ICliConnection)sshConnection);
                return;
            }
            try {
                sshConnection = (SshConnection)iCliConnection;
                String res = sshConnection.execCmdWithTimout("show cli configuration", 20);
                Matcher matcher = TIME_OUT_REX.matcher(res);
                if (!matcher.find()) break block6;
                this.deviceKeepAliveTimeMap.put(devNode.getIp(), matcher.group(1));
            }
            catch (ToolException e) {
                try {
                    log.error("query device [{}] keep alive time failed", (Object)devNode.getIp(), (Object)e);
                }
                catch (Throwable throwable) {
                    if (ObjectUtils.isEmpty(sshConnection)) throw throwable;
                    SshConnectionManager.releaseConnection(sshConnection);
                    throw throwable;
                }
                if (ObjectUtils.isEmpty((Object)sshConnection)) return;
                SshConnectionManager.releaseConnection((ICliConnection)sshConnection);
                return;
            }
        }
        if (ObjectUtils.isEmpty((Object)sshConnection)) return;
        SshConnectionManager.releaseConnection((ICliConnection)sshConnection);
        return;
    }

    public DeviceQueryCliCommandTask(ProgressDialog progressDialog, List<DevNode> devNodeList) {
        this.progressDialog = progressDialog;
        this.devNodeList = devNodeList;
    }
}

