/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.support;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.infocollect.entity.IntegrateCollectInfo;
import com.huawei.ism.tool.infocollect.service.CollectDeviceService;
import com.huawei.ism.tool.infocollect.service.InfoCollectService;
import com.huawei.ism.tool.infocollect.ui.InfoCollectMainDialog;
import com.huawei.ism.tool.infocollect.ui.card.NodeSelectionCard;
import com.huawei.ism.tool.infocollect.ui.card.ParamSettingCloseObserver;
import com.huawei.ism.tool.infocollect.ui.card.storage.OceanStor9000NodeSelectionCard;
import com.huawei.ism.tool.infocollect.ui.setup.CollectNewSetupDialog;
import com.huawei.ism.tool.infocollect.ui.setup.IntegrateCollectSetupDialog;
import com.huawei.ism.tool.infocollect.ui.setup.SelectCollectSceneDialog;
import com.huawei.ism.tool.infocollect.ui.setup.dpc.DataTurboSetupDialog;
import com.huawei.ism.tool.infocollect.ui.support.DeviceDownLoadTask;
import com.huawei.ism.tool.infocollect.ui.support.GetActionListener;
import com.huawei.ism.tool.infocollect.ui.support.QueryDevCurDate;
import com.huawei.ism.tool.infocollect.ui.support.SearchCallable;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.wizard.IWizardClosingObserver;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.util.SwingUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceSetupIcon
extends IsmTableCell.IconCell {
    private static final Logger log = LoggerFactory.getLogger(DeviceSetupIcon.class);
    private static final Dimension REDUCE_COLLECT_SIZE = new Dimension(950, 700);
    private static final Dimension COLLECT_BY_SCENE_SIZE = new Dimension(830, 580);
    private static final Dimension COLLECT_BY_SCENE_SIZE_EN = new Dimension(950, 580);
    private static final long serialVersionUID = 1L;
    private static final Object LOCK_OBJECT = new Object();
    private DevNode device = null;
    private InfoCollectMainDialog parent = null;
    private SelectCollectSceneDialog selectCollectRoleDialog = null;
    private boolean isChooseSimpleCollect = false;
    private String integrateXml = "";

    public DeviceSetupIcon(DevNode node, InfoCollectMainDialog parent) {
        super((Icon)ResourceUtil.getImage((String)"devicemodify.png"), ResourceUtil.getString((String)"infocollect.setup"));
        this.device = node;
        this.parent = parent;
    }

    private void waitInfoCollectResDownload() {
        ProgressDialog progressDialog = new ProgressDialog((Window)this.parent);
        DeviceDownLoadTask downLoadTask = new DeviceDownLoadTask(progressDialog, this.device);
        Future downLoadFuture = AsyncExcutor.submit((Callable)downLoadTask);
        progressDialog.setVisible(true);
        try {
            downLoadFuture.get();
        }
        catch (InterruptedException e) {
            log.error("download future get InterruptedException:" + e);
        }
        catch (ExecutionException e) {
            log.error("download future get ExecutionException:" + e);
        }
    }

    public void action() {
        IntegrateCollectInfo collectInfo;
        this.parent.refurbishDetailList();
        InfoCollectService service = InfoCollectService.getInstance();
        if (service.isMainDevNodeCollecting(this.device)) {
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"infocollect.remind.itemiscollecting"));
            return;
        }
        if (this.device.isDsStorage() && !InfoCollectUtil.isA800Om(this.device)) {
            this.waitInfoCollectResDownload();
            if (!StringUtils.isNULLStr((String)this.device.getErrorDecs())) {
                DialogUtils.showErrorDialog((JDialog)this.parent, (String)this.device.getErrorDecs());
                return;
            }
        }
        if ((collectInfo = service.constructIntegrateInfo(this.device)) == null) {
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"infocollect.remind.unsupportdev"));
            return;
        }
        if (InfoCollectUtil.isA800Om(this.device)) {
            this.initDataTurboSetupWindow();
            return;
        }
        this.searchIntegrateInfo(collectInfo);
        if (this.device.isDsStorage()) {
            this.startWizard(this.parent, this.device);
            return;
        }
        if (InfoCollectUtil.isNewOceanStor9000(this.device)) {
            this.initOceanStor9000Window();
            return;
        }
        if (InfoCollectUtil.isSupportCollectedByScene(this.device)) {
            this.initSetupWindow();
            return;
        }
        String devicedate = this.getDateInfo(this.device);
        if (InfoCollectUtil.isComputeStorageDevLoginThroughFcv(this.device) && !StringUtils.isNULLStr((String)devicedate)) {
            this.device.setDevCurrentTime(InfoCollectUtil.formatStringDataToTimeMillis(devicedate));
        }
        IntegrateCollectSetupDialog.showCollectSetupDialog(this.parent, this.device, this.getIntegrateXml(), devicedate, this.isChooseSimpleCollect);
    }

    private void initDataTurboSetupWindow() {
        log.info("Start init DataTurbo setup window.");
        DataTurboSetupDialog dataTurboSetupDialog = new DataTurboSetupDialog(this.parent, this.device);
        dataTurboSetupDialog.setTitle(ResourceUtil.getString((String)"collect.wizard.param.setting.title"));
        dataTurboSetupDialog.setSize(ApplicationContext.getInstance().isEnglishEnv() ? COLLECT_BY_SCENE_SIZE_EN : COLLECT_BY_SCENE_SIZE);
        SwingUtil.putScreenCenter((Window)((Object)dataTurboSetupDialog));
        dataTurboSetupDialog.setVisible(true);
    }

    private void initOceanStor9000Window() {
        ToolWizardDialog paramSettingWizard = new ToolWizardDialog((Dialog)this.parent, this.getStepNames(), false);
        paramSettingWizard.setWizardName(ResourceUtil.getString((String)"collect.wizard.step.name"));
        paramSettingWizard.setTitle(ResourceUtil.getString((String)"collect.wizard.param.setting.title"));
        paramSettingWizard.setResizable(false);
        paramSettingWizard.setFirstCard((ToolWizardDialog.Card)new OceanStor9000NodeSelectionCard(this.parent, this.device, paramSettingWizard, null));
        paramSettingWizard.setObserver((IWizardClosingObserver)new ParamSettingCloseObserver(paramSettingWizard));
        UiMethod.setComponentSize((Dimension)REDUCE_COLLECT_SIZE, (Component[])new Component[]{paramSettingWizard});
        SwingUtil.putScreenCenter((Window)paramSettingWizard);
        SwingUtilities.invokeLater(() -> paramSettingWizard.setVisible(true));
    }

    private void initSetupWindow() {
        CollectNewSetupDialog collectNewSetupDialog = new CollectNewSetupDialog(this.parent, this.device);
        collectNewSetupDialog.setTitle(ResourceUtil.getString((String)"infocollect.devicesetup.title"));
        collectNewSetupDialog.setSize(COLLECT_BY_SCENE_SIZE);
        SwingUtil.putScreenCenter((Window)((Object)collectNewSetupDialog));
        collectNewSetupDialog.setVisible(true);
    }

    private void startWizard(JDialog parent, DevNode deviceNode) {
        ToolWizardDialog paramSettingWizard = new ToolWizardDialog((Dialog)parent, this.getStepNames(), false);
        NodeSelectionCard nodeSelectionCard = new NodeSelectionCard(deviceNode, paramSettingWizard, null);
        paramSettingWizard.setWizardName(ResourceUtil.getString((String)"collect.wizard.step.name"));
        paramSettingWizard.setTitle(ResourceUtil.getString((String)"collect.wizard.param.setting.title"));
        paramSettingWizard.setResizable(false);
        paramSettingWizard.setFirstCard((ToolWizardDialog.Card)nodeSelectionCard);
        paramSettingWizard.setObserver((IWizardClosingObserver)new ParamSettingCloseObserver(paramSettingWizard));
        UiMethod.setComponentSize((Dimension)REDUCE_COLLECT_SIZE, (Component[])new Component[]{paramSettingWizard});
        SwingUtil.putScreenCenter((Window)paramSettingWizard);
        SwingUtilities.invokeLater(() -> paramSettingWizard.setVisible(true));
    }

    private List<String[]> getStepNames() {
        ArrayList<String[]> steps = new ArrayList<String[]>();
        String[] step0 = new String[]{ResourceUtil.getString((String)"collect.wizard.step1.title"), ResourceUtil.getString((String)"collect.wizard.step1.desc")};
        steps.add(step0);
        String[] step1 = new String[]{ResourceUtil.getString((String)"collect.wizard.step2.title"), ResourceUtil.getString((String)"collect.wizard.step2.desc")};
        steps.add(step1);
        return steps;
    }

    private String getDateInfo(DevNode dev) {
        if (this.device.isDsStorage()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(new Date(dev.getDevCurrentTime()));
        }
        String path = CollectDeviceService.getInstance().getDateScriptPath(this.device);
        if (StringUtils.isNULLStr((String)path)) {
            return "";
        }
        List result = AsyncExcutor.execute((Window)this.parent, (Callable[])new Callable[]{new QueryDevCurDate(dev, path)});
        return (String)result.get(0);
    }

    private void searchIntegrateInfo(IntegrateCollectInfo collectInfo) {
        String path = CollectDeviceService.getInstance().getIntegrateScriptPath(this.device);
        if (StringUtils.isNULLStr((String)path)) {
            return;
        }
        SearchCallable callable = new SearchCallable(collectInfo, path, this);
        AsyncExcutor.execute((Window)this.parent, (Callable[])new Callable[]{callable});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIntegrateXml() {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            return this.integrateXml;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntegrateXml(String integrateXml) {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            this.integrateXml = integrateXml;
        }
    }

    public ActionListener getAction() {
        return new GetActionListener(this);
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

