/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.support;

import com.huawei.ism.tool.infocollect.entity.CollectStatus;
import com.huawei.ism.tool.infocollect.entity.command.ExecuteResult;
import com.huawei.ism.tool.infocollect.ui.InfoCollectMainDialog;
import com.huawei.ism.tool.infocollect.ui.support.StopActionListener;
import com.huawei.ism.tool.infocollect.ui.support.StopFlag;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceStopIcon
extends IsmTableCell.IconCell {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceStopIcon.class);
    private static final Object LOCK_OBJECT = new Object();
    private DevNode device;
    private InfoCollectMainDialog parent;
    private String integrateXml = "";
    private Map<String, Object> collectEnv;
    private ExecuteResult processingResult;

    public DeviceStopIcon(DevNode node, InfoCollectMainDialog parent, Map<String, Object> collectEnv, ExecuteResult processingResult) {
        super((Icon)ResourceUtil.getImage((String)"devicemodify.png"), ResourceUtil.getString((String)"infocollect.stop"));
        this.device = node;
        this.parent = parent;
        this.collectEnv = collectEnv;
        this.processingResult = processingResult;
    }

    public void action() {
        if (this.processingResult.isStopping()) {
            DialogUtils.showErrorDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"infocollect.remind.itemisstopping"));
            return;
        }
        LOGGER.info("Stop disklog collection is triggered.");
        StopFlag sf = (StopFlag)this.collectEnv.get("stop");
        sf.setStopped(true);
        this.processingResult.setNowStatus(CollectStatus.COLLECT_STOPPING);
    }

    public ActionListener getAction() {
        return new StopActionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIntegrateXml() {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            return this.integrateXml;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntegrateXml(String integrateXml) {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            this.integrateXml = integrateXml;
        }
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

