/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.support;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Box;

public class ProgressBox
extends Box {
    private static final long serialVersionUID = 1L;
    private static final Color DEFAULT = new Color(125, 173, 225);
    private int progress;
    private Color color;

    public ProgressBox(Color color, int progress, Component ... components) {
        super(0);
        this.color = color == null ? DEFAULT : color;
        this.progress = 0;
        this.progress = Math.min(100, Math.max(0, progress));
        this.addComs(components);
        if (this.progress > 0) {
            this.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
        }
    }

    @Override
    public void paintComponent(Graphics graphic) {
        super.paintComponent(graphic);
        Graphics graphics = graphic.create();
        if (this.progress > 0) {
            graphics.setColor(this.color);
            graphics.fillRect(0, 0, this.getWidth() * this.progress / 100, this.getHeight());
        }
    }

    private void addComs(Component ... components) {
        if (null == components || components.length == 0) {
            return;
        }
        if (null != components[0]) {
            this.add(components[0]);
        }
        for (int index = 1; index < components.length; ++index) {
            if (null == components[index]) continue;
            this.add(Box.createHorizontalStrut(12));
            this.add(components[index]);
        }
    }
}

