/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.support;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.infocollect.ui.support.ShowPreResultLayout;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;

public class ShowPreResultDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Dimension DIALOG_SIZE = new Dimension(500, 345);
    private static final int INT0 = 0;
    private static final int INT1 = 1;
    private ShowPreResultLayout layout = new ShowPreResultLayout();
    private Map<DevNode, String> dataMap;
    private List<DevNode> unSelectNode = new ArrayList<DevNode>();
    private boolean keep = false;

    public ShowPreResultDialog(JDialog parent, Map<DevNode, String> dataMap) {
        super(parent);
        this.dataMap = dataMap;
        this.addListener();
        this.initUI();
    }

    private void initUI() {
        this.setTitle(ResourceUtil.getString((String)"infocollect.devicesetup.result.prequery.title"));
        this.initTable();
        this.add(this.layout);
        UiMethod.setComponentSize((Dimension)DIALOG_SIZE, (Component[])new Component[]{this});
        UiMethod.putScreenCenter((Window)this);
        this.setModal(true);
        this.setVisible(true);
    }

    private void initTable() {
        for (Map.Entry<DevNode, String> entry : this.dataMap.entrySet()) {
            DevNode devNode = entry.getKey();
            String reason = entry.getValue();
            this.layout.getModel().addRow(new TableRow[]{this.createTableRow(devNode, reason)});
        }
        this.layout.getTable().selectAll();
    }

    private TableRow<DevNode, String> createTableRow(DevNode devNode, String reason) {
        DefaultTableRow row = new DefaultTableRow(this.layout.getColumnNames().length, (Object)devNode, (Object)(devNode.getDeviceSerialNumber() + devNode.getDeviceType()));
        row.setValueAt(0, (Object)devNode.getIp());
        row.setValueAt(1, (Object)reason);
        return row;
    }

    private void addListener() {
        this.layout.getOkBtn().addActionListener(event -> {
            this.getUnSelectDevNodes();
            this.dispose();
            this.keep = true;
        });
        this.layout.getCloseBtn().addActionListener(event -> {
            this.dispose();
            this.keep = false;
        });
    }

    private void getUnSelectDevNodes() {
        int rowCount = this.layout.getTable().getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (this.layout.getTable().isRowSelected(i)) continue;
            TableRow row = this.layout.getModel().getRow(i);
            DevNode node = (DevNode)row.getUserObject();
            this.unSelectNode.add(node);
        }
    }

    public boolean isKeep() {
        return this.keep;
    }

    public List<DevNode> getUnSelectNode() {
        return this.unSelectNode;
    }
}

