/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.support.devselect;

import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevChooseDialog
extends JDialog {
    private static final long serialVersionUID = -2632698898249131092L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DevChooseDialog.class);
    private static final Dimension SIZE = new Dimension(500, 400);
    private DevNode currentDevNode;
    private DefaultTableModel devTableModel = new DefaultTableModel(new String[]{ResourceUtil.getString((String)"infocollect.devicetable.head.hostname"), ResourceUtil.getString((String)"infocollect.devicetable.head.devicetype"), ResourceUtil.getString((String)"infocollect.devicetable.head.ip")}, new int[0]);
    private IsmTable devTable = new IsmTable((TableModel)this.devTableModel);
    private JButton ok = UiMethod.createButton((String)ResourceUtil.getString((String)"infocollect.collectresult.sendmail.ok"), (char)'O');
    private JButton cancel = UiMethod.createButton((String)ResourceUtil.getString((String)"infocollect.collectresult.sendmail.cancel"), (char)'C');
    private List<DevNode> selectDevNodes = new ArrayList<DevNode>();
    private TableScrollPane tableScrollPane = new TableScrollPane(this.devTable, false, false, true);

    public DevChooseDialog(JDialog parent, DevNode devicNode) {
        super((Dialog)parent, true);
        if (null == this.getGraphicsConfiguration()) {
            throw new NullPointerException("DevChooseDialog getGraphicsConfiguration null");
        }
        this.currentDevNode = devicNode;
        this.setSize(SIZE);
        this.setTitle(ResourceUtil.getString((String)"infocollect.collectresult.sendmail.applyto.title"));
        SwingUtil.putScreenCenter((Window)this);
        this.initUI();
        this.initListener();
        this.setCompName();
    }

    public void initData(List<DevNode> devNodes) {
        this.devTableModel.removeAll();
        this.devTable.removeAll();
        for (DevNode devNode : devNodes) {
            DefaultTableRow row = new DefaultTableRow(3, (Object)devNode, (Object)devNode.getDeviceSerialNumber());
            int i = 0;
            row.setValueAt(i++, (Object)devNode.getDeviceName());
            if (ApplicationContext.getInstance().isOEM()) {
                row.setValueAt(i++, (Object)(devNode.getOemModel() + " " + devNode.getProductVersion()));
            } else {
                row.setValueAt(i++, (Object)(devNode.getDeviceType() + " " + devNode.getProductVersion()));
            }
            row.setValueAt(i++, (Object)devNode.getIp());
            this.devTableModel.addRow(new TableRow[]{row});
            if (!this.selectDevNodes.contains(devNode)) continue;
            this.devTable.markTableRow(new TableRow[]{row});
        }
    }

    public List<DevNode> getSelectDevNode() {
        return this.selectDevNodes;
    }

    private void getSelectData() {
        this.selectDevNodes.clear();
        List rows = this.devTable.getMarkedRows();
        for (TableRow row : rows) {
            this.selectDevNodes.add((DevNode)row.getUserObject());
        }
    }

    private void initListener() {
        this.cancel.addActionListener(event -> this.setVisible(false));
        this.ok.addActionListener(key -> {
            this.getSelectData();
            for (DevNode node : this.selectDevNodes) {
                if (node.getIp() != null) {
                    LOGGER.info("Apply to another device >>  Device {} apply to device {}][Success", (Object)this.currentDevNode.getIp(), (Object)node.getIp());
                    continue;
                }
                LOGGER.info("Apply to another device][Failed");
            }
            this.setVisible(false);
        });
    }

    private void initUI() {
        JComponent infoComp = UiMethod.buildFrameSpace((JComponent)UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildLeftLabel((String)ResourceUtil.getString((String)"infocollect.collectresult.sendmail.applyto.info")), UiMethod.buildLeftLabel((String)ResourceUtil.getString((String)this.getApplyDescriptionKey()))}), (int)0);
        this.setLayout(new BorderLayout());
        JComponent view = UCD.buildVerticalBox(null, (Component[])new Component[]{infoComp, this.tableScrollPane, UCD.buildHBoxRight((Component[])new Component[]{this.ok, this.cancel})});
        this.add((Component)UiMethod.buildFrameSpace((JComponent)view, (int)12), "Center");
    }

    private String getApplyDescriptionKey() {
        if (InfoCollectUtil.isA800Zone(this.currentDevNode)) {
            return "infocollect.collectresult.sendmail.applyto.info2";
        }
        return "infocollect.collectresult.sendmail.applyto.info1";
    }

    private void setCompName() {
        this.devTable.setName("_IsmTable_devTable");
        this.ok.setName("_Button_ok");
        this.cancel.setName("_Button_cancel");
    }
}

