/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.ui.support.devselect;

import com.huawei.ism.tool.infocollect.config.InfoConfiguration;
import com.huawei.ism.tool.infocollect.entity.PackageConf;
import com.huawei.ism.tool.infocollect.service.InfoCollectService;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DevNodeFilter {
    public List<DevNode> filterDevNode(List<DevNode> devNodes) {
        if (devNodes == null) {
            return new ArrayList<DevNode>();
        }
        ArrayList<DevNode> result = new ArrayList<DevNode>();
        for (DevNode devNode : devNodes) {
            if (!InfoCollectUtil.isSupportDev(devNode)) continue;
            result.add(devNode);
        }
        return result;
    }

    public List<DevNode> filterNoSameTypeDev(PackageConf conf, List<DevNode> devs) {
        if (devs == null) {
            return new ArrayList<DevNode>();
        }
        ArrayList<DevNode> result = new ArrayList<DevNode>();
        for (DevNode devNode : devs) {
            PackageConf anotherConf = InfoConfiguration.getInstance().getPackageConf(devNode);
            if (conf != anotherConf) continue;
            result.add(devNode);
        }
        return result;
    }

    public List<DevNode> filterCollectingDev(List<DevNode> devNodes) {
        if (devNodes == null) {
            return new ArrayList<DevNode>();
        }
        ArrayList<DevNode> resultDevs = new ArrayList<DevNode>();
        InfoCollectService service = InfoCollectService.getInstance();
        for (DevNode devNode : devNodes) {
            if (service.isDevNodeCollecting(devNode)) continue;
            resultDevs.add(devNode);
        }
        return resultDevs;
    }

    public List<DevNode> filterA800Dev(List<DevNode> devNodes) {
        return devNodes.stream().filter(InfoCollectUtil::isA800Zone).collect(Collectors.toList());
    }
}

