/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.util;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.ComputeNodeParam;
import com.huawei.ism.tool.infocollect.service.backgroud.ComputeStorageCons;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.constant.ToolConstants;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.FceRestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.util.NetUtil;
import com.huawei.ism.util.ThreadUtil;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.MapUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeStorageFcvCollectImpl {
    private static final Logger log = LoggerFactory.getLogger(ComputeStorageFcvCollectImpl.class);
    private static final long TIMEOUT_MS = TimeUnit.HOURS.toMillis(1L);
    private static final long SLEEP_TIME = TimeUnit.SECONDS.toMillis(20L);
    private static final String QUERY_SYSTEM_INFO = "https://%s/fce/device-manager/v1/device/devices/overview";
    private static final String QUERY_EXPAND_SYSTEM_INFO = "https://%s/fce/device-manager/v1/device/devices/overview?chassisNum=%d";
    private static final String LOG_COLLECT = "https://%s/fce/operation/v1/log/logCollect";
    private static final String DOWNLOAD_LOG = "https://%s/fce/operation/v1/log/downloadLog";
    private static final String FINISHED_TAG = "finished";
    private final DevNode devNode;
    private int chassisTotal = 1;
    private List<String> collectFailedDevIps = new ArrayList<String>();

    private String getQuerySystemInfoUrl() {
        return String.format(Locale.ROOT, QUERY_SYSTEM_INFO, this.devNode.getComputeStorageDevNode().getFcvIp());
    }

    private String getQueryExpandSystemInfoUrl(int index) {
        return String.format(Locale.ROOT, QUERY_EXPAND_SYSTEM_INFO, this.devNode.getComputeStorageDevNode().getFcvIp(), index);
    }

    private String getLogCollectUrl() {
        return String.format(Locale.ROOT, LOG_COLLECT, this.devNode.getComputeStorageDevNode().getFcvIp());
    }

    private String getDownloadLogUrl() {
        return String.format(Locale.ROOT, DOWNLOAD_LOG, this.devNode.getComputeStorageDevNode().getFcvIp());
    }

    private FceRestConnection getComputeStorageConnection() throws ToolException {
        FceRestConnection restConn = RestConnectionManager.getFceRestConnection((DevNode)this.devNode);
        if (Objects.isNull(restConn) || !restConn.isLogin()) {
            log.error("rest conn is build failed.");
            throw new ToolException("rest conn is build failed.");
        }
        return restConn;
    }

    public void clearRestConnection() {
        log.info("start clear rest connection");
        RestConnectionManager.releaseFceConnection((DevNode)this.devNode);
    }

    private void checkResponseInfo(ResponseInfo responseInfo) throws ToolException {
        if (Objects.isNull(responseInfo) || !responseInfo.isSuccess()) {
            log.error("responseInfo is null or is not success.");
            throw new ToolException(ResourceUtil.getString((String)"infocollect.collect.task.response.info.null"));
        }
    }

    private void checkErrMsg(JSONObject jsonObj) throws ToolException {
        String errorCode = jsonObj.getStringOrDefault("code", "-1");
        String errorDes = jsonObj.getStringOrDefault("msg", "");
        if (!Objects.equals("0", errorCode)) {
            log.error("Query fce nodes failed, error code: {}, error description: {}", (Object)errorCode, (Object)errorDes);
            throw new ToolException("error code:" + errorCode + ", error desc:" + errorDes);
        }
    }

    public void cleanErrMsg() {
        CollectDataContext.getInstance().getDevComputeNodesInfo().get(this.devNode).values().stream().filter(param -> MapUtils.isNotEmpty(param.getErrMsg())).forEach(param -> param.getErrMsg().clear());
    }

    public void createComputeNodesInfo() throws ToolException {
        InfoCollectUtil.queryAndSaveDeviceCurDate(this.devNode);
        FceRestConnection restCon = this.getComputeStorageConnection();
        restCon.login();
        int failedDevNum = this.getFailedDevNumAndSaveNodesInfo(restCon);
        for (int i = 2; i <= this.chassisTotal; ++i) {
            ResponseInfo responseInfo = restCon.execGet(this.getQueryExpandSystemInfoUrl(i));
            JSONObject dataObj = this.checkResponseInfoAndGetDeviceInfo(responseInfo);
            failedDevNum = this.getFailedDevNum(dataObj, failedDevNum);
            this.saveComputeNodesInfo(dataObj);
        }
    }

    private int getFailedDevNumAndSaveNodesInfo(FceRestConnection restCon) throws ToolException {
        String querySystemInfoUrl = this.getQuerySystemInfoUrl();
        ResponseInfo responseInfo = restCon.execGet(querySystemInfoUrl);
        JSONObject dataObj = this.checkResponseInfoAndGetDeviceInfo(responseInfo);
        this.chassisTotal = dataObj.has("chassisTotal") ? dataObj.getInt("chassisTotal") : this.chassisTotal;
        int failedDevNum = 0;
        failedDevNum = this.getFailedDevNum(dataObj, failedDevNum);
        this.saveComputeNodesInfo(dataObj);
        return failedDevNum;
    }

    private int getFailedDevNum(JSONObject dataObj, int errorDevNum) throws ToolException {
        int chassisNum;
        if (dataObj.has("computeNodes") && !dataObj.isNull("computeNodes")) {
            return errorDevNum;
        }
        int totalErrorDevNum = errorDevNum + 1;
        int n = chassisNum = dataObj.has("chassisNum") ? dataObj.getInt("chassisNum") : 1;
        if (this.chassisTotal == chassisNum && totalErrorDevNum == this.chassisTotal) {
            log.error("The computeNodes is null.{}The number of chassisTotal is {}.{}The number of errorDevNum is {}.", new Object[]{"\n", this.chassisTotal, "\n", totalErrorDevNum});
            throw new ToolException("All computeNodes are empty.");
        }
        return totalErrorDevNum;
    }

    private JSONObject checkResponseInfoAndGetDeviceInfo(ResponseInfo responseInfo) throws ToolException {
        this.checkResponseInfo(responseInfo);
        JSONObject jsonObj = new JSONObject(responseInfo.getContent());
        this.checkErrMsg(jsonObj);
        return jsonObj.getJSONObject("data");
    }

    private void saveComputeNodesInfo(JSONObject obj) {
        Map<DevNode, Map<String, ComputeNodeParam>> devComputeNodesInfo = CollectDataContext.getInstance().getDevComputeNodesInfo();
        Map computeNodesInfo = devComputeNodesInfo.getOrDefault(this.devNode, new TreeMap(String::compareToIgnoreCase));
        JSONArray computeNodes = obj.getJSONArray("computeNodes");
        IntStream.range(0, computeNodes.length()).filter(index -> computeNodes.get(index) instanceof JSONObject).mapToObj(index -> (JSONObject)computeNodes.get(index)).forEach(computeNode -> this.createComputeNodeParam(computeNodesInfo, (JSONObject)computeNode));
        devComputeNodesInfo.put(this.devNode, computeNodesInfo);
        CollectDataContext.getInstance().setDevComputeNodesInfo(devComputeNodesInfo);
    }

    private boolean isNullParam(Map<DevNode, Map<String, ComputeNodeParam>> devComputeNodesInfo) {
        return devComputeNodesInfo.isEmpty() || MapUtils.isEmpty(devComputeNodesInfo.get(this.devNode));
    }

    private void createComputeNodeParam(Map<String, ComputeNodeParam> computeNodesInfo, JSONObject computeNode) {
        log.info("computeNode is :{}", (Object)computeNode);
        ComputeNodeParam param = new ComputeNodeParam();
        String nodeType = computeNode.getStringOrDefault("roleType", "");
        param.setNodesType(nodeType);
        param.setNodeName(computeNode.getStringOrDefault("deviceName", ""));
        param.setProduct(computeNode.getStringOrDefault("deviceModel", ""));
        param.setNodeIp(computeNode.getStringOrDefault("deviceIp", ""));
        param.setStatus(computeNode.getStringOrDefault("deviceAccessStatus", ""));
        param.setStartTime(this.devNode.getDevCurrentTime() - ComputeStorageCons.COMPUTE_NODE_MAX_TIME_SETTING);
        param.setEndTime(this.devNode.getDevCurrentTime() - 1000L);
        param.setLogInfo(this.createLogInfo(nodeType));
        computeNodesInfo.put(param.getShowName(), param);
    }

    @NotNull
    private List<String> createLogInfo(String nodeType) {
        return "CNA".equals(nodeType) ? Arrays.asList("UVP", "HARDWARE", "OS") : Arrays.asList("FCV", "UVP", "VRM", "HARDWARE", "OS");
    }

    public void packComputeNodes(int groupsIndex) throws ToolException {
        ResponseInfo responseInfo;
        FceRestConnection restCon = this.getComputeStorageConnection();
        try {
            responseInfo = restCon.execPost(this.getLogCollectUrl(), CollectDataContext.getInstance().getDevComputeNodesGroupsInfo().get(this.devNode).get(groupsIndex - 1));
        }
        catch (Exception e) {
            log.error("Failed to pack compute node information.", (Throwable)e);
            throw new ToolException(ResourceUtil.getStringWithParams((String)"infocollect.collect.task.pack.compute.node.error", (Object[])new Object[]{e.getMessage()}));
        }
        this.checkResponseInfo(responseInfo);
        this.checkErrMsg(new JSONObject(responseInfo.getContent()));
    }

    public void queryPackingProgress() throws ToolException {
        JSONObject data;
        FceRestConnection restCon = this.getComputeStorageConnection();
        long startTime = System.currentTimeMillis();
        while (true) {
            ResponseInfo responseInfo;
            if (System.currentTimeMillis() - startTime > TIMEOUT_MS) {
                throw new ToolException("Querying the computing node packing progress timed out.");
            }
            try {
                responseInfo = restCon.execGet(this.getLogCollectUrl());
            }
            catch (Exception e) {
                log.error("Failed to query the packing information.", (Throwable)e);
                throw new ToolException(ResourceUtil.getStringWithParams((String)"infocollect.collect.task.query.packing.error", (Object[])new Object[]{e.getMessage()}));
            }
            this.checkResponseInfo(responseInfo);
            JSONObject jsonObj = new JSONObject(responseInfo.getContent());
            this.checkErrMsg(jsonObj);
            data = jsonObj.getJSONObject("data");
            if (this.isPackingFinished(data)) break;
            ThreadUtil.sleep((long)SLEEP_TIME);
        }
        this.parseCommandAndSaveInfo(data);
    }

    private boolean isPackingFinished(JSONObject data) {
        JSONObject basicInfo = data.getJSONObject("basicInfo");
        return FINISHED_TAG.equals(basicInfo.getStringOrDefault("collectStatus", ""));
    }

    private void parseCommandAndSaveInfo(JSONObject data) throws ToolException {
        JSONArray nodeInfos = data.getJSONArray("nodeInfos");
        Map<DevNode, Map<String, ComputeNodeParam>> devComputeNodesInfo = CollectDataContext.getInstance().getDevComputeNodesInfo();
        Map<String, ComputeNodeParam> computeNodesInfo = devComputeNodesInfo.get(this.devNode);
        AtomicBoolean hasFile = new AtomicBoolean(false);
        IntStream.range(0, nodeInfos.length()).filter(index -> nodeInfos.get(index) instanceof JSONObject).forEach(index -> this.parseCommand((JSONObject)nodeInfos.get(index), computeNodesInfo, hasFile));
        devComputeNodesInfo.put(this.devNode, computeNodesInfo);
        CollectDataContext.getInstance().setDevComputeNodesInfo(devComputeNodesInfo);
        if (!hasFile.get()) {
            log.error("Packing failed. No file to be downloaded exists on the disk array.");
            throw new ToolException("Packing failed. No file to be downloaded exists on the disk array.");
        }
    }

    private void parseCommand(JSONObject nodeInfo, Map<String, ComputeNodeParam> computeNodesInfo, AtomicBoolean hasFile) {
        ComputeNodeParam param = computeNodesInfo.get(this.getShowName(nodeInfo));
        String file = nodeInfo.getStringOrDefault("fileName", "");
        param.setDownloadFile(file);
        if (!StringUtils.isNULLStr((String)file)) {
            hasFile.set(true);
        } else {
            this.collectFailedDevIps.add(nodeInfo.getString("nodeIp"));
        }
        this.saveErrMeg(nodeInfo, param);
    }

    private void saveErrMeg(JSONObject nodeInfo, ComputeNodeParam param) {
        if (nodeInfo.isNull("errorMes")) {
            return;
        }
        JSONArray errorMes = nodeInfo.getJSONArray("errorMes");
        if (errorMes.length() == 0) {
            log.info("All information about the compute node whose IP address is {} is collected successfully.", (Object)param.getNodeIp());
            return;
        }
        param.setErrMsg(this.getErrMsgMap(errorMes));
    }

    private Map<String, String> getErrMsgMap(JSONArray errorMes) {
        HashMap<String, String> errMsg = new HashMap<String, String>();
        IntStream.range(0, errorMes.length()).filter(index -> errorMes.get(index) instanceof JSONObject).forEach(index -> {
            JSONObject errInfo = (JSONObject)errorMes.get(index);
            errMsg.put(errInfo.getStringOrDefault("errorType", ""), errInfo.getStringOrDefault("errorCode", ""));
        });
        return errMsg;
    }

    private String getShowName(JSONObject nodeInfo) {
        return String.format(Locale.ROOT, "%s(%s)", nodeInfo.getStringOrDefault("name", ""), nodeInfo.getStringOrDefault("nodeIp", ""));
    }

    public void downloadFile(String localDir) throws ToolException {
        StringBuilder errMsg = new StringBuilder();
        CollectDataContext.getInstance().getDevComputeNodesInfo().get(this.devNode).values().stream().filter(node -> !StringUtils.isNULLStr((String)node.getDownloadFile())).forEach(node -> this.download(localDir, errMsg, (ComputeNodeParam)node));
        this.cleanDownloadFileInParam();
        if (!StringUtils.isNULLStr((String)errMsg.toString())) {
            throw new ToolException(errMsg.toString());
        }
    }

    private void download(String localDir, StringBuilder errMsg, ComputeNodeParam param) {
        try {
            this.downloadFileByPost(this.getLocalPath(localDir, param), this.getDownloadParam(param));
        }
        catch (ToolException e) {
            log.error("The download file error is ", (Throwable)e);
            errMsg.append(e.getErrorId()).append(ToolConstants.ENTER);
        }
    }

    private void cleanDownloadFileInParam() {
        CollectDataContext.getInstance().getDevComputeNodesInfo().get(this.devNode).values().forEach(param -> param.setDownloadFile(""));
    }

    private String getLocalPath(String localDir, ComputeNodeParam param) {
        return String.join((CharSequence)File.separator, localDir, this.getComputeNodesShowName(param));
    }

    private String getComputeNodesShowName(ComputeNodeParam param) {
        return NetUtil.isIPV6((String)param.getNodeIp()) ? param.getShowName().replace(":", "_") : param.getShowName();
    }

    private Map<Object, Object> getDownloadParam(ComputeNodeParam computeNodeParam) {
        HashMap<Object, Object> param = new HashMap<Object, Object>();
        param.put("fileList", Collections.singletonList(computeNodeParam.getDownloadFile()));
        param.put("nodeNameList", Collections.singletonList(computeNodeParam.getNodeName()));
        return param;
    }

    private void downloadFileByPost(String localPath, Map<Object, Object> param) throws ToolException {
        ResponseInfo responseInfo;
        FceRestConnection restCon = this.getComputeStorageConnection();
        try {
            responseInfo = restCon.execPostDownloadFile(this.getDownloadLogUrl(), param, localPath, null, null);
        }
        catch (Exception e) {
            log.error("Failed to download file through the POST interface.", (Throwable)e);
            throw new ToolException(ResourceUtil.getStringWithParams((String)"infocollect.collect.task.post.download.fail.error", (Object[])new Object[]{e.getMessage()}));
        }
        if (this.isNotNullResponse(responseInfo)) {
            this.saveDownloadErrMsg(responseInfo);
            return;
        }
        if (!this.checkFilesExist(localPath)) {
            log.error("Failed to download files from the compute node {}.", param.get("nodeNameList"));
            return;
        }
        log.info("The file of the compute node is downloaded successfully.");
    }

    private boolean isNotNullResponse(ResponseInfo responseInfo) {
        return Objects.nonNull(responseInfo) && Objects.nonNull(responseInfo.getContent()) && !responseInfo.getContent().isEmpty();
    }

    private boolean checkFilesExist(String localPath) {
        File file = new File(localPath);
        if (!file.exists()) {
            log.error("The folder({}) does not exist. ", (Object)file.getName());
            return false;
        }
        return Objects.requireNonNull(file.list()).length > 0;
    }

    private void saveDownloadErrMsg(ResponseInfo responseInfo) throws ToolException {
        JSONObject jsonObj = new JSONObject(responseInfo.getContent());
        String errorCode = jsonObj.getStringOrDefault("code", "");
        String errorDes = jsonObj.getStringOrDefault("msg", "");
        if (!StringUtils.isNULLStr((String)errorCode) && !Objects.equals("0", errorCode)) {
            log.error("down load failed, error code: {}, error description: {}", (Object)errorCode, (Object)errorDes);
            throw new ToolException("error code:" + errorCode + ", error desc:" + errorDes);
        }
    }

    public String getErrorMsg() {
        if (this.collectFailedDevIps.isEmpty() && !this.hasErrMsg()) {
            log.info("All compute node information is collected successfully.");
            return "";
        }
        StringBuilder errMsg = new StringBuilder();
        if (!this.collectFailedDevIps.isEmpty()) {
            String errDevIps = String.join((CharSequence)",", this.collectFailedDevIps);
            log.warn("Failed to pack the file of compute nodes ({}).", (Object)errDevIps);
            errMsg.append(ResourceUtil.getStringWithParams((String)"infocollect.collect.task.fail.node", (Object[])new Object[]{errDevIps}));
        }
        if (this.hasErrMsg()) {
            Map<String, ComputeNodeParam> computeNodesParam = CollectDataContext.getInstance().getDevComputeNodesInfo().get(this.devNode);
            List partiallySuccessDevIps = computeNodesParam.values().stream().filter(nodeInfo -> MapUtils.isNotEmpty(nodeInfo.getErrMsg())).map(ComputeNodeParam::getNodeIp).collect(Collectors.toList());
            log.warn("Compute node ({}) information collection partially succeeded.", (Object)String.join((CharSequence)",", partiallySuccessDevIps));
            computeNodesParam.values().stream().filter(nodeInfo -> nodeInfo.getErrMsg() != null && !nodeInfo.getErrMsg().isEmpty()).forEach(param -> errMsg.append(this.getPartiallySucItemErrMsg((ComputeNodeParam)param)));
        }
        return errMsg.toString();
    }

    private boolean hasErrMsg() {
        return CollectDataContext.getInstance().getDevComputeNodesInfo().get(this.devNode).values().stream().anyMatch(nodeInfo -> MapUtils.isNotEmpty(nodeInfo.getErrMsg()));
    }

    private String getPartiallySucItemErrMsg(ComputeNodeParam computeNodeParam) {
        StringBuilder errCode = new StringBuilder();
        computeNodeParam.getErrMsg().values().forEach(value -> errCode.append((String)value).append(" "));
        StringBuilder failItem = new StringBuilder();
        computeNodeParam.getErrMsg().keySet().forEach(key -> failItem.append((String)key).append(" "));
        return ResourceUtil.getStringWithParams((String)"infocollect.collect.task.part.success", (Object[])new Object[]{computeNodeParam.getShowName(), failItem.toString(), errCode.toString()});
    }

    public ComputeStorageFcvCollectImpl(DevNode devNode) {
        this.devNode = devNode;
    }
}

