/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.util;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.ComputeNodeParam;
import com.huawei.ism.tool.infocollect.service.backgroud.ComputeStorageCons;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.constant.ToolConstants;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.FceRestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeStorageUtil {
    private static final Logger log = LoggerFactory.getLogger(ComputeStorageUtil.class);
    private static final long TIMEOUT_MS = TimeUnit.HOURS.toMillis(1L);
    private static final String HTTPS_PREFIX = "https://";
    private static final String LOG_COLLECT = "/fce/operation/v1/log/logCollect";
    private static final String DOWNLOAD_LOG = "/fce/operation/v1/log/downloadLog";
    private static final String COLLECT_USER = "openapi";
    private static final String SCENE = "FusionsphereIaaS";
    private static final long SLEEP_TIME = TimeUnit.SECONDS.toMillis(10L);
    private DevNode devNode;

    public ComputeStorageUtil(DevNode devNode) {
        this.devNode = devNode;
    }

    private String getLogCollectUrl() {
        return HTTPS_PREFIX + this.devNode.getComputeStorageDevNode().getFcvIp() + LOG_COLLECT;
    }

    private String getDownloadLogUrl() {
        return HTTPS_PREFIX + this.devNode.getComputeStorageDevNode().getFcvIp() + DOWNLOAD_LOG;
    }

    private FceRestConnection getComputeStorageConnection() throws ToolException {
        DevNode computeNode = EntityUtils.convertToComputeStorageDevNode((DevNode)this.devNode);
        FceRestConnection restConn = RestConnectionManager.getFceRestConnection((DevNode)computeNode);
        if (restConn == null || !restConn.isLogin()) {
            log.error("rest conn is build failed.");
            throw new ToolException("rest conn is build failed.");
        }
        return restConn;
    }

    public String downloadFile(String localDir) {
        Map<String, ComputeNodeParam> computeNodesInfo = CollectDataContext.getInstance().getDevComputeNodesInfo().get(this.devNode);
        StringBuilder errMsg = new StringBuilder();
        computeNodesInfo.values().stream().filter(node -> !StringUtils.isNULLStr((String)node.getDownloadFile())).forEach(node -> this.download(localDir, errMsg, (ComputeNodeParam)node));
        return errMsg.toString();
    }

    private void download(String localDir, StringBuilder errMsg, ComputeNodeParam node) {
        try {
            this.downloadFileByPost(this.getLocalPath(localDir, node), this.getDownloadParam(node));
        }
        catch (ToolException e) {
            log.error("The download file error is ", (Throwable)e);
            errMsg.append(e.getErrorId()).append(ToolConstants.ENTER);
        }
    }

    @NotNull
    private String getLocalPath(String localDir, ComputeNodeParam node) {
        return localDir + File.separator + node.getName();
    }

    @NotNull
    private Map<Object, Object> getDownloadParam(ComputeNodeParam node) {
        HashMap<Object, Object> param = new HashMap<Object, Object>();
        param.put("fileList", Collections.singletonList(node.getDownloadFile()));
        param.put("nodeNameList", Collections.singletonList(node.getNodeName()));
        return param;
    }

    private void downloadFileByPost(String localPath, Map<Object, Object> param) throws ToolException {
        ResponseInfo responseInfo;
        FceRestConnection restCon = this.getComputeStorageConnection();
        try {
            responseInfo = restCon.execPostDownloadFile(this.getDownloadLogUrl(), param, localPath, null, null);
        }
        catch (Exception e) {
            log.error("Failed to download file through the POST interface.", (Throwable)e);
            throw new ToolException(ResourceUtil.getStringWithParams((String)"infocollect.collect.task.post.download.fail.error", (Object[])new Object[]{e.getMessage()}));
        }
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj = new JSONObject(responseInfo.getContent());
        }
        catch (JSONException e) {
            log.error("", (Throwable)e);
        }
        String errorCode = jsonObj.getStringOrDefault("code", "");
        String errorDes = jsonObj.getStringOrDefault("msg", "");
        if (!StringUtils.isNULLStr((String)errorCode)) {
            log.error("down load failed, error code: {}, error description: {}", (Object)errorCode, (Object)errorDes);
            throw new ToolException("error code:" + errorCode + ", error desc:" + errorDes);
        }
    }

    public boolean queryPackingProgress() throws ToolException {
        JSONObject obj;
        FceRestConnection restCon = this.getComputeStorageConnection();
        long startTime = System.currentTimeMillis();
        while (true) {
            ResponseInfo responseInfo;
            if (System.currentTimeMillis() - startTime > TIMEOUT_MS) {
                throw new ToolException("query packing progress timeout");
            }
            try {
                responseInfo = restCon.execGet(this.getLogCollectUrl());
            }
            catch (Exception e) {
                log.error("Failed to query the packing information.", (Throwable)e);
                throw new ToolException(ResourceUtil.getStringWithParams((String)"infocollect.collect.task.query.packing.error", (Object[])new Object[]{e.getMessage()}));
            }
            this.checkResponseInfo(responseInfo);
            JSONObject jsonObj = new JSONObject(responseInfo.getContent());
            this.checkErrMsg(jsonObj);
            obj = jsonObj.getJSONObject("data");
            JSONObject basicInfo = obj.getJSONObject("basicInfo");
            if (basicInfo.getStringOrDefault("collectStatus", "").equals("finished")) break;
            try {
                Thread.sleep(SLEEP_TIME);
            }
            catch (InterruptedException e) {
                log.error("sleep error:", (Throwable)e);
            }
        }
        return this.parseNodesInfo(obj);
    }

    private boolean parseNodesInfo(JSONObject obj) {
        JSONArray nodeInfos = obj.getJSONArray("nodeInfos");
        Map<DevNode, Map<String, ComputeNodeParam>> devComputeNodesInfo = CollectDataContext.getInstance().getDevComputeNodesInfo();
        Map<String, ComputeNodeParam> computeNodesInfo = devComputeNodesInfo.get(this.devNode);
        AtomicBoolean hasFile = new AtomicBoolean(false);
        IntStream.range(0, nodeInfos.length()).filter(index -> nodeInfos.get(index) instanceof JSONObject).forEach(index -> {
            JSONObject nodeInfo = (JSONObject)nodeInfos.get(index);
            ComputeNodeParam param = (ComputeNodeParam)computeNodesInfo.get(nodeInfo.getStringOrDefault("name", ""));
            String file = nodeInfo.getStringOrDefault("fileName", "");
            param.setDownloadFile(file);
            if (!StringUtils.isNULLStr((String)file)) {
                hasFile.set(true);
            }
            this.getErroeMes(nodeInfo, param);
        });
        devComputeNodesInfo.put(this.devNode, computeNodesInfo);
        CollectDataContext.getInstance().setDevComputeNodesInfo(devComputeNodesInfo);
        return hasFile.get();
    }

    private void getErroeMes(JSONObject nodeInfo, ComputeNodeParam param) {
        JSONArray errorMes = nodeInfo.getJSONArray("errorMes");
        if (errorMes.length() < 1) {
            log.info("errorMes is empty.");
            return;
        }
        HashMap<String, String> errMsg = new HashMap<String, String>();
        IntStream.range(0, errorMes.length()).filter(index -> errorMes.get(index) instanceof JSONObject).forEach(index -> {
            JSONObject errInfo = (JSONObject)errorMes.get(index);
            errMsg.put(errInfo.getStringOrDefault("errorType", ""), errInfo.getStringOrDefault("errorCode", ""));
        });
        param.setErrMsg(errMsg);
    }

    public boolean sendPackingCommand() throws ToolException {
        ResponseInfo responseInfo;
        FceRestConnection restCon = this.getComputeStorageConnection();
        String param = this.getPackingParam();
        try {
            responseInfo = restCon.execPost(this.getLogCollectUrl(), param);
        }
        catch (Exception e) {
            log.error("Failed to pack compute node information.", (Throwable)e);
            throw new ToolException(ResourceUtil.getStringWithParams((String)"infocollect.collect.task.pack.compute.node.error", (Object[])new Object[]{e.getMessage()}));
        }
        this.checkResponseInfo(responseInfo);
        JSONObject jsonObj = new JSONObject(responseInfo.getContent());
        this.checkErrMsg(jsonObj);
        return true;
    }

    private void checkResponseInfo(ResponseInfo responseInfo) throws ToolException {
        if (responseInfo == null) {
            log.error("responseInfo is empty.");
            throw new ToolException(ResourceUtil.getString((String)"infocollect.collect.task.response.info.null"));
        }
    }

    private String getPackingParam() throws ToolException {
        Map<String, ComputeNodeParam> computeNodesInfo = CollectDataContext.getInstance().getDevComputeNodesInfo().get(this.devNode);
        if (computeNodesInfo.isEmpty()) {
            log.error("ComputeNodesInfo is empty.");
            throw new ToolException("ComputeNodesInfo is empty.");
        }
        ArrayList nodeList = new ArrayList();
        Long startTime = null;
        Long endTime = null;
        for (ComputeNodeParam computeNodeParam : computeNodesInfo.values()) {
            HashMap<String, Object> nodeInfo = new HashMap<String, Object>();
            nodeInfo.put("logInfo", computeNodeParam.getLogInfo());
            nodeInfo.put("mgntIp", computeNodeParam.getNodeIp());
            nodeInfo.put("nodeIp", computeNodeParam.getNodeIp());
            nodeInfo.put("name", computeNodeParam.getNodeName());
            nodeInfo.put("nodesType", computeNodeParam.getNodesType());
            nodeInfo.put("product", computeNodeParam.getProduct());
            nodeInfo.put("status", computeNodeParam.getStatus());
            startTime = computeNodeParam.getStartTime();
            endTime = computeNodeParam.getEndTime();
            nodeList.add(nodeInfo);
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("nodeList", nodeList);
        param.put("startTime", InfoCollectUtil.formatTimeMillisToStringData(startTime));
        param.put("endTime", InfoCollectUtil.formatTimeMillisToStringData(endTime));
        param.put("scene", SCENE);
        param.put("collectUser", COLLECT_USER);
        return new JSONObject(param).toString();
    }

    public void getComputeNodesInfo() throws ToolException {
        FceRestConnection restCon = this.getComputeStorageConnection();
        restCon.login();
        ResponseInfo responseInfo = restCon.execGet(restCon.getQuerySystemInfoUrl());
        this.checkResponseInfo(responseInfo);
        JSONObject jsonObj = new JSONObject(responseInfo.getContent());
        this.checkErrMsg(jsonObj);
        JSONObject obj = jsonObj.getJSONObject("data");
        if (!obj.has("computeNodes")) {
            return;
        }
        this.saveComputeNodesInfo(obj);
    }

    private void checkErrMsg(JSONObject jsonObj) throws ToolException {
        String errorCode = jsonObj.getStringOrDefault("code", "-1");
        String errorDes = jsonObj.getStringOrDefault("msg", "");
        if (!"0".equals(errorCode)) {
            log.error("Query fce nodes failed, error code:" + errorCode + ", error description:" + errorDes);
            throw new ToolException("error code:" + errorCode + ", error desc:" + errorDes);
        }
    }

    private void saveComputeNodesInfo(JSONObject obj) {
        HashMap computeNodesInfo = new HashMap();
        JSONArray computeNodes = obj.getJSONArray("computeNodes");
        IntStream.range(0, computeNodes.length()).filter(index -> computeNodes.get(index) instanceof JSONObject).forEach(index -> {
            JSONObject computeNode = (JSONObject)computeNodes.get(index);
            log.info("computeNode is :{}", (Object)computeNode);
            ComputeNodeParam param = new ComputeNodeParam();
            String nodeType = computeNode.getStringOrDefault("roleType", "");
            String nodeName = computeNode.getStringOrDefault("deviceName", "");
            if (!StringUtils.isNULLStr((String)nodeType) && ComputeStorageCons.COMPUTE_STORAGE_NODE_TYPE.contains(nodeType)) {
                param.setNodesType(nodeType);
                param.setNodeName(nodeName);
                param.setProduct(computeNode.getStringOrDefault("deviceModel", ""));
                param.setNodeIp(computeNode.getStringOrDefault("deviceIp", ""));
                param.setStatus(computeNode.getStringOrDefault("deviceAccessStatus", ""));
                param.setStartTime(this.devNode.getDevCurrentTime() - ComputeStorageCons.COMPUTE_NODE_MAX_TIME_SETTING);
                param.setEndTime(this.devNode.getDevCurrentTime() - 1000L);
                List<String> logInfo = Arrays.asList("FCV", "UVP", "VRM", "HARDWARE", "OS");
                if (nodeType.equals("CNA")) {
                    logInfo = Arrays.asList("UVP", "HARDWARE", "OS");
                }
                param.setLogInfo(logInfo);
            }
            computeNodesInfo.put(param.getShowName(), param);
        });
        Map<DevNode, Map<String, ComputeNodeParam>> devComputeNodesInfo = CollectDataContext.getInstance().getDevComputeNodesInfo();
        devComputeNodesInfo.put(this.devNode, computeNodesInfo);
        CollectDataContext.getInstance().setDevComputeNodesInfo(devComputeNodesInfo);
    }
}

