/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.util;

import com.huawei.ism.tool.infocollect.config.CollectConfigParser;
import com.huawei.ism.tool.infocollect.entity.CollectConf;
import com.huawei.ism.tool.infocollect.entity.CollectItem;
import com.huawei.ism.tool.infocollect.entity.CollectModule;
import com.huawei.ism.tool.infocollect.entity.ExtendeItemConfig;
import com.huawei.ism.tool.infocollect.entity.ModeType;
import com.huawei.ism.tool.infocollect.entity.RestQueryItem;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DStoragePackageUtil {
    private static final Logger log = LoggerFactory.getLogger(DStoragePackageUtil.class);
    private static final String NAME_KEY = "namekey";
    private static final String SELECT = "select";
    private static final String MODE = "mode";
    private static final String ITEM_ID = "id";
    private static final String BONDING_KEY = "bondingKey";
    private static final String DEFAULT_CHOOSE = "default";
    private static final String MICRO_SERVICE_ID = "microservice";
    private static final String REQUESTS = "requests";
    private static final String REQUEST = "request";
    private static final String URL = "url";
    private static final String NOT_SUPPORT_REDUCE_COLLECT_VERSION = "8.0.1";
    private static List<ExtendeItemConfig> extendItemConfigList;
    private static ResourceBundle resourceBundle;
    private static Map<String, Map<String, CollectModule>> itemConfigCache;
    private static final String D_STORAGE_PACKAGE_PATH;
    private static final String EXTENDE_DEVICE_XML_PATH;
    private static final String RES_PATH;
    private static final String RES_NAME = "resource";
    private static final String SIMPLE_COLLECT_EXTEND_ITEM_XML = "simple_collect_item.xml";
    private static final String[] VERSIONS_HAVE_TO_COLLECT_BY_INSPECT;

    public static void loadingExtendedConf(CollectConf collectConf, DevNode devNode) {
        if (!devNode.isDsStorage()) {
            return;
        }
        DStoragePackageUtil.mergeAndAddConf(collectConf, DStoragePackageUtil.getExtendCollectModuleMap(devNode));
    }

    private static void mergeAndAddConf(CollectConf collectConf, LinkedHashMap<String, CollectModule> extendCollectModuleMap) {
        if (extendCollectModuleMap.isEmpty()) {
            return;
        }
        collectConf.getModules().forEach(collectModule -> {
            String moduleId = collectModule.getModuleId();
            if (extendCollectModuleMap.containsKey(moduleId)) {
                CollectModule extendModule = (CollectModule)extendCollectModuleMap.get(moduleId);
                collectModule.setSimpleModule(extendModule);
                DStoragePackageUtil.mergeCollectModule(collectModule, extendModule);
                extendCollectModuleMap.remove(moduleId);
            }
        });
        collectConf.getModules().addAll(extendCollectModuleMap.values());
    }

    private static LinkedHashMap<String, CollectModule> getExtendCollectModuleMap(DevNode devNode) {
        DStoragePackageUtil.intDStoragePackage();
        HashSet itemXmls = new HashSet();
        extendItemConfigList.stream().filter(extendItemConfig -> extendItemConfig.isSupport(devNode)).forEach(extendItemConfig -> itemXmls.addAll(extendItemConfig.getItemXmlList()));
        LinkedHashMap<String, CollectModule> itemInfo = new LinkedHashMap<String, CollectModule>();
        itemXmls.stream().forEach(itemXmlName -> DStoragePackageUtil.loadingCollectModule(itemXmlName, itemInfo));
        return itemInfo;
    }

    private static void loadingCollectModule(String itemXmlName, LinkedHashMap<String, CollectModule> itemInfo) {
        Map<String, CollectModule> itemInfoInOneFile = DStoragePackageUtil.parserItemXml(itemXmlName);
        itemConfigCache.put(itemXmlName, itemInfoInOneFile);
        DStoragePackageUtil.mergeItemInfo(itemInfo, itemInfoInOneFile);
    }

    private static Map<String, CollectModule> parserItemXml(String itemXmlName) {
        LinkedHashMap<String, CollectModule> itemInfo = new LinkedHashMap<String, CollectModule>();
        File itemXmlFile = new File(D_STORAGE_PACKAGE_PATH + File.separator + itemXmlName);
        Document deviceDoc = DStoragePackageUtil.getParserXmlDocument(itemXmlFile);
        if (deviceDoc == null) {
            return itemInfo;
        }
        NodeList nodeList = XmlUtils.searchNodeByExp((Document)deviceDoc, (String)"device/module");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element moduleNode = (Element)node;
            CollectModule module = new CollectModule();
            String id = XmlUtils.getLocaleAttribute((Element)moduleNode, (String)NAME_KEY);
            String mode = moduleNode.getAttribute(MODE);
            module.setIndexInSimple(i);
            module.setModuleSelectInSimple("true".equals(XmlUtils.getLocaleAttribute((Element)moduleNode, (String)SELECT)));
            module.setNameKey(resourceBundle.containsKey(id) ? resourceBundle.getString(id) : "--");
            module.setModuleId(id);
            module.setMode(mode);
            module.setBondingKey(DStoragePackageUtil.getBondingKey(moduleNode.getAttribute(BONDING_KEY)));
            module.setItems(DStoragePackageUtil.getCollectItems(moduleNode));
            itemInfo.put(id, module);
        }
        return itemInfo;
    }

    private static List<String> getBondingKey(String bondingKey) {
        if (StringUtils.isNULLStr((String)bondingKey)) {
            return Collections.emptyList();
        }
        return Arrays.asList(bondingKey.split(","));
    }

    private static List<CollectItem> getCollectItems(Element moduleElement) {
        String nameKey = moduleElement.getAttribute(NAME_KEY);
        NodeList nodeList = moduleElement.getChildNodes();
        ArrayList<CollectItem> result = new ArrayList<CollectItem>();
        int length = nodeList.getLength();
        for (int index = 0; index < length; ++index) {
            Node itemNode = nodeList.item(index);
            if (!(itemNode instanceof Element)) continue;
            result.add(DStoragePackageUtil.parseCollectItem((Element)itemNode, nameKey));
        }
        return result;
    }

    private static CollectItem parseCollectItem(Element itemElement, String moduleNameKey) {
        CollectItem item = new CollectItem();
        item.setModuleId(moduleNameKey);
        item.setId(itemElement.getAttribute(ITEM_ID));
        String nameKey = itemElement.getAttribute(NAME_KEY);
        item.setEnNameKey(nameKey);
        item.setNameKey(resourceBundle.getString(nameKey));
        String defaultString = itemElement.getAttribute(DEFAULT_CHOOSE);
        boolean defaultChoosen = true;
        if (!StringUtils.isNULLStr((String)defaultString)) {
            defaultChoosen = Boolean.parseBoolean(defaultString);
        }
        item.setDefaultChoose(defaultChoosen);
        item.setMicroServiceId(itemElement.getAttribute(MICRO_SERVICE_ID));
        DStoragePackageUtil.initRestQueryItems(item, itemElement);
        item.setMode(ModeType.of(itemElement.getAttribute(MODE)));
        return item;
    }

    private static void initRestQueryItems(CollectItem item, Element itemElement) {
        Collection restQueryItems = XmlUtils.getChildren((Element)XmlUtils.getChild((Element)itemElement, (String)REQUESTS), (String)REQUEST);
        restQueryItems.forEach(itemNode -> item.getRestQueryItems().add(new RestQueryItem(itemNode.getAttribute(URL))));
    }

    private static void mergeItemInfo(LinkedHashMap<String, CollectModule> itemInfo, Map<String, CollectModule> cache) {
        cache.keySet().stream().forEach(cacheItemGroupName -> {
            if (itemInfo.containsKey(cacheItemGroupName)) {
                DStoragePackageUtil.mergeCollectModule((CollectModule)itemInfo.get(cacheItemGroupName), (CollectModule)cache.get(cacheItemGroupName));
            } else {
                itemInfo.put((String)cacheItemGroupName, (CollectModule)cache.get(cacheItemGroupName));
            }
        });
    }

    private static void mergeCollectModule(CollectModule oldModule, CollectModule newModule) {
        List<CollectItem> oldItems = oldModule.getItems();
        Set itemIdSet = oldItems.stream().map(item -> item.getId()).collect(Collectors.toSet());
        newModule.getItems().forEach(newItem -> {
            if (!itemIdSet.contains(newItem.getId())) {
                oldItems.add((CollectItem)newItem);
            }
        });
        if (!CollectionUtil.isEmpty(newModule.getBondingKey())) {
            oldModule.setBondingKey(newModule.getBondingKey());
        }
    }

    private static synchronized void intDStoragePackage() {
        if (extendItemConfigList != null) {
            return;
        }
        extendItemConfigList = new ArrayList<ExtendeItemConfig>();
        DStoragePackageUtil.initExtendeDeviceXml();
        DStoragePackageUtil.initResourceBundle();
    }

    private static void initExtendeDeviceXml() {
        File extendDevice = new File(EXTENDE_DEVICE_XML_PATH);
        Document deviceDoc = DStoragePackageUtil.getParserXmlDocument(extendDevice);
        if (deviceDoc == null) {
            return;
        }
        NodeList nodeList = XmlUtils.searchNodeByExp((Document)deviceDoc, (String)"products/product");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element product = (Element)node;
            String confDeviceType = XmlUtils.getTextContentOfChild((Element)product, (String)"supportDeviceType");
            String confProductVersion = XmlUtils.getTextContentOfChild((Element)product, (String)"supportVersion");
            ExtendeItemConfig extendItemConfig = new ExtendeItemConfig(confDeviceType, confProductVersion);
            Collection itemNodeList = XmlUtils.getChildren((Element)XmlUtils.getChild((Element)product, (String)"itemList"), (String)"itemXmlName");
            itemNodeList.forEach(itemNode -> extendItemConfig.addItemXml(itemNode.getTextContent()));
            extendItemConfigList.add(extendItemConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document getParserXmlDocument(File extendDevice) {
        Document deviceDoc = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(extendDevice);
            deviceDoc = XmlUtils.parseDocument((InputStream)inputStream);
        }
        catch (FileNotFoundException e) {
            log.error("Init Xml error. extendDevice file:{} not found.", (Object)extendDevice.getName());
        }
        catch (RuntimeException e) {
            log.error("Init Xml error.", (Throwable)e);
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)inputStream);
        }
        return deviceDoc;
    }

    private static void initResourceBundle() {
        String currentLanguage = ApplicationContext.getInstance().getCurrentLanguage().getLanguage();
        File propertiesFile = new File(RES_PATH, "resource_" + currentLanguage + ".properties");
        try (FileInputStream fileInputStream = new FileInputStream(propertiesFile);
             BufferedInputStream input = new BufferedInputStream(fileInputStream);){
            resourceBundle = new PropertyResourceBundle(input);
        }
        catch (Exception e) {
            log.error("Fail to bundle language file.");
        }
    }

    public static boolean isSupportReduceCollect(DevNode deviceNode) {
        return Context.INS.hasMatchPatch(deviceNode, DstoragePatchInfo.Type.COLLECT) && !NOT_SUPPORT_REDUCE_COLLECT_VERSION.equals(deviceNode.getProductVersionToShow());
    }

    public static boolean isSupportInspectCollect(DevNode deviceNode) {
        return Context.INS.hasMatchPatch(deviceNode, DstoragePatchInfo.Type.INSPECT);
    }

    public static boolean isHaveToCollectSmartByInspect(DevNode devNode) {
        if (devNode.isFusionCube()) {
            return false;
        }
        return Arrays.stream(VERSIONS_HAVE_TO_COLLECT_BY_INSPECT).anyMatch(devNode.getProductVersion()::contains);
    }

    static {
        itemConfigCache = new ConcurrentHashMap<String, Map<String, CollectModule>>();
        D_STORAGE_PACKAGE_PATH = ApplicationContext.getInstance().getWorkPath() + File.separator + "packages" + File.separator + "collect" + File.separator + "products" + File.separator + "DStorageExtend";
        EXTENDE_DEVICE_XML_PATH = D_STORAGE_PACKAGE_PATH + File.separator + "ExtendDevice.xml";
        RES_PATH = D_STORAGE_PACKAGE_PATH + File.separator + "res";
        VERSIONS_HAVE_TO_COLLECT_BY_INSPECT = CollectConfigParser.getConfigureValue("haveToCollectByInspect", "").trim().split(",");
    }
}

