/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.util;

import com.huawei.ism.tool.base.utils.IniReader;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.ui.support.UpdateCollectItemHandle;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import com.huawei.ism.tool.service.patch.dstorage.service.PatchImportImp;
import com.huawei.ism.tool.service.patch.service.IHandler;
import java.io.File;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DStoragePatchUtil {
    private static final Logger log = LoggerFactory.getLogger(DStoragePatchUtil.class);
    private static final String PRODUCT_PATH = DStoragePatchUtil.getProductsPath();
    private static final String PACKAGE_VERIFY_KEY = "package.sign.verify";
    private static final String PACKAGE_PATCH_NODE_IDS = "package.patch.node_ids";
    private static final String D_STORAGE_PACKAGE_PATH = PRODUCT_PATH + File.separator + "DStorageExtend";

    private static String getProductsPath() {
        return String.join((CharSequence)File.separator, ApplicationContext.getInstance().getWorkPath(), "packages", "collect", "products");
    }

    public static void initPatchConfig() {
        Context.INS.initPatchConfig(D_STORAGE_PACKAGE_PATH);
    }

    public static boolean hasInstallPatchAlready(DevNode devNode) {
        DstoragePatchInfo patchInfo = Context.INS.getAutoImportPatch(devNode, DstoragePatchInfo.Type.COLLECT);
        if (patchInfo == null) {
            return false;
        }
        return patchInfo.queryInstalledStatus(devNode) == DstoragePatchInfo.InstallStatus.INSTALLED;
    }

    public static boolean autoImportCollectPatch(DevNode devNode) {
        Context.INS.getSupportUploadByNodeIdDevMap().put(devNode, DStoragePatchUtil.getBooleanValueFromIniConf(new File(DStoragePatchUtil.getPackageFilePath(devNode)), PACKAGE_PATCH_NODE_IDS));
        return DStoragePatchUtil.getMatchPatch(devNode).map(patchInfo -> DStoragePatchUtil.importPatch(devNode, patchInfo)).map(TaskResult::isTaskSuccess).orElse(true);
    }

    private static Optional<DstoragePatchInfo> getMatchPatch(DevNode devNode) {
        return Optional.ofNullable(Context.INS.findBestMatchPatch(devNode, DstoragePatchInfo.Type.COLLECT));
    }

    private static TaskResult importPatch(DevNode devNode, DstoragePatchInfo patchInfo) {
        DStoragePatchUtil.importPrepare(devNode, patchInfo);
        TaskResult result = new PatchImportImp(devNode, patchInfo, (IHandler)new UpdateCollectItemHandle(devNode)).importPatch();
        DStoragePatchUtil.importPost(devNode, result, patchInfo);
        return result;
    }

    private static void importPrepare(DevNode devNode, DstoragePatchInfo patchInfo) {
        Context.INS.registerPatch(devNode, patchInfo);
        patchInfo.setNeedCmsSign(DStoragePatchUtil.parseIsNeedCmsSign(devNode));
    }

    public static void prepareBeforeUpload(DevNode devNode) {
        Context.INS.getSupportUploadByNodeIdDevMap().put(devNode, DStoragePatchUtil.parseSupportPackageByIds(devNode));
        DStoragePatchUtil.getMatchInspectPatch(devNode).ifPresent(patchInfo -> DStoragePatchUtil.importPrepare(devNode, patchInfo));
    }

    private static Optional<DstoragePatchInfo> getMatchInspectPatch(DevNode devNode) {
        return Optional.ofNullable(Context.INS.findBestMatchPatch(devNode, DstoragePatchInfo.Type.INSPECT));
    }

    private static boolean parseSupportPackageByIds(DevNode devNode) {
        return DStoragePatchUtil.getBooleanValueFromIniConf(new File(DStoragePatchUtil.getPackageFilePathForInspect(devNode)), PACKAGE_PATCH_NODE_IDS);
    }

    private static void importPost(DevNode devNode, TaskResult taskResult, DstoragePatchInfo patchInfo) {
        if (!taskResult.isTaskSuccess()) {
            log.error("import patch failed: {}", (Object)taskResult.getErrorLocaleDescription());
            devNode.setErrorDecs(taskResult.getErrorLocaleDescription());
            return;
        }
        patchInfo.updateDevInstalledStatus(devNode, DstoragePatchInfo.InstallStatus.INSTALLED);
        CollectDataContext.getInstance().getHasImportPatchDevs().add(devNode);
    }

    private static String getPackageFilePath(DevNode devNode) {
        return PRODUCT_PATH + File.separator + "Dstorage_" + devNode.getDeviceSerialNumber() + File.separator + "package.ini";
    }

    private static String getPackageFilePathForInspect(DevNode devNode) {
        return PRODUCT_PATH + File.separator + "Dstorage_" + devNode.getDeviceSerialNumber() + File.separator + "inspectResource" + File.separator + "package.ini";
    }

    private static boolean parseIsNeedCmsSign(DevNode devNode) {
        return DStoragePatchUtil.getBooleanValueFromIniConf(new File(DStoragePatchUtil.getPackageFilePath(devNode)), PACKAGE_VERIFY_KEY);
    }

    private static boolean getBooleanValueFromIniConf(File packageFile, String key) {
        if (!packageFile.exists()) {
            return false;
        }
        IniReader iniReader = new IniReader(packageFile);
        return iniReader.getBoolean(key);
    }

    private DStoragePatchUtil() {
    }
}

