/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.util;

import com.huawei.ism.tool.infocollect.entity.PerfCollectTask;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.List;

public class DStoragePerfTaskSplitUtil {
    private static final long MINUTES_12 = 720L;
    private static final long MINUTES_115 = 6900L;
    private static final long HOURS_28_8 = 103680L;
    private static final long DAY_9 = 777600L;
    private static final long ONE_HOUR = 3600L;
    private static final long ONE_DAY = 86400L;
    private static final long ONE_WEEK = 604800L;
    private static final Long GET_NODE_UTC_TIME_ERROR = 0L;

    public static List<PerfCollectTask> getPerfCollectTaskList(Long taskStartTime, Long taskEndTime, DevNode devNode) {
        ArrayList<PerfCollectTask> perfCollectTaskList = new ArrayList<PerfCollectTask>();
        Long devNodeUtcTime = DStoragePerfTaskSplitUtil.getDevNodeUtcTime(devNode);
        if (devNodeUtcTime == GET_NODE_UTC_TIME_ERROR) {
            perfCollectTaskList.add(new PerfCollectTask(taskStartTime, taskEndTime));
            return perfCollectTaskList;
        }
        Long actualTaskEndTime = Math.min(taskEndTime, devNodeUtcTime);
        Long actualTaskStartTime = Math.min(taskStartTime, devNodeUtcTime);
        DStoragePerfTaskSplitUtil.addOriginalTableTask(actualTaskStartTime, actualTaskEndTime, devNodeUtcTime, perfCollectTaskList);
        DStoragePerfTaskSplitUtil.addDayTableTask(actualTaskStartTime, actualTaskEndTime, devNodeUtcTime, perfCollectTaskList);
        DStoragePerfTaskSplitUtil.addWeekTableTask(actualTaskStartTime, actualTaskEndTime, devNodeUtcTime, perfCollectTaskList);
        DStoragePerfTaskSplitUtil.addQuarterlyTableTask(actualTaskStartTime, actualTaskEndTime, devNodeUtcTime, perfCollectTaskList);
        return perfCollectTaskList;
    }

    private static void addOriginalTableTask(Long taskStartTime, Long taskEndTime, Long devNodeUtcTime, List<PerfCollectTask> perfCollectTaskList) {
        Long intervalStart = devNodeUtcTime - 3600L;
        Long intervalEnd = devNodeUtcTime;
        Long taskTime = 720L;
        DStoragePerfTaskSplitUtil.decompose(taskStartTime, taskEndTime, intervalStart, intervalEnd, taskTime, perfCollectTaskList);
    }

    private static void addDayTableTask(Long taskStartTime, Long taskEndTime, Long devNodeUtcTime, List<PerfCollectTask> perfCollectTaskList) {
        Long intervalStart = devNodeUtcTime - 86400L;
        Long intervalEnd = devNodeUtcTime - 3600L;
        Long taskTime = 6900L;
        DStoragePerfTaskSplitUtil.decompose(taskStartTime, taskEndTime, intervalStart, intervalEnd, taskTime, perfCollectTaskList);
    }

    private static void addWeekTableTask(Long taskStartTime, Long taskEndTime, Long devNodeUtcTime, List<PerfCollectTask> perfCollectTaskList) {
        Long intervalStart = devNodeUtcTime - 604800L;
        Long intervalEnd = devNodeUtcTime - 86400L;
        Long taskTime = 103680L;
        DStoragePerfTaskSplitUtil.decompose(taskStartTime, taskEndTime, intervalStart, intervalEnd, taskTime, perfCollectTaskList);
    }

    private static void addQuarterlyTableTask(Long taskStartTime, Long taskEndTime, Long devNodeUtcTime, List<PerfCollectTask> perfCollectTaskList) {
        Long intervalStart = taskStartTime;
        Long intervalEnd = devNodeUtcTime - 604800L;
        Long taskTime = 777600L;
        DStoragePerfTaskSplitUtil.decompose(taskStartTime, taskEndTime, intervalStart, intervalEnd, taskTime, perfCollectTaskList);
    }

    private static void decompose(Long taskStartTime, Long taskEndTime, Long intervalStart, Long intervalEnd, Long taskTime, List<PerfCollectTask> perfCollectTaskList) {
        if (taskStartTime > intervalEnd) {
            return;
        }
        if (taskEndTime < intervalStart) {
            return;
        }
        Long actualIntervalStart = Math.max(taskStartTime, intervalStart);
        Long actualIntervalEnd = Math.min(taskEndTime, intervalEnd);
        long counts = (actualIntervalEnd - actualIntervalStart) / taskTime;
        if ((actualIntervalEnd - actualIntervalStart) % taskTime != 0L) {
            ++counts;
        }
        int i = 0;
        while ((long)i < counts) {
            Long tempEnd = actualIntervalEnd - (long)i * taskTime;
            perfCollectTaskList.add(new PerfCollectTask(tempEnd - taskTime, tempEnd));
            ++i;
        }
    }

    public static Long getDevNodeUtcTime(DevNode devNode) {
        try {
            RestConnection restConn = RestConnectionManager.getDstorageLoginRestConnection((DevNode)devNode);
            ResponseInfo responseInfo = restConn.execGet(RestUtil.getSystemUtcTimeUrl((DevNode)devNode));
            if (responseInfo == null) {
                return GET_NODE_UTC_TIME_ERROR;
            }
            JSONObject taskData = (JSONObject)responseInfo.getContentMap().get("data");
            String utcTime = taskData.getStringOrDefault("CMO_SYS_UTC_TIME", "");
            return Long.valueOf(utcTime);
        }
        catch (Exception e) {
            return GET_NODE_UTC_TIME_ERROR;
        }
    }
}

