/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.util;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.infocollect.ui.support.DeviceQueryCliCommandTask;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.MultiErrorYesOrNoDialog;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import java.awt.Window;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceCliCommandCheckUtil {
    private static final Logger log = LoggerFactory.getLogger(DeviceCliCommandCheckUtil.class);
    private static final int SESSION_TIMEOUT_MINUTES = 30;
    private static final String MINUTE_STRING = " min";
    private static final String[] HEADERS = new String[]{ResourceUtil.getString((String)"infocollect.devicetable.head.ip"), ResourceUtil.getString((String)"infoCollect.session.alive.time")};
    private static final String TIP = ResourceUtil.getStringWithParams((String)"infoCollect.session.alive.time.tip", (Object[])new Object[]{30});

    private static Map<String, String> queryDevicesSessionKeepAliveTimes(JDialog mainDialog, List<DevNode> devNodes) {
        ProgressDialog progressDialog = new ProgressDialog((Window)mainDialog);
        Future deviceQueryCliCommandFuture = AsyncExcutor.submit((Callable)new DeviceQueryCliCommandTask(progressDialog, devNodes));
        if (progressDialog.isDisplayable()) {
            progressDialog.setVisible(true);
        }
        try {
            return (Map)deviceQueryCliCommandFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Query Cli Command future get Exception:", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static boolean hasShortKeepAliveTime(JDialog mainDialog, List<DevNode> devNodes) {
        List<DevNode> supportDevs = devNodes.stream().filter(DeviceCliCommandCheckUtil::isSupportDevice).collect(Collectors.toList());
        if (supportDevs.isEmpty()) {
            log.info("query devices keep alive time: no support device");
            return false;
        }
        List res = DeviceCliCommandCheckUtil.queryDevicesSessionKeepAliveTimes(mainDialog, supportDevs).entrySet().stream().filter(ipAndAliveTime -> StringUtils.str2Int((String)((String)ipAndAliveTime.getValue())) < 30).map(ipAndAliveTime -> Arrays.asList((String)ipAndAliveTime.getKey(), (String)ipAndAliveTime.getValue())).map(DeviceCliCommandCheckUtil::addSuffix).collect(Collectors.toList());
        if (res.isEmpty()) {
            log.info("query devices keep alive time: all device pass");
            return false;
        }
        MultiErrorYesOrNoDialog multiErrorYesOrNoDialog = DialogUtils.createMultiWarningYesNoDialog((Window)mainDialog, (String)TIP, (String[])HEADERS, res);
        if (multiErrorYesOrNoDialog.isDisplayable()) {
            multiErrorYesOrNoDialog.setVisible(true);
        }
        return multiErrorYesOrNoDialog.getValue() != 0;
    }

    private static boolean isSupportDevice(DevNode devNode) {
        return !devNode.isDsStorage() && !InfoCollectUtil.isNewOceanStor9000(devNode);
    }

    private static List<String> addSuffix(List<String> ipAndAliveTimeList) {
        String aliveTime = ipAndAliveTimeList.get(1);
        ipAndAliveTimeList.set(1, aliveTime + MINUTE_STRING);
        return ipAndAliveTimeList;
    }
}

