/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.util;

import com.huawei.ism.tool.infocollect.util.PdfInfo;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskPDfUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskPDfUtils.class);
    private final Locale locale;
    private String pdfPath;
    private PdfInfo pdfInfo;
    private boolean isDistributedDevice = false;

    public DiskPDfUtils(String pdfPath, PdfInfo pdfInfo) {
        this(pdfPath, pdfInfo, false);
    }

    public DiskPDfUtils(String pdfPath, PdfInfo pdfInfo, boolean isDistributedDevice) {
        this.pdfPath = pdfPath;
        this.pdfInfo = pdfInfo;
        this.isDistributedDevice = isDistributedDevice;
        this.locale = this.isDistributedDevice ? ApplicationContext.getInstance().getCurrentLanguage() : Locale.ENGLISH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildDiskPDf() {
        boolean bl;
        LOGGER.info(String.format(Locale.ENGLISH, "pdf Path is :{%s}", this.pdfPath));
        Rectangle rectPageSize = new Rectangle(PageSize.A4);
        Document document = new Document(rectPageSize, 50.0f, 50.0f, 50.0f, 50.0f);
        PdfWriter pw = null;
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(this.pdfPath);
            pw = PdfWriter.getInstance((Document)document, (OutputStream)os);
            document.open();
            this.buildPdfDate(document, os, this.pdfInfo);
            LOGGER.info("build PDF success.");
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                LOGGER.error("build PDF has exception", (Throwable)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                DiskPDfUtils.releaseResource(document, pw, os);
                throw throwable;
            }
            DiskPDfUtils.releaseResource(document, pw, os);
            return bl2;
        }
        DiskPDfUtils.releaseResource(document, pw, os);
        return bl;
    }

    private PdfPTable buildPdfPTable(List<Map<String, String>> pdfinfoList) throws IOException {
        List<String> keyList = this.buildKeyInTable(Locale.ENGLISH);
        PdfPTable keyTable = new PdfPTable(keyList.size());
        keyTable.setWidthPercentage(100.0f);
        keyTable.setSpacingBefore(0.0f);
        keyTable.setHorizontalAlignment(0);
        DiskPDfUtils.setCellInPdf(keyTable, this.buildKeyInTable(this.locale));
        for (Map<String, String> everyDate : pdfinfoList) {
            DiskPDfUtils.setCellInPdf(keyTable, keyList, everyDate);
        }
        return keyTable;
    }

    private void addImageToPdf(Document document, PdfWriter pw, String imgFile) throws BadElementException, IOException {
        Image img = Image.getInstance((String)imgFile);
        if (null == img) {
            return;
        }
        img.scalePercent(45.0f);
        img.setAlignment(1);
        try {
            document.add((Element)img);
        }
        catch (DocumentException e) {
            LOGGER.error("addImageToPdf failed.", (Throwable)e);
        }
        pw.flush();
    }

    private void setCellInPdf(PdfPTable table, String key, String value) throws IOException {
        BaseFont bfChinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)true);
        Paragraph p = new Paragraph(" " + key + System.lineSeparator() + System.lineSeparator(), new Font(bfChinese, 10.0f, 1));
        p.setAlignment(0);
        PdfPCell cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(4);
        cell.setBorderColor(Color.black);
        table.addCell(cell);
        p = new Paragraph(" " + value + System.lineSeparator() + System.lineSeparator(), new Font(bfChinese, 10.0f, 0));
        p.setAlignment(0);
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.setColspan(3);
        cell.setBorderColor(Color.black);
        table.addCell(cell);
    }

    private static void setCellInPdf(PdfPTable table, String key, int align, Color color, int fontSize) throws IOException {
        BaseFont bfChinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)true);
        Paragraph p = new Paragraph(" " + key + System.lineSeparator() + System.lineSeparator(), new Font(bfChinese, (float)fontSize, 1));
        p.setAlignment(align);
        PdfPCell cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(align);
        cell.setVerticalAlignment(5);
        cell.setBorderColor(color);
        table.addCell(cell);
    }

    private static void setCellInPdf(PdfPTable table, List<String> keys) throws IOException {
        BaseFont bfChinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)true);
        for (String key : keys) {
            Paragraph p = new Paragraph(key, new Font(bfChinese, 6.0f, 1));
            p.setAlignment(0);
            PdfPCell cell = new PdfPCell((Phrase)p);
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setBorderColor(Color.white);
            table.addCell(cell);
        }
    }

    private List<String> buildKeyInTable(Locale locale) {
        ArrayList<String> keySet = new ArrayList<String>();
        if (this.isDistributedDevice) {
            keySet.add(ResourceUtil.getString((String)"disk.destroy.report.table.management.ip", (Locale)locale));
            keySet.add(ResourceUtil.getString((String)"disk.destroy.report.table.solt.id", (Locale)locale));
        } else {
            keySet.add(ResourceUtil.getString((String)"disk.destroy.report.table.id", (Locale)locale));
        }
        keySet.add(ResourceUtil.getString((String)"disk.destroy.report.table.sn", (Locale)locale));
        keySet.add(ResourceUtil.getString((String)"disk.destroy.report.table.sed", (Locale)locale));
        keySet.add(ResourceUtil.getString((String)"disk.destroy.report.table.bus", (Locale)locale));
        keySet.add(ResourceUtil.getString((String)"disk.destroy.report.table.capacity", (Locale)locale));
        keySet.add(ResourceUtil.getString((String)"disk.destroy.report.table.sector", (Locale)locale));
        if (!this.isDistributedDevice) {
            keySet.add(ResourceUtil.getString((String)"disk.destroy.report.table.datatype", (Locale)locale));
        }
        keySet.add(ResourceUtil.getString((String)"disk.destroy.report.table.action", (Locale)locale));
        keySet.add(ResourceUtil.getString((String)"disk.destroy.report.table.standards", (Locale)locale));
        keySet.add(ResourceUtil.getString((String)"disk.destroy.report.table.overwrite.count", (Locale)locale));
        keySet.add(ResourceUtil.getString((String)"disk.destroy.report.table.verify", (Locale)locale));
        keySet.add(ResourceUtil.getString((String)"disk.destroy.report.table.capacity.ratio", (Locale)locale));
        keySet.add(ResourceUtil.getString((String)"disk.destroy.report.table.start.time", (Locale)locale));
        keySet.add(ResourceUtil.getString((String)"disk.destroy.report.table.complete.time", (Locale)locale));
        keySet.add(ResourceUtil.getString((String)"disk.destroy.report.table.run.time", (Locale)locale));
        keySet.add(ResourceUtil.getString((String)"disk.destroy.report.table.result", (Locale)locale));
        return keySet;
    }

    private static void setCellInPdf(PdfPTable table, List<String> keys, Map<String, String> date) throws IOException {
        BaseFont bfChinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)true);
        for (String key : keys) {
            Paragraph p = new Paragraph(date.get(key), new Font(bfChinese, 6.0f, 0));
            p.setAlignment(0);
            PdfPCell cell = new PdfPCell((Phrase)p);
            cell.setHorizontalAlignment(0);
            cell.setVerticalAlignment(5);
            cell.setBorderColor(Color.white);
            table.addCell(cell);
        }
    }

    private void buildPdfDate(Document document, OutputStream os, PdfInfo pdfInfo) throws IOException {
        PdfWriter pw = PdfWriter.getInstance((Document)document, (OutputStream)os);
        document.open();
        String workPath = com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getWorkPath();
        String imgFile = workPath.contains("service") ? new File(workPath).getParent() + File.separator + "huaweiLogo.PNG" : workPath + File.separator + "huaweiLogo.PNG";
        this.addImageToPdf(document, pw, imgFile);
        BaseFont bfChinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)true);
        Paragraph title = new Paragraph(ResourceUtil.getString((String)"disk.destroy.report.title", (Locale)this.locale), new Font(bfChinese, 15.0f, 1));
        title.setAlignment(1);
        document.add((Element)title);
        PdfPTable table = new PdfPTable(4);
        table.setWidthPercentage(100.0f);
        table.setSpacingBefore(100.0f);
        table.setHorizontalAlignment(0);
        document.add((Element)table);
        this.buildNomalDate(document, pdfInfo);
        this.buildTableDate(document, pdfInfo);
        this.buildSignature(document);
        pw.flush();
    }

    private void buildSignature(Document document) throws IOException {
        PdfPTable dateTable = new PdfPTable(1);
        dateTable.setWidthPercentage(100.0f);
        dateTable.setSpacingBefore(30.0f);
        dateTable.setHorizontalAlignment(2);
        DiskPDfUtils.setCellInPdf(dateTable, ResourceUtil.getString((String)"disk.destroy.report.signature", (Locale)this.locale), 2, Color.white, 10);
        DiskPDfUtils.setCellInPdf(dateTable, ResourceUtil.getString((String)"disk.destroy.report.date", (Locale)this.locale), 2, Color.white, 10);
        document.add((Element)dateTable);
    }

    private void buildTableDate(Document document, PdfInfo pdfInfo) throws IOException {
        PdfPTable dateTable = new PdfPTable(1);
        dateTable.setWidthPercentage(100.0f);
        dateTable.setSpacingBefore(0.0f);
        dateTable.setHorizontalAlignment(0);
        DiskPDfUtils.setCellInPdf(dateTable, ResourceUtil.getString((String)"disk.destroy.report.details", (Locale)this.locale), 0, Color.BLACK, 10);
        PdfPTable pdfPTable = this.buildPdfPTable(pdfInfo.getScreenshotContainsDisk());
        dateTable.addCell(pdfPTable);
        document.add((Element)dateTable);
    }

    private void buildNomalDate(Document document, PdfInfo pdfInfo) throws IOException {
        PdfPTable nomalDateTable = new PdfPTable(4);
        nomalDateTable.setWidthPercentage(100.0f);
        nomalDateTable.setSpacingBefore(100.0f);
        nomalDateTable.setHorizontalAlignment(0);
        this.setCellInPdf(nomalDateTable, ResourceUtil.getString((String)"disk.destroy.report.customer.name", (Locale)this.locale), pdfInfo.getCustomerName());
        this.setCellInPdf(nomalDateTable, ResourceUtil.getString((String)"disk.destroy.report.purpose", (Locale)this.locale), pdfInfo.getPurpose());
        this.setCellInPdf(nomalDateTable, ResourceUtil.getString((String)"disk.destroy.report.system.name", (Locale)this.locale), pdfInfo.getStorageName());
        this.setCellInPdf(nomalDateTable, ResourceUtil.getString((String)"disk.destroy.report.sn", (Locale)this.locale), pdfInfo.getStorageSerial());
        if (!this.isDistributedDevice) {
            this.setCellInPdf(nomalDateTable, ResourceUtil.getString((String)"disk.destroy.report.location", (Locale)this.locale), pdfInfo.getLocation());
        }
        this.setCellInPdf(nomalDateTable, ResourceUtil.getString((String)"disk.destroy.report.model", (Locale)this.locale), pdfInfo.getProductMode());
        this.setCellInPdf(nomalDateTable, ResourceUtil.getString((String)"disk.destroy.report.version", (Locale)this.locale), pdfInfo.getProductVersion());
        this.setCellInPdf(nomalDateTable, ResourceUtil.getString((String)"disk.destroy.report.source", (Locale)this.locale), ResourceUtil.getString((String)"disk.destroy.report.source.ans", (Locale)this.locale));
        this.setCellInPdf(nomalDateTable, ResourceUtil.getString((String)"disk.destroy.report.time", (Locale)this.locale), pdfInfo.getTime());
        this.setCellInPdf(nomalDateTable, ResourceUtil.getString((String)"disk.destroy.report.quantity", (Locale)this.locale), pdfInfo.getQuantityOfDisksErased());
        document.add((Element)nomalDateTable);
    }

    private static void releaseResource(Document document, PdfWriter pw, OutputStream os) {
        if (document != null) {
            try {
                document.close();
            }
            catch (RuntimeException e) {
                LOGGER.error("document closed failed.", (Throwable)e);
            }
        }
        if (pw != null) {
            try {
                pw.close();
            }
            catch (Exception e) {
                LOGGER.error("pw closed failed.", (Throwable)e);
            }
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception e) {
                LOGGER.error("os closed failed.", (Throwable)e);
            }
        }
    }
}

