/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.util;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.PriKeyInfo;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FailedDevParser
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(FailedDevParser.class);
    private static final long serialVersionUID = 2063494463789166350L;

    public List<DevNode> getFailedDevNode() {
        ArrayList<DevNode> devNodeList = new ArrayList<DevNode>();
        String paramFilePath = System.getenv("paramFile");
        if (StringUtils.isNULLStr((String)paramFilePath)) {
            log.error("paramFilePath is empty or secretKey is empty!{}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)paramFilePath));
            return devNodeList;
        }
        File paramFile = new File(FilePathUtils.checkFile((String)paramFilePath));
        if (!paramFile.exists()) {
            log.info("paramFilePath not exsit!");
            return devNodeList;
        }
        String content = StreamUtils.readStringFormFile((File)paramFile);
        boolean flag = paramFile.delete();
        if (!flag) {
            log.error("read data failed from {}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)paramFilePath));
        }
        JSONArray jsonArray = new JSONArray(content);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = (JSONObject)jsonArray.get(i);
            DevNode devNode = this.jsonObject2DevNode(jsonObject);
            if (!InfoCollectUtil.isSupportDev(devNode)) continue;
            try {
                DefaultNodeProviderImpl.getInstance().addNode(devNode);
            }
            catch (ToolException e) {
                log.error("add dev node failed. {}", (Object)e.getMessage());
            }
            devNodeList.add(devNode);
        }
        return devNodeList;
    }

    private DevNode jsonObject2DevNode(JSONObject jsonObject) {
        DevNode devNode = new DevNode();
        try {
            devNode.setIp(jsonObject.getString("devIp"));
            devNode.setDeviceType(DeviceType.valueOf((String)jsonObject.getString("devType")));
            devNode.setProductVersion(jsonObject.getString("devVersion"));
            devNode.setDeviceName(this.decodeByBase64(jsonObject.getString("devName")));
            devNode.setDeviceSerialNumber(jsonObject.getString("serialNo"));
            devNode.setPort(jsonObject.getInt("port"));
            devNode.setItDeviceType(ItDeviceType.valueOf((String)jsonObject.getString("itDeviceTypeName")));
            String debugPwd = jsonObject.getString("developerPwd");
            devNode.setDeveloperPwd(AESEncrypt.decrypt((String)debugPwd));
            debugPwd = "";
            String pwd = jsonObject.getString("password");
            User user = new User(this.decodeByBase64(jsonObject.getString("username")), AESEncrypt.decrypt((String)pwd));
            devNode.setLoginUser(user);
            pwd = "";
        }
        catch (JSONException e) {
            log.error("Toolkit Frame is old", (Throwable)e);
        }
        this.handleDevIpsAndSocks(jsonObject, devNode);
        this.handleDevSshForward(jsonObject, devNode);
        this.handlePriKey(jsonObject, devNode);
        return devNode;
    }

    private void handleDevIpsAndSocks(JSONObject jsonObject, DevNode devNode) {
        JSONArray ipList = jsonObject.getJSONArray("devInnerIps");
        for (int j = 0; j < ipList.length(); ++j) {
            String ip = ipList.getString(j);
            devNode.addIp(ip);
        }
        try {
            if (jsonObject.has("sock5")) {
                JSONObject jsonDevSocks5 = new JSONObject(jsonObject.getString("sock5"));
                Socks5Proxy socks5Proxy = this.toDevNodeSocks5(jsonDevSocks5);
                devNode.setSocks5Proxy(socks5Proxy);
            } else {
                devNode.setSocks5Proxy(null);
            }
        }
        catch (JSONException e) {
            log.info("Socks5 does not exist on the device", (Throwable)e);
            devNode.setSocks5Proxy(null);
        }
    }

    private Socks5Proxy toDevNodeSocks5(JSONObject jsonSocks5) throws JSONException {
        Socks5Proxy socks5Proxy = new Socks5Proxy();
        socks5Proxy.setPort(jsonSocks5.getString("port"));
        socks5Proxy.setName(this.decodeByBase64(jsonSocks5.getString("name")));
        socks5Proxy.setServerIp(jsonSocks5.getString("serverIp"));
        socks5Proxy.setUuid(jsonSocks5.getString("uuid"));
        socks5Proxy.setUser(this.decodeByBase64(jsonSocks5.getString("user")));
        String pwd = jsonSocks5.getString("pass");
        socks5Proxy.setPass(AESEncrypt.decrypt((String)pwd));
        socks5Proxy.setAuthentic(jsonSocks5.getBoolean("authentic"));
        pwd = "";
        return socks5Proxy;
    }

    private void handleDevSshForward(JSONObject jsonObject, DevNode devNode) {
        try {
            if (jsonObject.has("sshForward")) {
                JSONArray jsonArraySsh = new JSONArray(jsonObject.getString("sshForward"));
                ArrayList<MultiRouteNode> muList = new ArrayList<MultiRouteNode>();
                for (int k = 0; k < jsonArraySsh.length(); ++k) {
                    JSONObject jsonSsh = jsonArraySsh.getJSONObject(k);
                    String pwd = jsonSsh.getString("pwd");
                    MultiRouteNode multiRouteNode = new MultiRouteNode(jsonSsh.getString("host"), jsonSsh.getInt("port"), this.decodeByBase64(jsonSsh.getString("uname")), AESEncrypt.decrypt((String)pwd));
                    muList.add(multiRouteNode);
                    pwd = null;
                }
                devNode.setSshForwardList(muList);
            } else {
                devNode.setSshForwardList(null);
            }
        }
        catch (JSONException e) {
            log.info("SSH does not exist on the device", (Throwable)e);
            devNode.setSshForwardList(null);
        }
    }

    private void handlePriKey(JSONObject jsonObject, DevNode devNode) {
        try {
            if (jsonObject.has("priKey")) {
                JSONObject jsonDevPriKey = new JSONObject(jsonObject.getString("priKey"));
                PriKeyInfo info = new PriKeyInfo();
                info.setKeyName(this.decodeByBase64(jsonDevPriKey.getString("keyname")));
                info.setKeyPath(this.decodeByBase64(jsonDevPriKey.getString("keypath")));
                info.setKeyPwd(AESEncrypt.decrypt((String)jsonDevPriKey.getString("keypwd")));
                devNode.setPriKey(info);
            }
        }
        catch (JSONException e) {
            log.info("PriKey does not exist on the device", (Throwable)e);
        }
    }

    private String decodeByBase64(String content) {
        return Base64EncodeUtils.decode((String)content);
    }
}

