/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.util;

import com.huawei.ism.tool.infocollect.util.ComparatorFilesByLastModify;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ToolUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilesUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilesUtil.class);
    private static final long DISK_FULL_SIZE = 0xC800000L;

    private FilesUtil() {
    }

    public static File copyFile(File targetFile, String toPath) {
        if (null == targetFile) {
            return null;
        }
        File result = null;
        File copyToDir = new File(toPath);
        if (!copyToDir.exists() && !copyToDir.mkdirs()) {
            return null;
        }
        String newFile = copyToDir + File.separator + targetFile.getName();
        if (targetFile.isDirectory()) {
            if (!new File(newFile).mkdirs()) {
                return null;
            }
        } else {
            try (FileInputStream tfin = new FileInputStream(targetFile);
                 FileOutputStream nfout = new FileOutputStream(newFile);){
                FilesUtil.transferChannel(tfin, nfout);
                result = new File(newFile);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("FileNotFoundException: target file {} or new file {} not found.", (Object)targetFile.getName(), (Object)newFile);
            }
            catch (IOException e) {
                LOGGER.error("transfer data from {} fail.", (Object)targetFile, (Object)e);
            }
        }
        return result;
    }

    private static void transferChannel(FileInputStream tfin, FileOutputStream nfout) throws IOException {
        FileChannel targetChannel = null;
        FileChannel newChannel = null;
        try {
            targetChannel = tfin.getChannel();
            newChannel = nfout.getChannel();
            newChannel.transferFrom(targetChannel, 0L, targetChannel.size());
        }
        catch (IOException e) {
            try {
                LOGGER.error("transfer failed.");
                throw e;
            }
            catch (Throwable throwable) {
                FilesUtil.closeChannel(targetChannel, newChannel);
                throw throwable;
            }
        }
        FilesUtil.closeChannel(targetChannel, newChannel);
    }

    public static File copyFile(File targetFile, String toPath, String targetFileName) {
        if (null == targetFile) {
            return null;
        }
        File result = null;
        File copyToDir = new File(toPath);
        if (!copyToDir.exists() && !copyToDir.mkdirs()) {
            return null;
        }
        String newFile = copyToDir + File.separator + targetFileName;
        if (targetFile.isDirectory()) {
            if (!new File(newFile).mkdirs()) {
                return null;
            }
        } else {
            try (FileInputStream tfin = new FileInputStream(targetFile);
                 FileOutputStream nfout = new FileOutputStream(newFile);){
                FilesUtil.transferChannel(tfin, nfout);
                result = new File(newFile);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("FileNotFoundException: target file {} or new file {} not found.", (Object)targetFile.getName(), (Object)newFile);
            }
            catch (IOException e) {
                LOGGER.error("transfer data from {} fail.", (Object)targetFile, (Object)e);
            }
        }
        return result;
    }

    public static File copyFiles(File[] targetFiles, String toPath) {
        File result = null;
        FilesUtil.mkdirs(toPath);
        for (File file : targetFiles) {
            String newFilePath = toPath + File.separator + file.getName();
            if (file.isDirectory()) {
                FilesUtil.mkdirs(newFilePath);
                FilesUtil.copyFiles(file.listFiles(), newFilePath);
                continue;
            }
            try (FileInputStream tfin = new FileInputStream(file);
                 FileOutputStream nfout = new FileOutputStream(newFilePath);){
                FilesUtil.transferChannel(tfin, nfout);
                result = new File(newFilePath);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Exception: input file {}  or out file {} not found.", (Object)file.getName(), (Object)newFilePath);
            }
            catch (IOException e) {
                LOGGER.error("transfer data fail.", (Object)e.getMessage());
            }
        }
        return result;
    }

    private static void closeChannel(FileChannel targetChannel, FileChannel newChannel) {
        try {
            if (targetChannel != null) {
                targetChannel.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException", (Throwable)e);
        }
        try {
            if (newChannel != null) {
                newChannel.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException", (Throwable)e);
        }
    }

    public static void mkdirs(String path) {
        File copyToDir = new File(path);
        if (!copyToDir.exists() && !copyToDir.mkdirs()) {
            try {
                LOGGER.info("create dirs error: {}", (Object)copyToDir.getCanonicalPath());
            }
            catch (IOException e) {
                LOGGER.error("Get CanonicalPath Error: ", (Throwable)e);
            }
        }
    }

    public static void clearFolder(File files) {
        File[] tempFiles = files.listFiles();
        if (tempFiles == null) {
            return;
        }
        for (File file : tempFiles) {
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                if (null == listFiles) {
                    try {
                        LOGGER.info("file in {} is null!", (Object)file.getCanonicalPath());
                    }
                    catch (IOException e) {
                        LOGGER.error("get canonical path error:", (Throwable)e);
                    }
                    return;
                }
                if (listFiles.length != 0) {
                    FilesUtil.clearFolder(file);
                }
                if (listFiles.length != 0 || file.getAbsoluteFile().delete()) continue;
                try {
                    LOGGER.info("file delete error:{}", (Object)file.getCanonicalPath());
                }
                catch (IOException e) {
                    LOGGER.error("get canonical path error:", (Throwable)e);
                }
                continue;
            }
            if (file.delete()) continue;
            try {
                LOGGER.info("file delete error:{}", (Object)file.getCanonicalPath());
            }
            catch (IOException e) {
                LOGGER.error("get canonical path error", (Throwable)e);
            }
        }
    }

    public static boolean checkNormalPath(String path) {
        String replaced = path.replaceAll("\\\\", "").replaceAll("/", "").replaceAll(":", "").replaceAll("\\.", "");
        if (replaced.contains("  ")) {
            return false;
        }
        return replaced.matches("[\\w ]+");
    }

    public static boolean checkBlankPath(String path) {
        return ApplicationContext.getInstance().isWindowsOS() || !path.contains(" ");
    }

    public static boolean checkDiskFreeSpace(File destFile, int miniCapacity) {
        long capacity = (long)miniCapacity * 1024L * 1024L;
        long destFileFreeSpace = destFile.getFreeSpace();
        return destFileFreeSpace >= capacity;
    }

    public static boolean copyRight(String srcPath, String destPath, int srcLimitCapacity, int destMiniCapacity) {
        File destFile = new File(destPath);
        File srcFile = new File(srcPath);
        if (!srcFile.exists()) {
            LOGGER.info("src file is not exists.");
            return false;
        }
        if (!destFile.exists() && !destFile.mkdirs()) {
            LOGGER.info("make destFile failed.");
            return false;
        }
        if (!FilesUtil.checkFileSize(srcFile, srcLimitCapacity)) {
            LOGGER.info("the size of srcfile is more than 2G");
            return false;
        }
        if (!destFile.canWrite()) {
            LOGGER.info("the file can not write.");
            return false;
        }
        if (!FilesUtil.checkDiskFreeSpace(destFile, destMiniCapacity)) {
            LOGGER.info("the file FreeSpace is less than {}M.", (Object)destMiniCapacity);
            return false;
        }
        if (!FilesUtil.checkDiskFull(srcFile, destFile)) {
            LOGGER.info("the diskspace is not enough");
            return false;
        }
        return true;
    }

    public static boolean checkFileSize(File srcFile, int srcLimitCapacity) {
        return srcFile.length() <= (long)srcLimitCapacity * 1024L * 1024L;
    }

    public static boolean checkDiskFull(File srcFile, File destFile) {
        return destFile.getFreeSpace() - srcFile.length() > 0xC800000L;
    }

    public static File getLastModiyFile(File soruceDir) {
        if (!soruceDir.exists() || !soruceDir.isDirectory()) {
            LOGGER.warn(String.format(Locale.ROOT, "Source dir: %s is not exist or is not directory.", utils.FilesUtil.getCanonicalPath((File)soruceDir)));
            return null;
        }
        File[] collectFiles = soruceDir.listFiles();
        if (collectFiles == null) {
            LOGGER.error("list file for:" + utils.FilesUtil.getCanonicalPath((File)soruceDir) + " error.");
            return null;
        }
        LinkedList<File> fileList = new LinkedList<File>();
        Collections.addAll(fileList, collectFiles);
        fileList.sort(new ComparatorFilesByLastModify());
        if (!fileList.isEmpty()) {
            return (File)fileList.get(0);
        }
        return null;
    }

    public static void deleteFileAfterReleased(File file, long timeout) {
        if (file.isDirectory()) {
            File[] fileList = file.listFiles();
            if (fileList == null) {
                return;
            }
            for (File tmpFile : fileList) {
                FilesUtil.deleteFileAfterReleased(tmpFile, timeout);
            }
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                LOGGER.error("Delete dir error, cause:", (Throwable)e);
            }
        } else {
            FilesUtil.deleteFile(file, timeout);
        }
    }

    private static void deleteFile(File file, long timeout) {
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            try {
                FilesUtil.waitFileRelease(file.getCanonicalPath(), timeout);
                Files.delete(file.toPath());
            }
            catch (IOException ioException) {
                LOGGER.error("Delete file error, cause:", (Throwable)ioException);
            }
        }
    }

    private static void waitFileRelease(String filePath, long timeout) {
        long startTime = System.currentTimeMillis();
        while (ToolUtils.isFileCanOperate((String)filePath)) {
            LOGGER.error("File is used by other progress, waiting...");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.error("sleep error, waiting...");
            }
            if (System.currentTimeMillis() - startTime <= timeout) continue;
            LOGGER.warn("waiting File release is timeout.");
            break;
        }
    }
}

