/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.util;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.entity.ComputeNodeParam;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.util.Utils;
import com.huawei.json.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class GroupFcvComputeNodes {
    private static final Logger log = LoggerFactory.getLogger(GroupFcvComputeNodes.class);
    private static final int NODES_MAX_NUM_EACH_GROUP = 6;
    private static final String SCENE = "FusionsphereIaaS";
    private static final String COLLECT_USER_615 = "openapi";
    private static final String COLLECT_USER = "openapi_smartkit";

    public static boolean createComputeNodesGroups(DevNode devNode) {
        Map<String, ComputeNodeParam> computeNodesInfo = CollectDataContext.getInstance().getDevComputeNodesInfo().get(devNode);
        if (computeNodesInfo.isEmpty()) {
            log.error("ComputeNodesInfo is empty.");
            return false;
        }
        List<ComputeNodeParam> computeNodesParams = computeNodesInfo.values().stream().filter(computeNodeParam -> !computeNodeParam.getLogInfo().isEmpty()).collect(Collectors.toList());
        if (computeNodesParams.isEmpty()) {
            log.error("No compute node needs to be collected.");
            return false;
        }
        List<String> itemParams = GroupFcvComputeNodes.createItemParams(computeNodesParams, devNode);
        if (Utils.isNullList(itemParams)) {
            log.error("the item params is null.");
            return false;
        }
        Map<DevNode, List<String>> devComputeNodesGroupsInfo = CollectDataContext.getInstance().getDevComputeNodesGroupsInfo();
        devComputeNodesGroupsInfo.put(devNode, itemParams);
        CollectDataContext.getInstance().setDevComputeNodesGroupsInfo(devComputeNodesGroupsInfo);
        return true;
    }

    private static List<String> createItemParams(List<ComputeNodeParam> computeNodesParam, DevNode devNode) {
        List computeNodesParamGroups = ListUtils.partition(computeNodesParam, (int)6);
        long startTime = computeNodesParam.get(0).getStartTime();
        long endTime = computeNodesParam.get(0).getEndTime();
        String collectUser = GroupFcvComputeNodes.getCollectUser(devNode);
        return computeNodesParamGroups.stream().map(paramGroup -> GroupFcvComputeNodes.createGroupInfo(startTime, endTime, paramGroup, collectUser)).collect(Collectors.toList());
    }

    private static String getCollectUser(DevNode devNode) {
        return Products.compareVersion((String)devNode.getProductVersion(), (String)"6.1.6RC1") >= 0 ? COLLECT_USER : COLLECT_USER_615;
    }

    private static String createGroupInfo(long startTime, long endTime, List<ComputeNodeParam> paramGroup, String collectUser) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("nodeList", GroupFcvComputeNodes.getNodeList(paramGroup));
        param.put("startTime", InfoCollectUtil.formatTimeMillisToStringData(startTime));
        param.put("endTime", InfoCollectUtil.formatTimeMillisToStringData(endTime));
        param.put("scene", SCENE);
        param.put("collectUser", collectUser);
        return new JSONObject(param).toString();
    }

    private static List<Object> getNodeList(List<ComputeNodeParam> paramGroup) {
        return paramGroup.stream().map(GroupFcvComputeNodes::createNodeInfo).collect(Collectors.toList());
    }

    private static Map<Object, Object> createNodeInfo(ComputeNodeParam computeNodeParam) {
        HashMap<Object, Object> nodeInfo = new HashMap<Object, Object>();
        nodeInfo.put("logInfo", computeNodeParam.getLogInfo());
        nodeInfo.put("mgntIp", computeNodeParam.getNodeIp());
        nodeInfo.put("nodeIp", computeNodeParam.getNodeIp());
        nodeInfo.put("name", computeNodeParam.getNodeName());
        nodeInfo.put("nodesType", computeNodeParam.getNodesType());
        nodeInfo.put("product", computeNodeParam.getProduct());
        nodeInfo.put("status", computeNodeParam.getStatus());
        return nodeInfo;
    }
}

