/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.util;

import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.filechooser.FileSystemView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InfoCollectDirPropertiesUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoCollectDirPropertiesUtil.class);
    public static final String INFO_COLLECT_DIRECTORY = "info.collect.directory";
    private static boolean useSceneEnvPath = true;
    private static final String FILENAME = "infoCollectDir.properties";
    private static final String INFOCOLLECTCOMMENT = "Info collect directory";
    private static final Object LOCK_OBJECT = new Object();

    private InfoCollectDirPropertiesUtil() {
    }

    public static String getProperty() {
        if (CollectDataContext.getInstance().isScene() && CollectDataContext.getInstance().isForeground()) {
            if (!useSceneEnvPath && CollectDataContext.getInstance().isStorageCollectSec()) {
                return InfoCollectDirPropertiesUtil.getPropertiesPath();
            }
            String dir = CollectDataContext.getInstance().getSceneCollectDir();
            try {
                File file = new File(dir + File.separator + "InfoCollect");
                if (!file.exists() && !file.mkdirs()) {
                    LOGGER.info("create file failed.");
                }
                return file.getCanonicalPath();
            }
            catch (Exception e) {
                LOGGER.error("make scene dir error.");
            }
        }
        return InfoCollectDirPropertiesUtil.getPropertiesPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPropertiesPath() {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            String path = "";
            try {
                Object pathObj = HibernateContainer.getInstance().get((Object)INFO_COLLECT_DIRECTORY);
                String string = path = pathObj != null ? pathObj.toString() : "";
                if (StringUtils.isNULLStr((String)path)) {
                    path = FileSystemView.getFileSystemView().getDefaultDirectory().getCanonicalPath() + File.separator + "infoCollect" + File.separator + "data" + File.separator + "collect";
                    File newfile = new File(path);
                    if (!newfile.exists() && !newfile.mkdirs()) {
                        return ApplicationContext.getInstance().getWorkPath();
                    }
                    return path;
                }
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
            return path;
        }
    }

    private static void closeFileReader(FileInputStream fileReader) {
        if (fileReader != null) {
            try {
                fileReader.close();
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProperty(String value) throws ToolException {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            HibernateContainer.getInstance().put(INFO_COLLECT_DIRECTORY, (Object)value);
        }
    }

    private static void closeFileWriter(FileOutputStream fileWrite) {
        if (fileWrite != null) {
            try {
                fileWrite.close();
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    public static boolean isUseSceneEnvPath() {
        return useSceneEnvPath;
    }

    public static void setUseSceneEnvPath(boolean useSceneEnvPath) {
        InfoCollectDirPropertiesUtil.useSceneEnvPath = useSceneEnvPath;
    }
}

