/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.util;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.CallbackPackageSnMappingUtils;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.devicemanager.utils.LicenseFeatureQueryUtil;
import com.huawei.ism.tool.framework.platform.common.data.ToolUserRole;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.hardware.Disk;
import com.huawei.ism.tool.framework.pubservice.hardware.DiskLocation;
import com.huawei.ism.tool.framework.pubservice.impl.AbstractUserOpDataSev;
import com.huawei.ism.tool.infocollect.CollectDataContext;
import com.huawei.ism.tool.infocollect.config.CollectConfigParser;
import com.huawei.ism.tool.infocollect.entity.SupportVersionConf;
import com.huawei.ism.tool.infocollect.service.BizPackageService;
import com.huawei.ism.tool.infocollect.service.CheckLicenseTask;
import com.huawei.ism.tool.infocollect.service.CollectDeviceService;
import com.huawei.ism.tool.infocollect.service.InfoCollectService;
import com.huawei.ism.tool.infocollect.service.backgroud.TaskCons;
import com.huawei.ism.tool.infocollect.ui.setup.ConfirmationWithSignDialog;
import com.huawei.ism.tool.infocollect.util.FilesUtil;
import com.huawei.ism.tool.infocollect.util.IPUtil;
import com.huawei.ism.tool.infocollect.util.InfoCollectDirPropertiesUtil;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.json.JSONObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public final class InfoCollectUtil {
    private static final Logger log = LoggerFactory.getLogger(InfoCollectUtil.class);
    public static final String CLOUD_SERVICE = "cloudservice";
    public static final String ALL_DISK_NUM = "allDiskNum";
    public static final String SELECTED_DISK_NUM = "selectedDisk";
    public static final String SUCCESS_DISK_LOG_NUM = "success";
    public static final String PARTLY_SUCCESS_DISK_LOG_NUM = "partly success";
    public static final String FAILED_DISK_LOG_NUM = "failed";
    public static final String UNSUPPORTED_DISK_NUM = "unsupported";
    public static final String NO_VALUE = "--";
    public static final String NODECFG_KEY = "nodeCfg";
    public static final String BIZ_PACKAGE_PROFIX = ".zip";
    public static final String START_TIME = "startTime";
    public static final String START_TIME_PRECISION = "startTimePrecision";
    public static final String END_TIME = "endTime";
    public static final String END_TIME_PRECISION = "endTimePrecision";
    public static final String COLLECT_RET_DIR = "collectRetDir";
    public static final String COLLECT_RET_FILE_NAME = "collectRetFileName";
    public static final String COLLECT_MANAGEMENT_OBJ = "collecManagementObj";
    public static final String COLLECT_REMOTE_PATH = "collecRemotePath";
    public static final String CAL_PWD = "calPwd";
    public static final String CURR_SYS_TIME = "currSysTime";
    public static final String COMPRESS = "compress";
    public static final String DATA_COLLECT_RET = "DataCollectResult";
    public static final String DEV_USER_NAME = "username";
    public static final String DEV_PWD = "password";
    public static final String ZIP_COMMAND = "7z_command";
    public static final String INTEGRATE_BACK = "integrate_back";
    public static final String DEBUG_PWD = "debug_password";
    public static final String PY_RETURN_DETAIL = "py_detail";
    public static final String PY_NOT_SUPPORT = "not_support";
    public static final String INTEGRATE_TARGET_NODE = "integrate_target_node";
    public static final String INTEGRATE_SELECTED_NODE = "integrate_selected_node";
    public static final String COLLECTALLFINO = "collectAllInfo";
    public static final String NORMAL_DISKLOG_RESULT_DICT = "collectResultDict";
    public static final String TMP_DIR = "tmpDir";
    public static final String INFO_COLLECT_TOOL_DIR = "toolDir";
    public static final String MAP_KEY = "dev";
    public static final String SSH_PRO = "SSH";
    public static final String SFTP_PRO = "SFTP";
    public static final String CLI = "cli";
    public static final int HASH_CODE_NUM = 17;
    public static final int PORT_22 = 22;
    public static final int PORT_23 = 23;
    public static final int COLLECT_ALL = 0;
    public static final int COLLECT_PART = 1;
    public static final String TEMP_DIR = "temp";
    public static final String SEPARATOR = " : ";
    public static final String DURATION_TIME_DATA = "collect_duration_time_data.txt";
    public static final List<String> NO_MODIFY_PRODUCTS = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList("V100R00", "V200R001C00", "V200R002C00", "V200R002C10")));
    public static final String TEMP_DIR_PATH = String.join((CharSequence)File.separator, ApplicationContext.getInstance().getWorkPath(), "temp");
    public static final String UPLOAD_TMP_PATH = ApplicationContext.getInstance().getWorkPath() + File.separator + ".." + File.separator + ".." + File.separator + "upload" + File.separator + "toolResult" + File.separator + "collect";
    public static final String TOOL_INI_PATH = ApplicationContext.getInstance().getWorkPath() + File.separator + "tool.ini";
    public static final File LOCAL_RECORD_COLLECT_HISTORY_FILE = new File(String.join((CharSequence)File.separator, ApplicationContext.getInstance().getWorkPath(), "temp", "device_collect_history.txt"));
    public static final String COLLECT_COMPUTE_NODES_ITEM_NAME = "collect_compute_nodes";
    public static final String TEXT = "text";
    public static final String TOOL_TIP_TEXT = "toolTipText";
    public static final String TROUBLE_SHOOTING_MAIN_SCENE = "Troubleshooting";
    public static final String A800_SUB_SCENE = "IntelligentCompute_A800_Storage_Collect";
    public static final String SCENE_INFO_KEY = "jsonScene";
    private static final int PROGRESS_90 = 90;
    private static final String PACKAGE_INFO = "pkginfo";
    private static final String LOG_FILE = "log";
    private static final String SECOND = "s";
    private static final String ZERO_SECONDS = "0s";
    private static final String SEVEN_ZIP_SUFFIX = ".7z";
    private static final String DIGITAL_VERSION_REGEX = "\\d+\\.\\d+.*";
    private static final ReentrantReadWriteLock LOCK = new ReentrantReadWriteLock();
    private static final JythonExecuter EXECUTER = new JythonExecuter();
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(InfoCollectUtil.class);
    private static final Object LOCAL_RECORD_SN_LOCK = new Object();

    private InfoCollectUtil() {
    }

    public static boolean isSupportDev(com.huawei.ism.tool.obase.entity.DevNode node) {
        if (node.isDsStorage()) {
            return true;
        }
        String proVer = node.getProductVersion();
        String dev = node.getDeviceType().toString() + " " + proVer;
        boolean isSupport = true;
        Set<SupportVersionConf> supportVersions = new BizPackageService().getSupportVersionConfs();
        for (SupportVersionConf supportVersionConf : supportVersions) {
            String modelVer = supportVersionConf.getModelVersion();
            if (!dev.contains(modelVer)) continue;
            isSupport = InfoCollectUtil.checkVersionByScript(node, supportVersionConf.getScript());
            break;
        }
        if (!isSupport) {
            return isSupport;
        }
        Set<String> excludeDevs = new BizPackageService().getExcludeProductsWitchVersion();
        for (String devInfo : excludeDevs) {
            if (!dev.contains(devInfo)) continue;
            return false;
        }
        Set<String> set = new BizPackageService().getSupportProductsWitchVersion();
        for (String devInfo : set) {
            if (!Products.contains((String)dev, (String)devInfo)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkVersionByScript(com.huawei.ism.tool.obase.entity.DevNode dev, String scriptPath) {
        try {
            File pyFile = new File(FilePathUtils.checkFile((String)scriptPath));
            EXECUTER.compileScript(pyFile);
            HashMap<String, com.huawei.ism.tool.obase.entity.DevNode> paramMap = new HashMap<String, com.huawei.ism.tool.obase.entity.DevNode>();
            paramMap.put(MAP_KEY, dev);
            Object ret = EXECUTER.simpleInvokeFunction("execute", paramMap);
            return Boolean.valueOf(ret.toString());
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(InfoCollectUtil.class).error("Check version error.", e);
            return true;
        }
    }

    public static boolean qryDiskByPyScript(com.huawei.ism.tool.obase.entity.DevNode dev, String scriptPath) {
        try {
            File pyFile = new File(scriptPath);
            EXECUTER.compileScript(pyFile);
            HashMap<String, com.huawei.ism.tool.obase.entity.DevNode> paramMap = new HashMap<String, com.huawei.ism.tool.obase.entity.DevNode>();
            paramMap.put(MAP_KEY, dev);
            Object ret = EXECUTER.simpleInvokeFunction("execute", paramMap);
            return Boolean.parseBoolean(ret.toString());
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(InfoCollectUtil.class).error("Query disk exception:", e);
            return true;
        }
    }

    public static int computeProgress(int current, int sum) {
        return current * 90 / sum;
    }

    public static boolean checkUploadRight() {
        String code = System.getenv("toolRunRole");
        LOGGER.info("toolRunRole : {}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)code));
        return ToolUserRole.isRoleCanUplaod((String)code) && CollectDataContext.getInstance().getFoolkitZhCn();
    }

    public static boolean dealExParams(String exParams, String key, String expectedVal) {
        String val = "";
        if (null == exParams) {
            return false;
        }
        try {
            JSONObject jsonObj = new JSONObject(exParams);
            val = jsonObj.getString(key);
        }
        catch (Exception e) {
            LOGGER.error("prase exParams error");
            return false;
        }
        return expectedVal.equalsIgnoreCase(val);
    }

    public static void upload(com.huawei.ism.tool.obase.entity.DevNode devNodeTemp, Map<String, Object> collectEnvTemp) {
        if (!ApplicationContext.getInstance().isOEM() && CollectDataContext.getInstance().isForeground() && InfoCollectUtil.checkUploadRight()) {
            String infoCollectDir = InfoCollectDirPropertiesUtil.getProperty();
            String ip = IPUtil.ipV6ToPeriod(devNodeTemp.getIp());
            String collectDir = infoCollectDir + File.separator + ip + "_" + devNodeTemp.getDeviceSerialNumber();
            collectEnvTemp.put("zipFile", collectDir + File.separator + collectEnvTemp.get(COLLECT_RET_FILE_NAME));
            String srcPath = collectDir + File.separator + collectEnvTemp.get(COLLECT_RET_FILE_NAME);
            File srcFile = new File(srcPath);
            try {
                if (srcFile.exists() && FilesUtil.checkFileSize(srcFile, 2048)) {
                    ArrayList<DevNode> nodeList = new ArrayList<DevNode>();
                    nodeList.add(EntityUtils.toNewDev((com.huawei.ism.tool.obase.entity.DevNode)devNodeTemp));
                    if (!CallbackPackageSnMappingUtils.recordToolPackageSnMapping((String)"collect", nodeList, (String)srcPath)) {
                        LOGGER.info("Write file sn failed ! ");
                    }
                }
            }
            catch (Exception e) {
                LOGGER.info("Write file sn failed ! ", (Throwable)e);
            }
        }
    }

    public static String getDevCollectDir(com.huawei.ism.tool.obase.entity.DevNode node) {
        String infoCollectDir = InfoCollectDirPropertiesUtil.getProperty();
        String ip = IPUtil.ipV6ToPeriod(node.getIp());
        String sn = node.getDeviceSerialNumber();
        String version = node.getProductVersion();
        return infoCollectDir + File.separator + ip + "_" + (com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)sn) ? version : sn);
    }

    public static void copyToolIni(String toPath) {
        File toolIni = new File(TOOL_INI_PATH);
        if (toolIni.exists()) {
            utils.FilesUtil.copyFile((File)toolIni, (String)toPath);
        }
    }

    public static void copyToolIniTo7Z(Map<String, Object> collectEnv, com.huawei.ism.tool.obase.entity.DevNode devNode) {
        File toolIni = new File(TOOL_INI_PATH);
        if (toolIni.exists()) {
            String collectRet = collectEnv.get(COLLECT_RET_DIR) + File.separator + collectEnv.get(COLLECT_RET_FILE_NAME);
            String tempDevDir = ApplicationContext.getInstance().getWorkPath() + File.separator + (TEMP_DIR + File.separator + devNode.getIp() + devNode.getDeviceSerialNumber() + "pkginfoTemp").replace(":", "_");
            String tempPkginfo = tempDevDir + File.separator + PACKAGE_INFO;
            File pkginfo = new File(tempPkginfo);
            if (pkginfo.exists()) {
                utils.FilesUtil.copyFile((File)toolIni, (String)tempPkginfo);
            } else if (pkginfo.mkdirs()) {
                utils.FilesUtil.copyFile((File)toolIni, (String)tempPkginfo);
            }
            if (FileAssistant.compressDirTo7ZFile((String)collectRet, (String)tempPkginfo, (String)"")) {
                return;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("Thread sleep error");
            }
            FileAssistant.compressDirTo7ZFile((String)collectRet, (String)tempPkginfo, (String)"-tzip");
            FileUtils.deleteFile((File)new File(tempDevDir));
        }
    }

    public static void copyLogTo7Z(Map<String, Object> collectEnv, com.huawei.ism.tool.obase.entity.DevNode devNode) {
        String tempDevDir = ApplicationContext.getInstance().getWorkPath() + File.separator;
        String tempLogInfoDir = tempDevDir + (TEMP_DIR + File.separator + devNode.getIp() + devNode.getDeviceSerialNumber() + "logInfoTemp").replace(":", "_");
        String tempLogInfo = tempLogInfoDir + File.separator + LOG_FILE;
        File logInfo = new File(tempLogInfo);
        if (logInfo.exists()) {
            AbstractUserOpDataSev.copyLogInfo((File)logInfo);
            InfoCollectUtil.copyFileToDir(tempLogInfo, devNode);
        } else if (logInfo.mkdirs()) {
            AbstractUserOpDataSev.copyLogInfo((File)logInfo);
            InfoCollectUtil.copyFileToDir(tempLogInfo, devNode);
        }
        String collectRet = collectEnv.get(COLLECT_RET_DIR) + File.separator + collectEnv.get(COLLECT_RET_FILE_NAME);
        if (FileAssistant.compressDirTo7ZFile((String)collectRet, (String)tempLogInfo, (String)"")) {
            return;
        }
        FileAssistant.compressDirTo7ZFile((String)collectRet, (String)tempLogInfo, (String)"-tzip");
        FileUtils.deleteFile((File)new File(tempLogInfoDir));
    }

    public static boolean needModifyConfigurationInfo(com.huawei.ism.tool.obase.entity.DevNode node) {
        return !InfoCollectUtil.isSupportCloudBackup(node) && !InfoCollectUtil.isSupportHyperDetect(node) && !InfoCollectUtil.isSupportDataBackup(node);
    }

    public static boolean isSupportCloudBackup(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        return TaskCons.CLOUD_BACKUP_PRODUCTS.contains(devNode.getDeviceType().toString()) && LicenseFeatureQueryUtil.hasCloudBackupFeature((com.huawei.ism.tool.obase.entity.DevNode)devNode) && InfoCollectUtil.hasContainerAppDeployed(devNode);
    }

    public static boolean isSupportHyperDetect(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        return TaskCons.HYPER_DETECT_PRODUCTS.contains(devNode.getDeviceType().toString()) && Products.compareVersion((String)devNode.getProductVersion(), (String)"6.1.5RC1") >= 0 && LicenseFeatureQueryUtil.hasHyperDetectFeature((com.huawei.ism.tool.obase.entity.DevNode)devNode) && InfoCollectUtil.hasContainerAppDeployed(devNode);
    }

    public static boolean isSupportDataBackup(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        return TaskCons.DATA_BACKUP_PRODUCTS.contains(devNode.getDeviceType().toString()) && Products.compareVersion((String)devNode.getProductVersion(), (String)"1.2.1RC1") >= 0 && LicenseFeatureQueryUtil.hasDataBackupFeature((com.huawei.ism.tool.obase.entity.DevNode)devNode) && InfoCollectUtil.hasContainerAppDeployed(devNode);
    }

    public static boolean isVersionSupportHyperDetect(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        return Products.compareVersion((String)devNode.getProductVersion(), (String)InfoCollectUtil.getHyperDetectCompareVersion(devNode)) >= 0;
    }

    public static String getHyperDetectCompareVersion(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        return TaskCons.OCEAN_PROTECT_X.contains(devNode.getDeviceType().toString()) ? "1.7.RC1" : "6.1.5RC1";
    }

    public static boolean hasContainerAppDeployed(com.huawei.ism.tool.obase.entity.DevNode node) {
        ICliConnection connection = null;
        try {
            connection = SshConnectionManager.getSshConnection((com.huawei.ism.tool.obase.entity.DevNode)node);
            boolean bl = LicenseFeatureQueryUtil.isContainerAppDeployed((ICliConnection)connection);
            return bl;
        }
        catch (ToolException exception) {
            log.error("query container status error", (Throwable)exception);
        }
        finally {
            if (connection != null) {
                SshConnectionManager.releaseConnection((ICliConnection)connection);
            }
        }
        return false;
    }

    public static void waitCheckLicense(com.huawei.ism.tool.obase.entity.DevNode node, Window dialog) {
        ProgressDialog progressDialog = new ProgressDialog(dialog);
        CheckLicenseTask checkLicenseTask = new CheckLicenseTask(node, progressDialog);
        Future checkLicenseFuture = AsyncExcutor.submit((Callable)checkLicenseTask);
        progressDialog.setVisible(true);
        try {
            checkLicenseFuture.get();
        }
        catch (InterruptedException e) {
            log.error("check license future get InterruptedException:", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error("check license future get ExecutionException:", (Throwable)e);
        }
    }

    public static void waitCheckLicense(com.huawei.ism.tool.obase.entity.DevNode node) {
        CheckLicenseTask checkLicenseTask = new CheckLicenseTask(node, null);
        checkLicenseTask.call();
    }

    public static boolean isComputeStorageDevLoginThroughFcv(com.huawei.ism.tool.obase.entity.DevNode dev) {
        return InfoCollectUtil.isComputeStorageDev(dev) && InfoCollectUtil.loginThroughFcv(dev);
    }

    public static boolean loginThroughFcv(com.huawei.ism.tool.obase.entity.DevNode dev) {
        return dev.getIp().equals(dev.getComputeStorageDevNode().getFcvIp());
    }

    public static List<com.huawei.ism.tool.obase.entity.DevNode> getComputeStorageDevs(com.huawei.ism.tool.obase.entity.DevNode dev) {
        ArrayList<com.huawei.ism.tool.obase.entity.DevNode> computeStorageDevs = new ArrayList<com.huawei.ism.tool.obase.entity.DevNode>();
        computeStorageDevs.add(dev);
        computeStorageDevs.addAll(EntityUtils.convertComputeStorageToOldDevNode((com.huawei.ism.tool.obase.entity.DevNode)dev));
        return computeStorageDevs;
    }

    public static boolean isComputeStorageDev(com.huawei.ism.tool.obase.entity.DevNode dev) {
        return Products.isOceanStoComputingDev((String)dev.getDeviceType().toString()) && ItDeviceType.COMPUTE_STORAGE.equals((Object)dev.getStorageDeviceType()) && dev.getComputeStorageDevNode() != null;
    }

    public static String formatTimeMillisToStringData(long timestamp) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(timestamp));
    }

    public static long formatStringDataToTimeMillis(String deviceDate) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(deviceDate).getTime();
        }
        catch (ParseException e) {
            log.error("the deviceDate is error.", (Throwable)e);
            return System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTime(long startTime, String itemName, String ip) {
        String collectionDuration = itemName + SEPARATOR + StringUtils.millls2FormatString((long)(System.currentTimeMillis() - startTime)) + "\r\n";
        String filePath = String.join((CharSequence)File.separator, TEMP_DIR_PATH, IPUtil.ipV6ToPeriod(ip), DURATION_TIME_DATA);
        try {
            LOCK.writeLock().lock();
            org.apache.commons.io.FileUtils.write(new File(filePath), (CharSequence)collectionDuration, StandardCharsets.UTF_8, true);
        }
        catch (IOException e) {
            log.error("Write file error... file path is {}", (Object)filePath, (Object)e);
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    static String mills2FormatString(long duringTimingMills) {
        long seconds = TimeUnit.MILLISECONDS.toSeconds(duringTimingMills);
        return seconds > 0L ? seconds + SECOND : ZERO_SECONDS;
    }

    @SafeVarargs
    public static List<String> getDevsList(List<String> ... devLists) {
        return Arrays.stream(devLists).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static boolean needSavePuStartupScenarioResult(com.huawei.ism.tool.obase.entity.DevNode dev) {
        return CollectDataContext.getInstance().getDevLicenseQueryResultCacheMap().getOrDefault(dev, false) == false && InfoCollectUtil.getDevsList(TaskCons.DATA_BACKUP_PRODUCTS, TaskCons.CLOUD_BACKUP_PRODUCTS, TaskCons.HYPER_DETECT_PRODUCTS).contains(dev.getDeviceType().toString());
    }

    public static void decompressThenCopyDirRecompressAndClear(Map<String, Object> collectEnv, com.huawei.ism.tool.obase.entity.DevNode devNode) {
        String collectRet = collectEnv.get(COLLECT_RET_DIR) + File.separator + collectEnv.get(COLLECT_RET_FILE_NAME);
        if (!collectRet.contains(SEVEN_ZIP_SUFFIX)) {
            return;
        }
        String collectRetDirPath = collectRet.split(SEVEN_ZIP_SUFFIX)[0];
        InfoCollectUtil.decompressThenCopyDirAndRecompress(collectRet, collectRetDirPath, devNode);
        InfoCollectUtil.clearTempDir(new File(collectRetDirPath));
    }

    private static void decompressThenCopyDirAndRecompress(String collectRet, String collectRetDirPath, com.huawei.ism.tool.obase.entity.DevNode devNode) {
        if (!InfoCollectUtil.decompress7ZFile(collectRet, collectRetDirPath) || !InfoCollectUtil.deleteFile(collectRet)) {
            log.error("The folder contains residual files or 7z files cannot be deleted.");
            return;
        }
        InfoCollectUtil.copyDirToFile(devNode, collectRetDirPath);
        InfoCollectUtil.recompress7ZFile(collectRet, collectRetDirPath);
    }

    private static void clearTempDir(File tempDir) {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            LOGGER.error("Thread sleep error");
        }
        if (tempDir.exists()) {
            LOGGER.info("delete temp dir:{}", (Object)tempDir);
            FileUtils.deleteFile((File)tempDir);
            LOGGER.info("delete temp dir end:{}", (Object)tempDir);
        }
    }

    private static void recompress7ZFile(String collectRet, String collectRetDirPath) {
        boolean res = FileAssistant.compressDirTo7ZFile((String)collectRet, (String)(collectRetDirPath + File.separator + "*"), (String)"-t7z");
        LOGGER.info("recompress7ZFile end res:{}", (Object)res);
    }

    public static void copyDirToFile(com.huawei.ism.tool.obase.entity.DevNode devNode, String collectRetDirPath) {
        InfoCollectUtil.copyToolIniToFile(collectRetDirPath);
        if (!InfoCollectUtil.isDmeIqEnv()) {
            InfoCollectUtil.copylogToFile(devNode, collectRetDirPath);
        }
    }

    private static void copylogToFile(com.huawei.ism.tool.obase.entity.DevNode devNode, String collectRetDirPath) {
        String tempLogInfo = collectRetDirPath + File.separator + LOG_FILE;
        File logInfo = new File(tempLogInfo);
        if (!logInfo.exists() && !logInfo.mkdirs()) {
            log.error(" The folder {} does not exist and the file fails to be created.", (Object)LOG_FILE);
            return;
        }
        AbstractUserOpDataSev.copyLogInfo((File)logInfo);
        InfoCollectUtil.copyFileToDir(tempLogInfo, devNode);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            LOGGER.error("Thread sleep error");
        }
    }

    static void copyFileToDir(String tempLogInfo, com.huawei.ism.tool.obase.entity.DevNode devNode) {
        File durationData = new File(String.join((CharSequence)File.separator, TEMP_DIR_PATH, IPUtil.ipV6ToPeriod(devNode.getIp()), DURATION_TIME_DATA));
        if (durationData.exists()) {
            utils.FilesUtil.copyFile((File)durationData, (String)tempLogInfo);
        }
    }

    private static void copyToolIniToFile(String collectRetDirPath) {
        File toolIni = new File(TOOL_INI_PATH);
        if (!toolIni.exists()) {
            log.error("The tool.ini does not exist.");
            return;
        }
        String tempPkginfo = collectRetDirPath + File.separator + PACKAGE_INFO;
        File pkginfo = new File(tempPkginfo);
        if (!pkginfo.exists() && !pkginfo.mkdirs()) {
            log.error(" The folder {} does not exist and the file fails to be created.", (Object)PACKAGE_INFO);
            return;
        }
        utils.FilesUtil.copyFile((File)toolIni, (String)tempPkginfo);
    }

    private static boolean decompress7ZFile(String collectRet, String collectRetDirPath) {
        File collectRetDir = new File(collectRetDirPath);
        if (collectRetDir.exists() && !FileAssistant.delDirAndFile((String)collectRetDirPath)) {
            log.error("The folder has residue.");
            return false;
        }
        return FileAssistant.deCopmressAllZipFile((String)collectRetDirPath, (String)collectRet);
    }

    private static boolean deleteFile(String collectRet) {
        File file = new File(collectRet);
        int retryTimes = 0;
        while (!file.delete()) {
            if (retryTimes > 3) {
                return false;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                log.error("Thread sleep error");
            }
            log.info("{}st retry, delete {} file.", (Object)retryTimes++, (Object)file.getName());
        }
        return true;
    }

    public static boolean isSupportCollectedByScene(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        return (CollectDataContext.getInstance().isStorageCollectSec() || InfoCollectUtil.isSupportA800Scene()) && InfoCollectUtil.isDevicesCollectedByScene(devNode);
    }

    public static boolean isDevicesCollectedByScene(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        String version;
        String devType = devNode.getDeviceType().toString();
        return InfoCollectUtil.isDorado616(devType, version = devNode.getProductVersion()) || InfoCollectUtil.isOceanProtect130(devType, version) || InfoCollectUtil.isOceanDisk(devType, version);
    }

    public static boolean isOceanDisk(String devType, String version) {
        return Products.isOceanStorMicroDev((String)devType) && Products.compareVersion((String)version, (String)"1.2.RC1") >= 0;
    }

    public static boolean isOceanProtect130(String devType, String version) {
        return TaskCons.OCEAN_PROTECT_X.contains(devType) && Products.compareVersion((String)version, (String)"1.3.RC1") >= 0;
    }

    public static boolean isDorado616(String devType, String version) {
        return TaskCons.DORADO_AND_NEW_DORADO_MODEL.contains(devType) && Products.compareVersion((String)version, (String)"6.1.6RC1") >= 0;
    }

    public static boolean usrConfirmRiskProcedure(String warningStr) {
        log.info("pop up collection risk warning dialog !");
        ConfirmationWithSignDialog signialog = new ConfirmationWithSignDialog(warningStr);
        signialog.setVisible(true);
        if (signialog.getResultValue() == 0) {
            log.info("detected user confirmed this operation!");
            return true;
        }
        log.info("detected user canceled this operation!");
        return false;
    }

    public static boolean isDiskTreeMapEmptyOrNull(Integer diskInt, TreeMap<DiskLocation, Disk> diskTreeMap) {
        return diskInt == null || VerifyUtil.isEmpty(diskTreeMap);
    }

    public static boolean isNewOceanStor9000(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        String version;
        String devType = devNode.getDeviceType().toString();
        return InfoCollectUtil.isSpecifiedOceanStor9000(devType, version = devNode.getProductVersion()) || InfoCollectUtil.isSpecifiedFusionStorageFile(devType, version);
    }

    public static boolean isSpecifiedFusionStorageFile(String devType, String version) {
        return Objects.equals("FusionStorage File", devType) && Products.compareVersion((String)version, (String)"V100R006C30SPC900") >= 0;
    }

    public static boolean isSpecifiedOceanStor9000(String devType, String version) {
        return Objects.equals("OceanStor 9000 Series", devType) && Products.compareVersion((String)version, (String)"7.1.1") >= 0;
    }

    public static String getDateString(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date(devNode.getDevCurrentTime()));
    }

    public static boolean isEosProducts(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        return NO_MODIFY_PRODUCTS.stream().anyMatch(productVersion -> devNode.getProductVersion().startsWith((String)productVersion));
    }

    public static void queryAndSaveDeviceCurDate(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        String path = CollectDeviceService.getInstance().getDateScriptPath(devNode);
        if (com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)path)) {
            log.warn("The device({}) does not have a script for querying the device time.", (Object)devNode.getIp());
            return;
        }
        devNode.setDevCurrentTime(InfoCollectUtil.formatStringDataToTimeMillis(InfoCollectService.getInstance().getDevCurDate(devNode, path)));
    }

    public static JComponent createErrorInfoPanel(String msg) {
        JLabel errmsg = new JLabel("<html>" + msg + "</html>", 0);
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        listPanel.add((Component)UiMethod.buildFrameSpace((JComponent)errmsg, (int)12), "North");
        JScrollPane srollPanel = new JScrollPane(listPanel);
        srollPanel.setHorizontalScrollBarPolicy(30);
        srollPanel.setVerticalScrollBarPolicy(20);
        return srollPanel;
    }

    public static Map<String, String> adjustText(File selectFile, int maxLength) {
        String name = selectFile.getName();
        HashMap<String, String> textInfos = new HashMap<String, String>();
        if (name.length() > maxLength) {
            textInfos.put(TEXT, name.substring(0, maxLength - 3) + "...");
            textInfos.put(TOOL_TIP_TEXT, name);
        } else {
            textInfos.put(TEXT, name);
            textInfos.put(TOOL_TIP_TEXT, "");
        }
        log.info("textInfos is: {}", textInfos);
        return textInfos;
    }

    public static void clearTempTimeData(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        File timeDateFile = new File(String.join((CharSequence)File.separator, TEMP_DIR_PATH, TEXT, IPUtil.ipV6ToPeriod(devNode.getIp())));
        log.info("start clear temp file. {}", (Object)timeDateFile.getName());
        if (timeDateFile.exists()) {
            FileUtils.deleteFile((File)timeDateFile);
        }
    }

    public static boolean isDmeIqEnv() {
        return CLOUD_SERVICE.equals(System.getenv("callTool"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasRecordDeviceSn(String sn) {
        Object object = LOCAL_RECORD_SN_LOCK;
        synchronized (object) {
            File file = LOCAL_RECORD_COLLECT_HISTORY_FILE;
            if (!file.exists() || file.isDirectory()) {
                return false;
            }
            try (Stream<String> stream = Files.lines(file.toPath(), StandardCharsets.UTF_8);){
                boolean bl = stream.anyMatch(line -> Objects.equals(line, sn));
                return bl;
            }
            catch (IOException e) {
                LOGGER.error("read file failed, file path is {}", (Object)utils.FilesUtil.getCanonicalPath((File)file), (Object)e);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void localRecordDeviceSn(String sn) {
        Object object = LOCAL_RECORD_SN_LOCK;
        synchronized (object) {
            if (InfoCollectUtil.hasRecordDeviceSn(sn)) {
                return;
            }
            try {
                org.apache.commons.io.FileUtils.write(LOCAL_RECORD_COLLECT_HISTORY_FILE, (CharSequence)sn.concat(System.lineSeparator()), StandardCharsets.UTF_8, true);
            }
            catch (IOException e) {
                LOGGER.error("local record the device sn {} failed", (Object)sn, (Object)e);
            }
        }
    }

    public static boolean isA800Zone(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        return Optional.ofNullable(devNode).map(com.huawei.ism.tool.obase.entity.DevNode::getDeviceType).map(Object::toString).filter(deviceType -> Objects.equals(deviceType, ItDeviceType.A800_NODE.getName())).isPresent();
    }

    public static boolean isA800Om(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        return Optional.ofNullable(devNode).map(com.huawei.ism.tool.obase.entity.DevNode::getDeviceType).map(Object::toString).filter(deviceType -> Objects.equals(deviceType, ItDeviceType.A800_OM.getName())).isPresent();
    }

    public static boolean isSupportA800Scene() {
        return SceneUtils.isScene() && SceneUtils.isSpecialScence((String)System.getenv(SCENE_INFO_KEY), (String[])new String[]{TROUBLE_SHOOTING_MAIN_SCENE}) && SceneUtils.isSpecialScence((String)SceneUtils.getCurrentSubScene(), (String[])new String[]{A800_SUB_SCENE});
    }

    public static boolean isSupportUpgradeCollect() {
        return Boolean.parseBoolean(CollectConfigParser.getConfigureValue("isSupportUpgradeCollect", "false").trim());
    }
}

