/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.util;

import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.infocollect.util.JythonExecuteResult;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JythonUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JythonUtil.class);

    private JythonUtil() {
    }

    public static JythonExecuteResult executeOneBooleanReturnValueScript(String scriptPath, String method, Map paramsMap) {
        try {
            JythonExecuter jythonExecuter = new JythonExecuter();
            File pyFile = new File(scriptPath);
            jythonExecuter.compileScript(pyFile);
            Object ret = jythonExecuter.simpleInvokeFunction(method, paramsMap);
            return new JythonExecuteResult(true, (Boolean)ret);
        }
        catch (SignException e) {
            LOGGER.error("SignException.");
            return new JythonExecuteResult(false);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file is not exists.");
            return new JythonExecuteResult(false);
        }
        catch (ToolException e) {
            LOGGER.error("Execute script ToolException.", (Throwable)e);
            return new JythonExecuteResult(false);
        }
        catch (Exception e) {
            LOGGER.error("Execute script Exception.", (Throwable)e);
            return new JythonExecuteResult(false);
        }
    }
}

