/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.Bond;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.IpAddress;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.IscsiNode;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.NetWorkType;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.NetworkPlatform;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.NodeInfo;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.PhysicalPort;
import com.huawei.ism.tool.infocollect.service.logic.lld.entity.Vlan;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.json.JSONUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.net.util.IPAddressUtil;

public class NetworkUtil {
    private static final Logger log = LoggerFactory.getLogger(NetworkUtil.class);
    private static final String NETWORK_PLATFORM = "/api/v2/network_service/network_platform";
    private static final String ISCSI_LIST = "/dsware/service/cluster/dswareclient/queryIscsiPortal";
    private static final String IPV4 = "ipv4";
    private static final String IPV6 = "ipv6";
    private static final String[] BLOCK_GATEWAY = new String[]{"0.0.0.0", "::", "::/0", "::/1"};

    public static List<NetworkPlatform> getStorageNetWorkPlatform(DevNode devNode, NodeInfo nodeInfo, NetWorkType netWorkType) {
        try {
            String responseInfo = NetworkUtil.getNetworkPlatformInfo(devNode, netWorkType);
            NetworkPlatform baseNetworkPlatformInform = (NetworkPlatform)JSON.parseObject((String)responseInfo, NetworkPlatform.class);
            List<IpAddress> ipAddressByNetType = NetworkUtil.getIpAddressesByNetType(nodeInfo.getIpAddresses(), netWorkType);
            return ipAddressByNetType.stream().map(ipAddress -> NetworkUtil.buildStorageNetworkPlatform(nodeInfo, ipAddress, baseNetworkPlatformInform)).collect(Collectors.toList());
        }
        catch (ToolException e) {
            log.warn("get storage net work info  failed");
            return Collections.emptyList();
        }
    }

    public static List<NetworkPlatform> getIscsiNetWorkPlatform(DevNode devNode, NodeInfo nodeInfo, NetWorkType netWorkType) {
        try {
            List<IpAddress> iscsiNodeIpAddress = NetworkUtil.getIpAddresses(devNode, nodeInfo);
            String responseInfo = NetworkUtil.getNetworkPlatformInfo(devNode, netWorkType);
            NetworkPlatform baseNetworkPlatformInform = (NetworkPlatform)JSON.parseObject((String)responseInfo, NetworkPlatform.class);
            return iscsiNodeIpAddress.stream().map(ipAddress -> NetworkUtil.buildStorageNetworkPlatform(nodeInfo, ipAddress, baseNetworkPlatformInform)).collect(Collectors.toList());
        }
        catch (ToolException e) {
            log.warn("get iscsi info failed");
            return Collections.emptyList();
        }
    }

    private static List<IpAddress> getIpAddresses(DevNode devNode, NodeInfo nodeInfo) throws ToolException {
        IscsiNode iscsiNode = (IscsiNode)JSON.parseObject((String)NetworkUtil.getIscsiNodes(devNode), IscsiNode.class);
        return nodeInfo.getIpAddressByIscsiNode(iscsiNode);
    }

    private static List<IpAddress> getIpAddressesByNetType(List<IpAddress> ipAddresses, NetWorkType netWorkType) {
        return ipAddresses.stream().filter(ipAddress -> ipAddress.isNetWorkType(netWorkType)).collect(Collectors.toList());
    }

    private static String getNetworkPlatformInfo(DevNode devNode, NetWorkType netWorkType) throws ToolException {
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)devNode);
        if (restConnection == null) {
            log.info("Failed to obtain the connection.");
            throw new ToolException("collection error");
        }
        String baseUri = RestUtil.getDstorageBaseUrlNoV2((DevNode)devNode);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("network_type", netWorkType.getNetworkType());
        ResponseInfo responseInfo = restConnection.execGet(baseUri + NETWORK_PLATFORM, param);
        Object data = JSON.parseObject((String)responseInfo.getContent()).get((Object)"data");
        return JSONUtils.toJson((Object)data);
    }

    private static String getIscsiNodes(DevNode devNode) throws ToolException {
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)devNode);
        if (restConnection == null) {
            log.info("Failed to obtain the connection.");
            throw new ToolException("collection error");
        }
        String baseUri = RestUtil.getDstorageBaseUrlNoV2((DevNode)devNode);
        ResponseInfo responseInfo = restConnection.execPost(baseUri + ISCSI_LIST, new HashMap());
        JSONObject data = JSON.parseObject((String)responseInfo.getContent());
        return JSONUtils.toJson((Object)data);
    }

    public static String findMatchVlanTag(IpAddress ipAddress, List<Vlan> vlans) {
        if (ipAddress == null || CollectionUtil.isEmpty(vlans)) {
            return "";
        }
        return vlans.stream().filter(vlan -> vlan.getVlanName().equals(ipAddress.getPortName())).findFirst().map(vlan -> String.valueOf(vlan.getVlanTag())).orElse("");
    }

    public static Optional<IpAddress> getIpAddressByNetType(List<IpAddress> ipAddresses, NetWorkType netWorkType) {
        return ipAddresses.stream().filter(ipAddress -> ipAddress.isNetWorkType(netWorkType)).findFirst();
    }

    public static Optional<Bond> getBondByPortName(List<Bond> bonds, String portName) {
        return bonds.stream().filter(bond -> portName.equals(bond.getBondName())).findFirst();
    }

    public static String getSpeedByPortName(List<Vlan> vlans, String portName) {
        if (CollectionUtil.isEmpty(vlans) || portName == null) {
            return "";
        }
        return vlans.stream().filter(vlan -> portName.equals(vlan.getVlanName())).findFirst().map(Vlan::getSpeed).orElse("");
    }

    public static String getSpeedByBondName(List<PhysicalPort> physicalPorts, Bond bond) {
        String bondPortName = bond.getBondPorts().stream().filter(port -> "MASTER".equalsIgnoreCase(port.getPortRole())).findFirst().map(PhysicalPort::getPortName).orElse("");
        return physicalPorts.stream().filter(physicalPort -> bondPortName.equals(physicalPort.getPortName())).findFirst().map(PhysicalPort::getCurrentSpeed).orElse("");
    }

    public static String changePrefixToMask(IpAddress ipAddress) {
        if (ipAddress == null) {
            return "";
        }
        if (ipAddress.getSubnetPrefix() != null && NetworkUtil.checkIsSubnetMaskV4(ipAddress.getSubnetPrefix())) {
            return ipAddress.getSubnetPrefix();
        }
        if (!IPAddressUtil.isIPv4LiteralAddress(ipAddress.getIpAddress())) {
            return ipAddress.getSubnetPrefix();
        }
        return NetworkUtil.calcMaskByPrefixLength(ipAddress.getSubnetPrefix());
    }

    private static boolean checkIsSubnetMaskV4(String subnetPrefix) {
        try {
            Integer.parseInt(subnetPrefix);
            return false;
        }
        catch (NumberFormatException e) {
            return NetUtil.isSubnetMaskV4((String)subnetPrefix);
        }
    }

    public static String calcMaskByPrefixLength(String subnetPrefix) {
        if (StringUtils.isNULLStr((String)subnetPrefix)) {
            return "";
        }
        int mask = -1 << 32 - Integer.parseInt(subnetPrefix);
        int bitsOfPart = 8;
        int[] maskParts = new int[4];
        int selector = 255;
        IntStream.range(0, maskParts.length).forEach(index -> {
            int pos = maskParts.length - 1 - index;
            maskParts[pos] = mask >> index * bitsOfPart & selector;
        });
        return Arrays.stream(maskParts).mapToObj(String::valueOf).collect(Collectors.joining("."));
    }

    public static NetworkPlatform buildStorageNetworkPlatform(NodeInfo nodeInfo, IpAddress ipAddress, NetworkPlatform baseNetworkPlatform) {
        NetworkPlatform networkPlatform = new NetworkPlatform();
        if (ipAddress.isShareIp() && NetWorkType.STORAGE_BACKEND.getNetworkType().equals(baseNetworkPlatform.getNetworkType())) {
            return networkPlatform;
        }
        networkPlatform.setNetworkType(baseNetworkPlatform.getNetworkType());
        networkPlatform.setBondMode(nodeInfo.getBondModeByPortName(ipAddress.getPortName()));
        networkPlatform.setTransferProtocol(baseNetworkPlatform.getTransferProtocol());
        networkPlatform.setMultiIp(baseNetworkPlatform.isMultiIp());
        networkPlatform.setPortName(ipAddress.getPortName());
        networkPlatform.setIpAddress(ipAddress.getIpAddress());
        networkPlatform.setIpVersion(NetworkUtil.getIpVersion(networkPlatform.getIpAddress()));
        networkPlatform.setGateway(ipAddress.getDefaultGateway());
        networkPlatform.setVlan(NetworkUtil.findMatchVlanTag(ipAddress, nodeInfo.getVlans()));
        networkPlatform.setSubnetPrefix(NetworkUtil.changePrefixToMask(ipAddress));
        NetworkUtil.setSpeed(nodeInfo, ipAddress, networkPlatform);
        return networkPlatform;
    }

    private static void setSpeed(NodeInfo nodeInfo, IpAddress ipAddress, NetworkPlatform networkPlatform) {
        Optional<Bond> bond = NetworkUtil.getBondByPortName(nodeInfo.getBonds(), ipAddress.getPortName());
        if (bond.isPresent()) {
            networkPlatform.setSpeed(NetworkUtil.getSpeedByBondName(nodeInfo.getPhysicalPorts(), bond.get()));
            networkPlatform.setPortNum(String.valueOf(bond.get().getBondPorts().size()));
        }
        if (!StringUtils.isNULLStr((String)networkPlatform.getVlan())) {
            networkPlatform.setSpeed(NetworkUtil.getSpeedByPortName(nodeInfo.getVlans(), ipAddress.getPortName()));
        }
        NetworkUtil.getPhysicalPortByPortName(nodeInfo.getPhysicalPorts(), ipAddress.getPortName()).ifPresent(physicalPort -> networkPlatform.setSpeed(physicalPort.getCurrentSpeed()));
    }

    private static Optional<PhysicalPort> getPhysicalPortByPortName(List<PhysicalPort> physicalPorts, String portName) {
        return physicalPorts.stream().filter(physicalPort -> physicalPort.getPortName().equals(portName)).findFirst();
    }

    private static String getIpVersion(String ipAddress) {
        return IPAddressUtil.isIPv4LiteralAddress(ipAddress) ? IPV4 : IPV6;
    }

    public static String transferGateWay(String gateWay) {
        if (gateWay == null || Arrays.stream(BLOCK_GATEWAY).anyMatch(block -> block.equalsIgnoreCase(gateWay))) {
            return "";
        }
        return gateWay;
    }

    private NetworkUtil() {
    }
}

