/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.util;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.infocollect.util.FilesUtil;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.in.ComponentDefine;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageUtils {
    private static final Logger log = LoggerFactory.getLogger(PackageUtils.class);
    public static final String POINT_TAR_POINT_BZ2 = ".tar.bz2";
    public static final String POINT_RAR = ".rar";
    public static final String UNDERLINE_TMP = "_tmp";
    public static final String POINT_BZ2 = ".bz2";
    public static final String POINT_TGZ = ".tgz";
    public static final String POINT_TAR = ".tar";
    public static final String POINT_ZIP = ".zip";
    public static final String POINT_7Z = ".7z";
    public static final String UTILS = "utils";
    public static final int NUMBER_1 = 1;
    public static final String MESSAGEZIP = "msg_other.zip";
    public static final String ERROR = "error";
    private static final Logger LOGGER = LoggerFactory.getLogger(PackageUtils.class);
    private static final String POINT = ".";
    private static final int NUMBER_0 = 0;
    private static final String NULL_X_NULL = " x ";
    private static final String NULL_LINE_O = " -o";
    private static final String NULL_LINE_Y = " -y";
    private static final String NULL_LINE_P = " -p";
    private static final String SYSTEM_LOG = "system_log";
    private static final int TIME_OUT = 60;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String deCompressPackage(String packagePath, String blackList, String[] pwds) {
        Class<PackageUtils> clazz = PackageUtils.class;
        synchronized (PackageUtils.class) {
            String lowerBlackList = null == blackList ? "" : blackList.toLowerCase(Locale.US);
            File originalFile = new File(packagePath);
            if (!originalFile.exists()) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return "";
            }
            String dir = originalFile.getName();
            String collectPath = originalFile.getParent() + File.separator + dir.substring(0, dir.lastIndexOf(POINT));
            File dataCollectFile = new File(collectPath);
            if (!dataCollectFile.exists() && !dataCollectFile.mkdirs()) {
                LOGGER.error("Create dir error.file path: " + collectPath);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return "";
            }
            PackageUtils.deCopmressTotalZipFile(collectPath, packagePath, pwds);
            PackageUtils.deCompressAllFilesRecu(dataCollectFile, lowerBlackList, pwds);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return collectPath;
        }
    }

    public static boolean executeCmd(String cmd, boolean log) {
        String result = null;
        try {
            LOGGER.info("Execute command {}", (Object)cmd);
            result = OSCmdUtils.executeCmd((String)cmd, (int)60);
        }
        catch (Exception e) {
            LOGGER.error("Execute " + cmd + " error: ", (Throwable)e);
            return false;
        }
        LOGGER.info("Execute command over{}", (Object)cmd);
        LOGGER.info("executeCmd result: {}", (Object)result);
        return null != result && !result.toLowerCase(Locale.ENGLISH).contains(ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compressPackage(String collectPath) {
        Class<PackageUtils> clazz = PackageUtils.class;
        synchronized (PackageUtils.class) {
            if (null == collectPath || "".equals(collectPath)) {
                LOGGER.error("Collect path connot be null!");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return "";
            }
            File file = new File(collectPath);
            if (!file.exists()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return "";
            }
            String z7ResultFile = collectPath + POINT_7Z;
            File now = new File(collectPath);
            if (!now.exists()) {
                LOGGER.error("Collect path connot be null!");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return "";
            }
            String[] here = null;
            if (now.isDirectory()) {
                here = now.list();
            }
            if (null == here) {
                LOGGER.error("Cannot get file array!");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return "";
            }
            String[] own = new String[here.length];
            for (int i = 0; i < here.length; ++i) {
                own[i] = collectPath + File.separator + here[i];
            }
            FileAssistant.compressFile7z((String)z7ResultFile, (String[])own);
            File z7Result = new File(z7ResultFile);
            if (z7Result.exists()) {
                try {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return z7Result.getCanonicalPath();
                }
                catch (Exception e) {
                    LOGGER.error("", (Throwable)e);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return "";
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return "";
        }
    }

    private static void deCompressAllFilesRecu(File dataCollectFile, String blackList, String[] pwds) {
        if (blackList.contains(dataCollectFile.getName().toLowerCase(Locale.US))) {
            return;
        }
        File[] files = dataCollectFile.listFiles();
        if (null == files || 0 == files.length) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) continue;
            PackageUtils.validAndDeCompress(file, pwds, true);
        }
        files = dataCollectFile.listFiles();
        if (null == files || 0 == files.length) {
            return;
        }
        PackageUtils.decompressSystemLog(pwds, blackList, files);
        PackageUtils.decompressMesg(pwds, files);
    }

    private static void decompressMesg(String[] pwds, File[] files) {
        for (File file : files) {
            if (!file.isDirectory() || !SYSTEM_LOG.equalsIgnoreCase(file.getName())) continue;
            File[] fileArray = file.listFiles();
            if (null == fileArray) {
                LOGGER.info("file in SYSTEM_LOG is null!");
                return;
            }
            for (File file2 : fileArray) {
                PackageUtils.deCompressMsglog(file2, pwds);
            }
        }
    }

    private static void decompressSystemLog(String[] pwds, String blackList, File[] files) {
        for (File file : files) {
            if (!file.isDirectory() || utils.FilesUtil.getCanonicalPath((File)file).endsWith("Messages")) continue;
            if (SYSTEM_LOG.equalsIgnoreCase(file.getName())) {
                PackageUtils.deCompressSystemlog(file, pwds);
                continue;
            }
            PackageUtils.deCompressAllFilesRecu(file, blackList, pwds);
        }
    }

    private static void deCompressMsglog(File file, String[] pwds) {
        if (!file.isDirectory()) {
            return;
        }
        File[] files = file.listFiles();
        if (null == files) {
            LOGGER.info("file in {} is null!", (Object)utils.FilesUtil.getCanonicalPath((File)file));
            return;
        }
        for (File fileTmp : files) {
            if (!fileTmp.getName().endsWith(MESSAGEZIP)) continue;
            LOGGER.info("Start to decompress file : {}", (Object)utils.FilesUtil.getCanonicalPath((File)file));
            try {
                PackageUtils.deCopmressTotalZipFile(fileTmp.getParent(), fileTmp.getCanonicalPath(), pwds);
            }
            catch (IOException e) {
                LOGGER.error("get path error.", (Throwable)e);
            }
            boolean deleteFileTmpResult = fileTmp.delete();
            if (deleteFileTmpResult) continue;
            LOGGER.error("Delete dir error.file path: " + utils.FilesUtil.getCanonicalPath((File)fileTmp));
        }
        File[] files2 = file.listFiles();
        if (null == files2) {
            LOGGER.info("file in {} is null!", (Object)utils.FilesUtil.getCanonicalPath((File)file));
            return;
        }
        for (File fileTmp : files2) {
            if (!fileTmp.getName().endsWith(POINT_BZ2)) continue;
            PackageUtils.decompressByType(pwds, fileTmp, POINT_BZ2);
        }
    }

    private static void decompressByType(String[] pwds, File fileTmp, String fileType) {
        String collectPath = fileTmp.getParent();
        File tmpFile = null;
        boolean deleteFileTmpResult = false;
        if (utils.FilesUtil.getCanonicalPath((File)fileTmp).endsWith(fileType)) {
            String tmpFileStr = collectPath + UNDERLINE_TMP;
            tmpFile = new File(tmpFileStr);
            if (!tmpFile.exists() && !tmpFile.mkdirs()) {
                LOGGER.error("Create dir error.file path: " + collectPath);
                return;
            }
            PackageUtils.deCopmressTmpFile(fileTmp, pwds, collectPath, tmpFile);
            deleteFileTmpResult = fileTmp.delete();
            if (!deleteFileTmpResult) {
                LOGGER.error("Delete dir error.file path: " + fileTmp);
            }
        }
    }

    private static void deCompressSystemlog(File file, String[] pwds) {
        File[] files = file.listFiles();
        if (null == files) {
            LOGGER.info("file in {} is null!", (Object)utils.FilesUtil.getCanonicalPath((File)file));
            return;
        }
        for (File fileTmp : files) {
            if (utils.FilesUtil.getCanonicalPath((File)fileTmp).endsWith(POINT_TGZ)) {
                try {
                    PackageUtils.deCopmressTotalZipFile(fileTmp.getParent(), fileTmp.getCanonicalPath(), pwds);
                }
                catch (IOException e) {
                    LOGGER.error("get path error.", (Throwable)e);
                }
                boolean deleteFileTmpResult = fileTmp.delete();
                if (deleteFileTmpResult) continue;
                LOGGER.error("Delete dir error.file path: " + utils.FilesUtil.getCanonicalPath((File)fileTmp));
                continue;
            }
            LOGGER.info("tarFilePath is : {} do not decompress!", (Object)utils.FilesUtil.getCanonicalPath((File)fileTmp));
        }
        files = file.listFiles();
        if (null == files) {
            LOGGER.info("file in {} is null!", (Object)utils.FilesUtil.getCanonicalPath((File)file));
            return;
        }
        PackageUtils.decompressControllerLog(pwds, files);
    }

    static void decompressControllerLog(String[] pwds, File[] files) {
        List filesTmp = Arrays.stream(files).filter(file -> utils.FilesUtil.getCanonicalPath((File)file).endsWith(POINT_BZ2) || utils.FilesUtil.getCanonicalPath((File)file).endsWith(POINT_TAR)).collect(Collectors.toList());
        for (File fileTmp : filesTmp) {
            String dir = fileTmp.getName();
            String collectPath = String.join((CharSequence)File.separator, fileTmp.getParent(), dir.substring(0, dir.indexOf(POINT)));
            File tmpFile = new File(collectPath + UNDERLINE_TMP);
            if (!tmpFile.exists() && !tmpFile.mkdirs()) {
                log.error("Create dir error.file path: {}", (Object)collectPath);
                return;
            }
            PackageUtils.deCopmressTmpFile(fileTmp, pwds, collectPath, tmpFile);
            if (!fileTmp.delete()) continue;
            log.error("Delete dir error.file path: {}", filesTmp);
        }
    }

    private static void validAndDeCompress(File tarFilePath, String[] pwds, boolean check) {
        String suffix = utils.FilesUtil.getCanonicalPath((File)tarFilePath);
        if (check && tarFilePath.getParent().endsWith("Messages")) {
            return;
        }
        if (suffix.endsWith(POINT_TAR_POINT_BZ2)) {
            FileAssistant.deCompressTarbz2File((String)tarFilePath.getParent(), (String)utils.FilesUtil.getCanonicalPath((File)tarFilePath));
            if (!FileAssistant.delFile((String)utils.FilesUtil.getCanonicalPath((File)tarFilePath))) {
                LOGGER.error("Delete zip file error.Dir path : " + tarFilePath.getName());
            }
        } else if (suffix.endsWith(POINT_TGZ) || suffix.endsWith(POINT_ZIP) || suffix.endsWith(POINT_RAR) || suffix.endsWith(POINT_BZ2) || suffix.endsWith(POINT_TAR)) {
            PackageUtils.deCompressFile(tarFilePath, pwds);
        }
    }

    private static void deCompressFile(File tarFilePath, String[] pwds) {
        String tmpFileStr;
        if (null == tarFilePath) {
            return;
        }
        String dir = tarFilePath.getName();
        String collectPath = tarFilePath.getParent() + File.separator + dir.substring(0, dir.lastIndexOf(POINT));
        File tmpFile = null;
        if (utils.FilesUtil.getCanonicalPath((File)tarFilePath).endsWith(POINT_TGZ) && !(tmpFile = new File(tmpFileStr = collectPath + UNDERLINE_TMP)).exists() && !tmpFile.mkdirs()) {
            LOGGER.error("Create dir error.file path: " + collectPath);
            return;
        }
        File dataCollectFile = new File(collectPath);
        if (!dataCollectFile.exists() && !dataCollectFile.mkdirs()) {
            LOGGER.error("Create dir error.file path: " + collectPath);
            return;
        }
        if (tmpFile != null) {
            PackageUtils.deCopmressTmpFile(tarFilePath, pwds, collectPath, tmpFile);
        } else {
            PackageUtils.deCopmressTotalZipFile(collectPath, utils.FilesUtil.getCanonicalPath((File)tarFilePath), pwds);
        }
        boolean succ = false;
        try {
            succ = tarFilePath.delete();
        }
        catch (Exception e) {
            LOGGER.error("delete File error", (Throwable)e);
        }
        if (!succ) {
            LOGGER.error("Delete file " + utils.FilesUtil.getCanonicalPath((File)tarFilePath) + " error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String deCopmressTotalZipFile(String targetWithPath, String zipFilePath, String[] pwds) {
        Class<PackageUtils> clazz = PackageUtils.class;
        synchronized (PackageUtils.class) {
            if (StringUtils.hasNULLStr((String[])new String[]{targetWithPath, zipFilePath})) {
                LOGGER.info("path is null.");
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            if (!FileUtils.fileSize2GInvalid((File)new File(zipFilePath))) {
                LOGGER.info("the file size is over 2G. {}", (Object)zipFilePath);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            for (String pwd : pwds) {
                StringBuilder cmd = new StringBuilder().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(NULL_X_NULL).append(ComponentDefine.getMarks()).append(zipFilePath).append(ComponentDefine.getMarks()).append(NULL_LINE_O).append(ComponentDefine.getMarks()).append(targetWithPath).append(ComponentDefine.getMarks()).append(NULL_LINE_Y).append(NULL_LINE_P).append(pwd);
                if (PackageUtils.executeCmd(cmd.toString(), true)) break;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return targetWithPath;
        }
    }

    static void deCopmressTmpFile(File tarFilePath, String[] pwds, String collectPath, File tmpFile) {
        if (null == tmpFile) {
            return;
        }
        try {
            if (PackageUtils.isTarControllerFile(tarFilePath)) {
                FilesUtil.copyFile(tarFilePath, utils.FilesUtil.getCanonicalPath((File)tmpFile));
            } else {
                PackageUtils.deCopmressTotalZipFile(tmpFile.getCanonicalPath(), tarFilePath.getCanonicalPath(), pwds);
            }
            File[] files = tmpFile.listFiles();
            if (null == files || 0 == files.length) {
                return;
            }
            if (1 == files.length) {
                String fileName = files[0].getName();
                if (!files[0].isDirectory() && tarFilePath.getName().contains(fileName.substring(0, fileName.lastIndexOf(POINT)))) {
                    PackageUtils.deCopmressTotalZipFile(collectPath, files[0].getCanonicalPath(), pwds);
                    if (!files[0].delete()) {
                        LOGGER.error("Delete file " + files[0].getName() + " error");
                    }
                } else {
                    FileUtils.copyDir((String)tmpFile.getCanonicalPath(), (String)collectPath);
                    FileUtils.deleteAllInFolder((String)tmpFile.getCanonicalPath());
                }
            } else {
                FileUtils.copyDir((String)tmpFile.getCanonicalPath(), (String)collectPath);
                FileUtils.deleteAllInFolder((String)tmpFile.getCanonicalPath());
            }
        }
        catch (IOException e) {
            LOGGER.error("get file path error.", (Throwable)e);
        }
        boolean succ = false;
        try {
            succ = tmpFile.delete();
        }
        catch (Exception e) {
            LOGGER.error("delete File error", (Throwable)e);
        }
        if (!succ) {
            LOGGER.error("Delete file " + tmpFile.getName() + " error");
        }
    }

    static boolean isTarControllerFile(File tarFilePath) {
        String filePath = utils.FilesUtil.getCanonicalPath((File)tarFilePath);
        return filePath.toLowerCase(Locale.ENGLISH).contains(SYSTEM_LOG) && filePath.endsWith(POINT_TAR);
    }
}

