/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.util;

import com.alibaba.fastjson.JSON;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.json.JSONException;
import java.util.HashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryInfoUtil {
    private static final Logger log = LoggerFactory.getLogger(QueryInfoUtil.class);
    private static final String SERVICE_TYPE = "/api/v2/deploy_manager/solution_scenario";

    public static String queryDevServiceTypeInfo(DevNode devNode) {
        try {
            return QueryInfoUtil.getResponseInfo(devNode, SERVICE_TYPE).map(QueryInfoUtil::getServiceTypeFromResponseInfo).orElse("");
        }
        catch (ToolException | JSONException e) {
            log.warn("get [{}] service type failed", (Object)devNode.getIp());
            return "";
        }
    }

    private static String getServiceTypeFromResponseInfo(ResponseInfo responseInfo) {
        return Optional.ofNullable(responseInfo.getContent()).map(JSON::parseObject).map(content -> content.getString("data")).map(JSON::parseObject).map(data -> data.getString("solution_scenario")).orElse("");
    }

    private static Optional<ResponseInfo> getResponseInfo(DevNode devNode, String url) throws ToolException, JSONException {
        RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)devNode);
        if (restConnection == null) {
            log.info("Failed to obtain the connection.");
            return Optional.empty();
        }
        String baseUri = RestUtil.getDstorageBaseUrlNoV2((DevNode)devNode);
        HashMap param = new HashMap();
        return Optional.ofNullable(restConnection.execGet(baseUri + url, param));
    }

    private QueryInfoUtil() {
    }
}

