/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.util;

import com.alibaba.fastjson.JSON;
import com.huawei.ism.tool.infocollect.util.InfoCollectUtil;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.json.JSONException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryUpgradeStates {
    private static final Logger log = LoggerFactory.getLogger(QueryUpgradeStates.class);
    private static final Pattern PATTERN = Pattern.compile("upgrade:/>");
    private static final String STATUS_KEY = "CMO_UPD_SYS_STEP_TASK_STATUS";
    private static final String RESTFUL = "/OM_MSG_OP_UPD_LST_SYS_PROGRESS?CMO_QUERY_TYPE=1";
    private static final List<Integer> STATUS_WHICH_ALLOW_COLLECT = Arrays.asList(3, 6, 9, 12, 15, 18, 20, 21, 27);

    private static String getRequestUrl(DevNode devNode) {
        return RestUtil.getBaseUri((DevNode)devNode) + RESTFUL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ResponseInfo getResponseInfo(DevNode devNode) {
        try (RestConnection restConnection = RestConnectionManager.getRestConnection((DevNode)devNode);){
            if (restConnection == null) {
                log.error("Failed to obtain the connection.");
                ResponseInfo responseInfo2 = new ResponseInfo();
                return responseInfo2;
            }
            ResponseInfo responseInfo = restConnection.execGet(QueryUpgradeStates.getRequestUrl(devNode));
            return responseInfo;
        }
        catch (Exception e) {
            log.error("Failed to close the connection.", (Throwable)e);
            return new ResponseInfo();
        }
    }

    public static boolean allowCollect(DevNode devNode) {
        try {
            if (!InfoCollectUtil.isA800Zone(devNode)) {
                log.info("allow collect: False, device type is not A800");
                return false;
            }
            return QueryUpgradeStates.parseStatusValueFromResponseInfo(QueryUpgradeStates.getResponseInfo(devNode));
        }
        catch (JSONException e) {
            log.error("get [{}] upgrade status failed", (Object)devNode.getIp(), (Object)e);
            return false;
        }
    }

    private static boolean parseStatusValueFromResponseInfo(ResponseInfo responseInfo) {
        return Optional.ofNullable(responseInfo).map(ResponseInfo::getContent).map(JSON::parseObject).map(content -> content.getString("data")).map(JSON::parseObject).map(data -> data.getInteger(STATUS_KEY)).filter(STATUS_WHICH_ALLOW_COLLECT::contains).isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUpgradeMode(DevNode devNode) {
        try (ICliConnection con = null;){
            String loginMessage22;
            Matcher matcher;
            con = SshConnectionManager.getSshConnection((DevNode)devNode, null, (boolean)true, (boolean)true);
            if (con instanceof SshConnection && (matcher = PATTERN.matcher(loginMessage22 = ((SshConnection)con).getLoginMessage())).find()) {
                log.info("The device is in upgrade mode.");
                boolean bl = true;
                return bl;
            }
            boolean loginMessage22 = false;
            return loginMessage22;
        }
    }
}

