/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.util;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.util.XmlEnums;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SceneDataExtendUtil {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SceneDataExtendUtil.class);
    private static final SceneDataExtendUtil INSTANCE = new SceneDataExtendUtil();
    private static final String DEVICE_INFO = "deviceInfo";
    private static final String DEVICE_ID = "id";
    private static final String SCENE_DATA_EXT_PATH = SceneUtils.getSceneFilePath((String)"sceneSettingDataExtend.xml");
    private static DocumentBuilder documentBuilder = null;

    public static SceneDataExtendUtil getInstance() {
        return INSTANCE;
    }

    public Map<String, Map<String, String>> parseSceneDataExt() {
        HashMap<String, Map<String, String>> sceneDataExtMap = new HashMap<String, Map<String, String>>();
        Document doc = this.getDoc(SCENE_DATA_EXT_PATH);
        if (null == doc) {
            LOGGER.error("Could not found file.");
            return sceneDataExtMap;
        }
        Element root = doc.getDocumentElement();
        NodeList deviceInfoData = root.getElementsByTagName(DEVICE_INFO);
        for (int i = 0; i < deviceInfoData.getLength(); ++i) {
            Node deviceinfoNode = deviceInfoData.item(i);
            HashMap<String, String> deviceInfoMap = new HashMap<String, String>();
            if (!(deviceinfoNode instanceof Element)) continue;
            for (Element infoData : XmlUtils.getChildren((Element)((Element)deviceinfoNode))) {
                String infoKey = infoData.getTagName();
                String infoValue = infoData.getTextContent();
                deviceInfoMap.put(infoKey, infoValue);
            }
            String key = ((Element)deviceinfoNode).getAttribute(DEVICE_ID);
            sceneDataExtMap.put(key, deviceInfoMap);
        }
        return sceneDataExtMap;
    }

    private Document getDoc(String fileName) {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        try {
            builderFactory.setFeature(XmlEnums.DISALLOW_DOCTYPE_DECL.getResourceValue(), true);
            builderFactory.setFeature(XmlEnums.EXTERNAL_GENERAL_ENTITY.getResourceValue(), true);
            builderFactory.setFeature(XmlEnums.EXTERNAL_PARAMETER_ENTITY.getResourceValue(), true);
            documentBuilder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LoggerFactory.getLogger(XmlUtils.class).error("documentBuilder build faild", (Throwable)e);
        }
        Document doc = null;
        try {
            File file = new File(fileName);
            if (StringUtils.isNULLStr((String)fileName)) {
                file = new File(SCENE_DATA_EXT_PATH);
            }
            doc = documentBuilder.parse(file);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Could not found the file.");
        }
        catch (Exception e) {
            LOGGER.error("Could not found the file.", (Throwable)e);
        }
        return doc;
    }
}

