/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.util.excel;

import com.huawei.ism.tool.infocollect.util.excel.ExcelField;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ExcelData {
    public static final Logger log = LoggerFactory.getLogger(ExcelData.class);

    default public Map<String, Object> toDataMap() {
        return Arrays.stream(this.getClass().getDeclaredFields()).collect(Collectors.toMap(this::getDataName, this::getFieldVale));
    }

    default public Object getFieldVale(Field field) {
        try {
            field.setAccessible(true);
            Object value = field.get(this);
            field.setAccessible(false);
            return value == null ? "" : value;
        }
        catch (IllegalAccessException | SecurityException e) {
            log.error("getFieldVale fail", (Throwable)e);
            return "";
        }
    }

    default public String getDataName(Field field) {
        String name = field.isAnnotationPresent(ExcelField.class) ? field.getAnnotation(ExcelField.class).header() : field.getName();
        return name.toLowerCase(Locale.ROOT);
    }
}

