/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.util.excel;

import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.ism.tool.infocollect.util.excel.ExcelData;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);

    public static synchronized void exportData(@NotNull Map<String, List<? extends ExcelData>> sheetDataMap, @NotNull Path targetPath, @NotNull String templateResourcePath) throws ToolException {
        try (FileInputStream fileInputStream = ExcelUtils.getFileStream(targetPath, templateResourcePath);
             XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fileInputStream);){
            sheetDataMap.forEach((sheetName, data) -> ExcelUtils.appendSheetRows(workbook, sheetName, data));
            workbook.write(Files.newOutputStream(targetPath, new OpenOption[0]));
        }
        catch (IOException e) {
            log.error("exportData error.", (Throwable)e);
            throw new ToolException("export.data.error");
        }
    }

    private static void appendSheetRows(XSSFWorkbook workbook, String sheetName, List<? extends ExcelData> exlData) {
        if (CollectionUtils.isEmpty(exlData)) {
            log.warn("skip sheet {} for data is empty.", (Object)sheetName);
            return;
        }
        XSSFSheet sheet = workbook.getSheet(sheetName);
        if (sheet == null) {
            log.warn("skip sheet {} for it is not exist.", (Object)sheetName);
            return;
        }
        List<String> sheetHeader = ExcelUtils.getSheetHeader(sheet);
        exlData.forEach(rowData -> ExcelUtils.appendRow(sheet, rowData, sheetHeader));
    }

    private static void appendRow(XSSFSheet sheet, ExcelData rowData, List<String> sheetHeader) {
        Map<String, Object> dataMap = rowData.toDataMap();
        XSSFRow row = sheet.createRow(sheet.getLastRowNum() + 1);
        for (int index = 0; index < sheetHeader.size(); ++index) {
            ExcelUtils.createCellWithValue(row, index, dataMap.get(sheetHeader.get(index).toLowerCase(Locale.ROOT)));
        }
    }

    private static void createCellWithValue(XSSFRow row, int index, Object value) {
        if (value == null) {
            return;
        }
        XSSFCell cell = row.createCell(index);
        cell.setCellValue(value.toString());
    }

    private static List<String> getSheetHeader(@NotNull XSSFSheet sheetCpu) {
        XSSFRow row = sheetCpu.getRow(sheetCpu.getFirstRowNum());
        if (row == null) {
            return Collections.emptyList();
        }
        return IntStream.range(row.getFirstCellNum(), row.getLastCellNum()).mapToObj(arg_0 -> ((XSSFRow)row).getCell(arg_0)).map(XSSFCell::getStringCellValue).collect(Collectors.toList());
    }

    private static FileInputStream getFileStream(Path path, String templateResourcePath) throws IOException {
        if (path.toFile().exists()) {
            return new FileInputStream(path.toString());
        }
        try (InputStream resourceStream = ExcelUtils.class.getResourceAsStream(templateResourcePath);){
            if (resourceStream == null) {
                throw new IOException("get resource stream fail");
            }
            Files.copy(resourceStream, path, new CopyOption[0]);
            FileInputStream fileInputStream = new FileInputStream(path.toString());
            return fileInputStream;
        }
    }

    private ExcelUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

