/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infocollect.util.retrofit;

import com.huawei.ism.tool.file.SecurityUtils;
import com.huawei.ism.tool.infocollect.util.retrofit.RetrofitException;
import com.huawei.ism.util.NetUtil;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public final class RetrofitRequestUtils {
    private static final Logger log = LoggerFactory.getLogger(RetrofitRequestUtils.class);
    private static final String REQUEST_FAIL = "retrofit.request.fail";
    private static final X509TrustManager X509_TRUST_MANAGER = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };

    public static <T> T createRequestApi(@NotNull String ip, Class<T> apiClass) {
        return (T)new Retrofit.Builder().baseUrl(RetrofitRequestUtils.createUrl(ip)).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(RetrofitRequestUtils.getUnsafeOkHttpClient()).build().create(apiClass);
    }

    private static String createUrl(String ip) {
        if (NetUtil.isIPV6((String)ip)) {
            return String.format("https://[%s]/", ip);
        }
        return String.format("https://%s/", ip);
    }

    public static <T> T query(Query<Call<T>> query) {
        try {
            return (T)Optional.of(query.query().execute()).map(RetrofitRequestUtils::parseResponse).orElseThrow(() -> new RetrofitException(REQUEST_FAIL));
        }
        catch (IOException exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            throw new RetrofitException(REQUEST_FAIL);
        }
    }

    private static <T> T parseResponse(Response<T> response) {
        if (response.isSuccessful()) {
            return (T)response.body();
        }
        log.info("retrofit message, {}", (Object)response.message());
        try (ResponseBody error = response.errorBody();){
            if (error != null) {
                String message = error.string();
                log.error("retrofit request fail, {}", (Object)message);
            }
        }
        catch (IOException e) {
            log.error("retrofit get errorBody failed.", (Throwable)e);
        }
        throw new RetrofitException(REQUEST_FAIL);
    }

    private static OkHttpClient getUnsafeOkHttpClient() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            SecureRandom random = (SecureRandom)SecurityUtils.createSecureRandom().orElseThrow(() -> new NoSuchAlgorithmException("No such algorithm found."));
            sslContext.init(null, new TrustManager[]{X509_TRUST_MANAGER}, random);
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            return new OkHttpClient.Builder().sslSocketFactory(sslSocketFactory, X509_TRUST_MANAGER).hostnameVerifier((hostname, session) -> true).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.error("getUnsafeOkHttpClient failed.", (Throwable)e);
            throw new RetrofitException("retrofit.create.client.fail");
        }
    }

    private RetrofitRequestUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface Query<T> {
        public T query() throws IOException;
    }
}

