# -*- coding: UTF-8 -*-
from cbb.frame.cli import cliUtil
import traceback
import re
import time
from cbb.frame.ruleConfig import common


# 配置涉及该预警的产品型号和版本

RISK_VERSION_DICT = {"V500R007C60SPC300": 305, "6.0.1": 6}


class CheckBmcUpgrade:
    def __init__(
        self, data_dict, logger,
    ):
        self.data_dict = data_dict
        self.cli = data_dict["ssh"]
        self.lang = data_dict.get("lang")
        self.logger = logger
        self.all_ret_list = list()

    def execute_check(self, product_ver, path_ver, cur_patch_version):
        """
        @summary: 		BMC后台升级检查
        @param cli: CLI连接
        @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
        """

        # 判断当前系统型号和版本是否存在风险
        try:
            # 查询产品型号
            self.logger.info(
                self.data_dict,
                "product_ver{},path_ver{},cur_path".format(
                    product_ver, path_ver, cur_patch_version
                ),
            )
            flag = self.check_risk_version(
                product_ver, path_ver, cur_patch_version
            )
            if flag is not True:
                return True
            if self.check_bmc_alarm() is not True:
                return True
            return False
        except Exception:
            self.logger.error(self.data_dict, str(traceback.format_exc()))
            return False

    def check_risk_version(
        self, soft_version, patch_version, cur_patch_version
    ):
        """
        检查是否为风险版本
        :return: 有风险的为True
        """
        if not cur_patch_version:
            (_, _, _, _, history_version,) = common.get_ver_hot_his_version(
                self.cli, self.lang
            )
            cur_patch_version = (
                history_version if history_version is not False else "0"
            )
        for risk_version, risk_path in RISK_VERSION_DICT.items():
            if risk_version not in soft_version:
                continue
            pattern_hot_patch = re.compile(r"SPH(\d+)", flags=re.IGNORECASE)
            match_hot_path = pattern_hot_patch.search(patch_version)
            mat_cur_patch_ver = pattern_hot_patch.search(cur_patch_version)
            self.logger.info(
                self.data_dict,
                "match_hot_path.group(1):" + match_hot_path.group(1),
            )
            cur_path_num = (
                0 if not mat_cur_patch_ver else int(mat_cur_patch_ver.group(1))
            )
            self.logger.info(
                self.data_dict,
                "cur_path_num{},hot_path_num{}:".format(
                    cur_path_num, match_hot_path.group(1)
                ),
            )

            if not mat_cur_patch_ver and risk_path <= int(
                match_hot_path.group(1)
            ):
                self.logger.info(
                    self.data_dict, "not cur path has bmc risk path."
                )
                return True
            if cur_path_num < risk_path <= int(match_hot_path.group(1)):
                self.logger.info(self.data_dict, "has bmc risk path.")
                return True
            return False
        return False

    def check_bmc_alarm(self):
        """
        轮询查看是否有BMC升级失败的告警，如果有则反馈失败
        :return:
        """
        wait_total_time = 10 * 60
        while wait_total_time > 0:
            cmd = (
                "show alarm |filterRow column=ID predict=equal_to "
                "value=0xF00C90150"
            )
            flag, ret, err_msg = cliUtil.excuteCmdInCliMode(
                self.cli, cmd, True, self.lang
            )
            alarm_dict = cliUtil.getHorizontalCliRet(ret)
            if alarm_dict:
                return True
            time.sleep(30)
            wait_total_time -= 30
        return False
