# -*- coding: UTF-8 -*-

#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.

from cbb.business.operate.expansion import common
from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil

# 进度总剩余时间
LIMIT_TIME = 20
# 进度刷新间隔
INTERVAL = 2


def execute(context):
    '''
    @summary: 检查控制器CPU利用率
    '''
    logger = common.getLogger(context.get("logger"), __file__)
    try:
        # 进度条刷新
        common.threadUpProcess(context, LIMIT_TIME, INTERVAL)
        # 进度开始
        common.inProcess(context)

        resultDict = {"flag": True, "errMsg": "", "suggestion": ""}

        lang = contextUtil.getLang(context)
        cli = contextUtil.getCli(context)
        # 查询控制器信息
        cmd = "show controller general"
        cliRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        cliRetLinesList = cliUtil.getVerticalCliRetFilterElabel(cliRet[1], False)
        if not cliRet[0] or len(cliRetLinesList) == 0:
            logger.logNoPass("Can not get controller info.")
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "old.get.cpu.usage.failure")
            contextUtil.handleFailure(context, resultDict)
            return

        for retDict in cliRetLinesList:
            ctrlId = str(retDict.get("Controller"))
            cpuUsage = int(retDict.get("CPU Usage(%)"))
            if int(cpuUsage) > common.MAX_CPU_USAGE:
                logger.logNoPass("The controller[%s] CPU usage is higher than %s" % (ctrlId, common.MAX_CPU_USAGE))
                resultDict["flag"] = False
                resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "old.cpu.usage.check.failure",
                                                                               "%s%s" % (common.MAX_CPU_USAGE, "%"))
                contextUtil.handleFailure(context, resultDict)
                return

        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        # 进度条刷为完成状态
        common.finishProcess(context)
