# -*- coding: UTF-8 -*-
import ast
from cbb.frame.base import jsonUtil as cbbJsonUtil

def getJsonStr(obj):
    '''
    @summary: 将字典或集合类型数据结构转成json字符串
    @param obj: 字典或集合类型数据结构
    '''
    if type(obj) == dict:
        return dict2JsonStr(obj)

    if type(obj) == list:
        strObj = "["
        metFirst = False
        for index in range(0, len(obj)):
            strDict = dict2JsonStr(obj[index])
            if True == metFirst:
                strObj = strObj + ', ' + strDict
            else:
                strObj = strObj + strDict
                metFirst = True
        strObj = strObj + ']'
        return strObj

    return ""


def dict2JsonStr(obj):
    '''
    @summary: 将字典类型数据结构转成json字符串
    @param obj: 字典类型数据结构
    '''
    return cbbJsonUtil.dict2JsonStr(obj)


def jsonStr2Dict(strJson):
    '''
    @summary: 将json字符串转成字典数据结构
    @param strJson: json字符串
    '''
    return ast.literal_eval(strJson)


def dictList2JsonArray(dictList):
    '''
    @summary: 将字典的集合转换为json数组
    @param dictList: 字典列表集合
    @return: json数组
    '''
    jsonArray = []
    for d in dictList:
        jsonArray.append("{%s}" % ",".join(['"%s":"%s"' % (key, d.get(key)) for key in d.keys()]))
    return "[%s]" % ",".join(jsonArray)


def list2JsonArray(strList):
    '''
    @summary: 将字典的集合转换为json数组
    @param strList: 字符串列表
    @return: json数组
    '''
    return "[%s]" % ",".join(strList)


def jsonArray2DictList(jsonArray):
    '''
    @summary: 将json数组转换为字典的集合
    @param jsonArray: json数组
    @return: json数组对应的字典的集合
    '''
    if jsonArray is None or len(jsonArray) <= 2:
        return None
    jsonArray = jsonArray[1:-1]
    resultDictList = []
    for items in jsonArray.split("},{"):
        resultDict = {}
        for item in items.split("\",\""):
            kv = item.replace("{", "").replace("}", "").replace("\"", "").split(":")
            if len(kv) != 2:
                return resultDictList
            resultDict[kv[0]] = kv[1]
        if len(resultDict.keys()) > 0:
            resultDictList.append(resultDict.copy())

    return resultDictList


def dictListDict2JsonArray(dictListDict):
    '''
    @summary: 将字典列表字典转换为json
    @param jsonArray: json数组
    @return: json数组对应的字典的集合
    '''
    d1StrList = []
    for d2 in dictListDict.keys():
        if d2 != "columns":
            d1StrList.append('"%s":"%s"' % (d2, dictListDict.get(d2)))
            continue

        colList = dictListDict.get(d2)
        d2StrList = []
        for d3 in colList:
            d3StrList = []
            for e in d3.keys():
                if e != "content":
                    d3StrList.append('"%s":"%s"' % (e, d3.get(e)))
                    continue
                contentStr = dict2JsonStr(d3.get(e))
                d3StrList.append('"%s":%s' % (e, contentStr))
            d2StrList.append('{%s}' % (','.join(d3StrList)))

        d1StrList.append('"%s":[%s]' % (d2, ','.join(d2StrList)))
    rowItemsJsonArray = '{%s}' % (','.join(d1StrList))
    return rowItemsJsonArray


def dumpsObj(val):
    """递归算法获取python对象的json字符串

    Note: 未充分测试,慎用。

    :param val:
    :return:
    """
    if isinstance(val, str):
        return '"' + val + '"'
    elif isinstance(val, int):
        return str(val)
    elif isinstance(val, list):
        return dumpsList(val)
    elif isinstance(val, dict):
        return dumpsDict(val)

    return '"' + str(val) + '"'


def dumpsDict(obj):
    """将字典类型数据结构转成json字符串

    :param obj:字典类型数据结构
    :return:
    """
    strLeftDictMark = "{"
    strRightDictMark = "}"
    jsonStr = ""

    metFirst = False
    for (key, value) in obj.items():
        if metFirst:
            jsonStr = jsonStr + ', ' + dumpsObj(key) + ': ' + dumpsObj(value)
        else:
            jsonStr = strLeftDictMark + dumpsObj(key) + ': ' + dumpsObj(value)
            metFirst = True

    jsonStr = jsonStr + strRightDictMark

    return jsonStr


def dumpsList(dictList):
    """将列表类型数据结构转成json字符串

    :param dictList:
    :return:
    """
    listLeftMark = '['
    listRightMark = ']'
    jsonStr = listLeftMark
    dictJsonLines = []
    for item in dictList:
        itemJson = dumpsObj(item)
        dictJsonLines.append(itemJson)

    jsonRet = jsonStr + ', '.join(dictJsonLines) + listRightMark
    return jsonRet


def decodeUtf8ToUnicode(dictObj):
    if type(dictObj) == dict:
        # 逐一将字典的key和value转换为unicode
        newDict = {}
        for (key, value) in dictObj.items():
            newKey = unicode(key, "utf-8")
            newValue = unicode(value, "utf-8")
            newDict[newKey] = newValue
        return newDict
    else:
        return None
